/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.async;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.apache.gobblin.async.BufferedRecord;
import org.apache.gobblin.async.Callback;
import org.apache.gobblin.net.Request;

public class AsyncRequest<D, RQ>
implements Request<RQ> {
    private RQ rawRequest;
    protected final List<Thunk<D>> thunks = new ArrayList<Thunk<D>>();
    private long byteSize = 0L;

    public int getRecordCount() {
        return this.thunks.size();
    }

    public long getBytesWritten() {
        return this.byteSize;
    }

    public List<Thunk<D>> getThunks() {
        return ImmutableList.copyOf(this.thunks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markRecord(BufferedRecord<D> record, int bytesWritten) {
        AsyncRequest asyncRequest = this;
        synchronized (asyncRequest) {
            this.thunks.add(new Thunk<D>(record, bytesWritten));
            this.byteSize += (long)bytesWritten;
        }
    }

    @Override
    public RQ getRawRequest() {
        return this.rawRequest;
    }

    public void setRawRequest(RQ rawRequest) {
        this.rawRequest = rawRequest;
    }

    public static final class Thunk<D> {
        @Deprecated
        public final Callback callback;
        public final int sizeInBytes;
        public final BufferedRecord<D> record;

        @Deprecated
        Thunk(Callback callback, int sizeInBytes) {
            this.callback = callback;
            this.sizeInBytes = sizeInBytes;
            this.record = null;
        }

        Thunk(BufferedRecord<D> record, int sizeInBytes) {
            this.callback = record.getCallback();
            this.sizeInBytes = sizeInBytes;
            this.record = record;
        }
    }
}

