/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter.string;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.List;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.Converter;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.converter.SchemaConversionException;
import org.apache.gobblin.converter.SingleRecordIterable;
import org.apache.gobblin.util.ForkOperatorUtils;

public class StringSplitterToListConverter
extends Converter<String, String, String, List<String>> {
    private Splitter splitter;
    private boolean shouldTrimResults;

    public Converter<String, String, String, List<String>> init(WorkUnitState workUnit) {
        String stringSplitterDelimiterKey = ForkOperatorUtils.getPropertyNameForBranch((WorkUnitState)workUnit, (String)"converter.string.splitter.delimiter");
        Preconditions.checkArgument((boolean)workUnit.contains(stringSplitterDelimiterKey), (Object)("Cannot use " + ((Object)((Object)this)).getClass().getName() + " with out specifying " + "converter.string.splitter.delimiter"));
        this.splitter = Splitter.on((String)workUnit.getProp(stringSplitterDelimiterKey));
        this.shouldTrimResults = workUnit.getPropAsBoolean("converter.string.splitter.shouldITrimResults", false);
        return this;
    }

    public String convertSchema(String inputSchema, WorkUnitState workUnit) throws SchemaConversionException {
        return inputSchema;
    }

    public Iterable<List<String>> convertRecord(String outputSchema, String inputRecord, WorkUnitState workUnit) throws DataConversionException {
        List convertedRecord = this.shouldTrimResults ? this.splitter.omitEmptyStrings().trimResults().splitToList((CharSequence)inputRecord) : this.splitter.splitToList((CharSequence)inputRecord);
        return new SingleRecordIterable((Object)convertedRecord);
    }
}

