/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.destination;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.gobblin.configuration.SourceState;
import org.apache.gobblin.destination.DestinationDatasetHandler;
import org.apache.gobblin.destination.DestinationDatasetHandlerFactory;
import org.apache.gobblin.metrics.event.EventSubmitter;
import org.apache.gobblin.source.workunit.WorkUnitStream;
import org.apache.gobblin.util.JobLauncherUtils;

public class DestinationDatasetHandlerService
implements Closeable {
    List<DestinationDatasetHandler> handlers = new ArrayList<DestinationDatasetHandler>();

    public DestinationDatasetHandlerService(SourceState jobState, Boolean canCleanUp, EventSubmitter eventSubmitter) {
        if (jobState.contains("gobblin.destination.datasetHandlerClass")) {
            List handlerList = jobState.getPropAsList("gobblin.destination.datasetHandlerClass");
            for (String handlerClass : handlerList) {
                this.handlers.add(DestinationDatasetHandlerFactory.newInstance(handlerClass, jobState, canCleanUp));
            }
        }
    }

    public void executeHandlers(WorkUnitStream workUnitStream) {
        if (this.handlers.size() > 0) {
            if (workUnitStream.isSafeToMaterialize()) {
                List workUnits = JobLauncherUtils.flattenWorkUnits((Collection)workUnitStream.getMaterializedWorkUnitCollection());
                for (DestinationDatasetHandler handler : this.handlers) {
                    try {
                        handler.handle(workUnits);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(String.format("Handler %s failed to execute", handler.getClass().getName()), e);
                    }
                }
            } else {
                throw new RuntimeException(DestinationDatasetHandlerService.class.getName() + " does not support work unit streams");
            }
        }
    }

    @Override
    public void close() throws IOException {
        for (DestinationDatasetHandler handler : this.handlers) {
            handler.close();
        }
    }
}

