/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.security.ssl;

import com.typesafe.config.Config;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.io.FileUtils;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.password.PasswordManager;
import org.apache.gobblin.util.ConfigUtils;

public class SSLContextFactory {
    public static final String KEY_STORE_FILE_PATH = "keyStoreFilePath";
    public static final String KEY_STORE_PASSWORD = "keyStorePassword";
    public static final String KEY_STORE_TYPE = "keyStoreType";
    public static final String TRUST_STORE_FILE_PATH = "trustStoreFilePath";
    public static final String TRUST_STORE_PASSWORD = "trustStorePassword";
    public static final String DEFAULT_ALGORITHM = "SunX509";
    public static final String DEFAULT_PROTOCOL = "TLS";
    public static final String JKS_STORE_TYPE_NAME = "JKS";
    public static final String P12_STORE_TYPE_NAME = "PKCS12";

    public static SSLContext createInstance(File keyStoreFile, String keyStorePassword, String keyStoreType, File trustStoreFile, String trustStorePassword) {
        if (!keyStoreType.equalsIgnoreCase(P12_STORE_TYPE_NAME) && !keyStoreType.equalsIgnoreCase(JKS_STORE_TYPE_NAME)) {
            throw new IllegalArgumentException("Unsupported keyStoreType: " + keyStoreType);
        }
        try {
            KeyStore keyStore = KeyStore.getInstance(keyStoreType);
            keyStore.load(SSLContextFactory.toInputStream(keyStoreFile), keyStorePassword.toCharArray());
            KeyStore trustStore = KeyStore.getInstance(JKS_STORE_TYPE_NAME);
            trustStore.load(SSLContextFactory.toInputStream(trustStoreFile), trustStorePassword.toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(DEFAULT_ALGORITHM);
            kmf.init(keyStore, keyStorePassword.toCharArray());
            TrustManagerFactory trustFact = TrustManagerFactory.getInstance(DEFAULT_ALGORITHM);
            trustFact.init(trustStore);
            SSLContext sslContext = SSLContext.getInstance(DEFAULT_PROTOCOL);
            sslContext.init(kmf.getKeyManagers(), trustFact.getTrustManagers(), null);
            return sslContext;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static SSLContext createInstance(Config srcConfig) {
        String keyStoreFilePath = srcConfig.getString(KEY_STORE_FILE_PATH);
        String trustStoreFilePath = srcConfig.getString(TRUST_STORE_FILE_PATH);
        PasswordManager passwdMgr = PasswordManager.getInstance((State)ConfigUtils.configToState((Config)srcConfig));
        String keyStorePassword = passwdMgr.readPassword(srcConfig.getString(KEY_STORE_PASSWORD));
        String trustStorePassword = passwdMgr.readPassword(srcConfig.getString(TRUST_STORE_PASSWORD));
        return SSLContextFactory.createInstance(new File(keyStoreFilePath), keyStorePassword, srcConfig.getString(KEY_STORE_TYPE), new File(trustStoreFilePath), trustStorePassword);
    }

    private static InputStream toInputStream(File storeFile) throws IOException {
        byte[] data = FileUtils.readFileToByteArray((File)storeFile);
        return new ByteArrayInputStream(data);
    }
}

