/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.filebased;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Scanner;
import org.apache.gobblin.configuration.ConfigurationKeys;
import org.apache.gobblin.source.extractor.filebased.FileBasedExtractor;
import org.apache.gobblin.source.extractor.filebased.FileBasedHelperException;
import org.apache.gobblin.source.extractor.filebased.FileDownloader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenizedFileDownloader
extends FileDownloader<String> {
    private static final Logger log = LoggerFactory.getLogger(TokenizedFileDownloader.class);
    public static final String DEFAULT_TOKEN = "\n";
    private String token;
    private String charset;

    public TokenizedFileDownloader(FileBasedExtractor<?, ?> fileBasedExtractor) {
        this(fileBasedExtractor, DEFAULT_TOKEN, ConfigurationKeys.DEFAULT_CHARSET_ENCODING.name());
    }

    public TokenizedFileDownloader(FileBasedExtractor<?, ?> fileBasedExtractor, String token, String charset) {
        super(fileBasedExtractor);
        this.token = token;
        this.charset = charset;
    }

    @Override
    public Iterator<String> downloadFile(String filePath) throws IOException {
        Preconditions.checkArgument((this.token != null ? 1 : 0) != 0);
        try {
            log.info("downloading file: " + filePath);
            InputStream inputStream = (InputStream)this.fileBasedExtractor.getCloser().register((Closeable)this.fileBasedExtractor.getFsHelper().getFileStream(filePath));
            return new RecordIterator(inputStream, this.token, this.charset);
        }
        catch (FileBasedHelperException e) {
            throw new IOException("Exception when trying to download file " + filePath, e);
        }
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    @VisibleForTesting
    protected static class RecordIterator
    implements Iterator<String> {
        Scanner scanner;

        public RecordIterator(InputStream inputStream, String delimiter, String charSet) {
            this.scanner = new Scanner(inputStream, charSet).useDelimiter(delimiter);
        }

        @Override
        public boolean hasNext() {
            boolean hasNextRecord = this.scanner.hasNext();
            if (!hasNextRecord) {
                this.scanner.close();
            }
            return hasNextRecord;
        }

        @Override
        public String next() {
            return this.hasNext() ? this.scanner.next() : null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported.");
        }
    }
}

