/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.utils;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import org.apache.gobblin.configuration.ConfigurationKeys;

public class InputStreamCSVReader {
    private final StreamTokenizer parser;
    private final char separator;
    private int maxFieldCount;
    private boolean atEOF;
    private BufferedReader bufferedReader;

    public InputStreamCSVReader(Reader input) {
        this(new BufferedReader(input));
    }

    public InputStreamCSVReader(InputStream input) {
        this(new InputStreamReader(input, ConfigurationKeys.DEFAULT_CHARSET_ENCODING));
    }

    public InputStreamCSVReader(BufferedReader input) {
        this(input, ',', '\"');
    }

    public InputStreamCSVReader(String input) {
        this(new InputStreamReader((InputStream)new ByteArrayInputStream(input.getBytes(ConfigurationKeys.DEFAULT_CHARSET_ENCODING)), ConfigurationKeys.DEFAULT_CHARSET_ENCODING), ',', '\"');
    }

    public InputStreamCSVReader(Reader input, char customizedSeparator) {
        this(new BufferedReader(input), customizedSeparator, '\"');
    }

    public InputStreamCSVReader(InputStream input, char customizedSeparator) {
        this(new InputStreamReader(input, ConfigurationKeys.DEFAULT_CHARSET_ENCODING), customizedSeparator, '\"');
    }

    public InputStreamCSVReader(BufferedReader input, char customizedSeparator) {
        this(input, customizedSeparator, '\"');
    }

    public InputStreamCSVReader(String input, char customizedSeparator) {
        this(new InputStreamReader((InputStream)new ByteArrayInputStream(input.getBytes(ConfigurationKeys.DEFAULT_CHARSET_ENCODING)), ConfigurationKeys.DEFAULT_CHARSET_ENCODING), customizedSeparator, '\"');
    }

    public InputStreamCSVReader(Reader input, char customizedSeparator, char enclosedChar) {
        this(new BufferedReader(input), customizedSeparator, enclosedChar);
    }

    public InputStreamCSVReader(InputStream input, char customizedSeparator, char enclosedChar) {
        this(new InputStreamReader(input, ConfigurationKeys.DEFAULT_CHARSET_ENCODING), customizedSeparator, enclosedChar);
    }

    public InputStreamCSVReader(String input, char customizedSeparator, char enclosedChar) {
        this(new InputStreamReader((InputStream)new ByteArrayInputStream(input.getBytes(ConfigurationKeys.DEFAULT_CHARSET_ENCODING)), ConfigurationKeys.DEFAULT_CHARSET_ENCODING), customizedSeparator, enclosedChar);
    }

    public InputStreamCSVReader(BufferedReader input, char separator, char enclosedChar) {
        this.bufferedReader = input;
        this.separator = separator;
        this.parser = new StreamTokenizer(input);
        this.parser.ordinaryChars(0, 255);
        this.parser.wordChars(0, 255);
        this.parser.ordinaryChar(enclosedChar);
        this.parser.ordinaryChar(separator);
        this.parser.eolIsSignificant(true);
        this.parser.whitespaceChars(10, 10);
        this.parser.whitespaceChars(13, 13);
        this.atEOF = false;
    }

    public ArrayList<String> splitRecord() throws IOException {
        ArrayList<String> record = this.getNextRecordFromStream();
        return record;
    }

    public ArrayList<String> nextRecord() throws IOException {
        ArrayList<String> record = this.getNextRecordFromStream();
        while (record != null) {
            String val;
            boolean emptyLine = false;
            if (record.size() == 0) {
                emptyLine = true;
            } else if (record.size() == 1 && ((val = record.get(0)) == null || val.length() == 0)) {
                emptyLine = true;
            }
            if (!emptyLine) break;
            record = this.getNextRecordFromStream();
        }
        return record;
    }

    private ArrayList<String> getNextRecordFromStream() throws IOException {
        if (this.atEOF) {
            return null;
        }
        ArrayList<String> record = new ArrayList<String>(this.maxFieldCount);
        StringBuilder fieldValue = null;
        while (true) {
            int nextToken;
            int token;
            if ((token = this.parser.nextToken()) == -1) {
                InputStreamCSVReader.addField(record, fieldValue);
                this.atEOF = true;
                break;
            }
            if (token == 10) {
                InputStreamCSVReader.addField(record, fieldValue);
                break;
            }
            if (token == this.separator) {
                InputStreamCSVReader.addField(record, fieldValue);
                fieldValue = null;
                continue;
            }
            if (token == -3) {
                if (fieldValue != null) {
                    throw new CSVParseException("Unknown error", this.parser.lineno());
                }
                fieldValue = new StringBuilder(this.parser.sval);
                continue;
            }
            if (token != 34) continue;
            if (fieldValue != null) {
                throw new CSVParseException("Found unescaped quote. A value with quote should be within a quote", this.parser.lineno());
            }
            while (true) {
                if ((token = this.parser.nextToken()) == -1) {
                    this.atEOF = true;
                    throw new CSVParseException("EOF reached before closing an opened quote", this.parser.lineno());
                }
                if (token == this.separator) {
                    fieldValue = InputStreamCSVReader.appendFieldValue(fieldValue, token);
                    continue;
                }
                if (token == 10) {
                    fieldValue = InputStreamCSVReader.appendFieldValue(fieldValue, "\n");
                    continue;
                }
                if (token == -3) {
                    fieldValue = InputStreamCSVReader.appendFieldValue(fieldValue, this.parser.sval);
                    continue;
                }
                if (token != 34) continue;
                nextToken = this.parser.nextToken();
                if (nextToken != 34) break;
                fieldValue = InputStreamCSVReader.appendFieldValue(fieldValue, nextToken);
            }
            if (nextToken == -3) {
                throw new CSVParseException("Not expecting more text after end quote", this.parser.lineno());
            }
            this.parser.pushBack();
        }
        if (record.size() > this.maxFieldCount) {
            this.maxFieldCount = record.size();
        }
        return record;
    }

    private static StringBuilder appendFieldValue(StringBuilder fieldValue, int token) {
        return InputStreamCSVReader.appendFieldValue(fieldValue, "" + (char)token);
    }

    private static StringBuilder appendFieldValue(StringBuilder fieldValue, String token) {
        if (fieldValue == null) {
            fieldValue = new StringBuilder();
        }
        fieldValue.append(token);
        return fieldValue;
    }

    private static void addField(ArrayList<String> record, StringBuilder fieldValue) {
        record.add(fieldValue == null ? null : fieldValue.toString());
    }

    public void close() throws IOException {
        this.bufferedReader.close();
    }

    public static class CSVParseException
    extends IOException {
        private static final long serialVersionUID = 1L;
        final int recordNumber;

        CSVParseException(String message, int lineno) {
            super(message);
            this.recordNumber = lineno;
        }

        CSVParseException(int i) {
            this.recordNumber = i;
        }

        public int getRecordNumber() {
            return this.recordNumber;
        }
    }
}

