/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.watermark;

import com.google.common.base.Preconditions;
import com.google.common.math.DoubleMath;
import java.math.RoundingMode;
import java.util.HashMap;
import org.apache.gobblin.source.extractor.extract.QueryBasedExtractor;
import org.apache.gobblin.source.extractor.utils.Utils;
import org.apache.gobblin.source.extractor.watermark.Watermark;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleWatermark
implements Watermark {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleWatermark.class);
    private static final int deltaForNextWatermark = 1;
    private String watermarkColumn;

    public SimpleWatermark(String watermarkColumn, String watermarkFormat) {
        this.watermarkColumn = watermarkColumn;
    }

    @Override
    public String getWatermarkCondition(QueryBasedExtractor<?, ?> extractor, long watermarkValue, String operator) {
        return Utils.getCoalesceColumnNames(this.watermarkColumn) + " " + operator + " " + watermarkValue;
    }

    @Override
    public int getDeltaNumForNextWatermark() {
        return 1;
    }

    @Override
    public HashMap<Long, Long> getIntervals(long lowWatermarkValue, long highWatermarkValue, long partitionInterval, int maxIntervals) {
        Preconditions.checkArgument((partitionInterval >= 1L ? 1 : 0) != 0, (Object)"Invalid value for partitionInterval, value should be at least 1.");
        Preconditions.checkArgument((maxIntervals > 0 ? 1 : 0) != 0, (Object)"Invalid value for maxIntervals, positive value expected.");
        HashMap<Long, Long> intervalMap = new HashMap<Long, Long>();
        long interval = SimpleWatermark.getInterval(lowWatermarkValue, highWatermarkValue, partitionInterval, maxIntervals);
        LOG.info("Recalculated partition interval:" + interval);
        if (interval == 0L) {
            return intervalMap;
        }
        long startNum = lowWatermarkValue;
        long endNum = highWatermarkValue;
        boolean longOverflow = false;
        if (startNum == endNum) {
            intervalMap.put(startNum, endNum);
            return intervalMap;
        }
        while (startNum < endNum && !longOverflow) {
            longOverflow = Long.MAX_VALUE - interval < startNum;
            long nextNum = longOverflow ? endNum : Math.min(startNum + interval, endNum);
            intervalMap.put(startNum, nextNum);
            startNum = nextNum;
        }
        return intervalMap;
    }

    private static long getInterval(long lowWatermarkValue, long highWatermarkValue, long partitionInterval, int maxIntervals) {
        if (lowWatermarkValue > highWatermarkValue) {
            LOG.info("lowWatermarkValue: " + lowWatermarkValue + " is greater than highWatermarkValue: " + highWatermarkValue);
            return 0L;
        }
        long outputInterval = partitionInterval;
        boolean longOverflow = false;
        long totalIntervals = Long.MAX_VALUE;
        try {
            totalIntervals = DoubleMath.roundToLong((double)((double)highWatermarkValue / (double)partitionInterval - (double)lowWatermarkValue / (double)partitionInterval), (RoundingMode)RoundingMode.CEILING);
        }
        catch (ArithmeticException e) {
            longOverflow = true;
        }
        if (longOverflow || totalIntervals > (long)maxIntervals) {
            outputInterval = DoubleMath.roundToLong((double)((double)highWatermarkValue / (double)maxIntervals - (double)lowWatermarkValue / (double)maxIntervals), (RoundingMode)RoundingMode.CEILING);
        }
        return outputInterval;
    }

    public static long adjustWatermark(String baseWatermark, int diff) {
        return Long.parseLong(baseWatermark) + (long)diff;
    }
}

