/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer;

import java.io.IOException;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.writer.DataWriter;
import org.apache.gobblin.writer.DataWriterBuilder;
import org.apache.gobblin.writer.RetryWriter;
import org.apache.gobblin.writer.ThrottleWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataWriterWrapperBuilder<D>
extends DataWriterBuilder<Void, D> {
    private static final Logger LOG = LoggerFactory.getLogger(DataWriterWrapperBuilder.class);
    private final DataWriter<D> writer;
    private final State state;

    public DataWriterWrapperBuilder(DataWriter<D> writer, State state) {
        this.writer = writer;
        this.state = state;
    }

    public DataWriter<D> build() throws IOException {
        Object wrapped = this.writer;
        if (this.state.contains("gobblin.writer.throttle_rate") && this.state.contains("gobblin.writer.throttle_type")) {
            wrapped = new ThrottleWriter<D>(wrapped, this.state);
        }
        if (this.state.getPropAsBoolean("gobblin.writer.retry.enabled", true)) {
            wrapped = new RetryWriter<D>(wrapped, this.state);
        }
        return wrapped;
    }
}

