/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer;

import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.writer.AvroDataWriterBuilder;
import org.apache.hadoop.fs.Path;

public class SchemaBasedPartitionedDataWriterBuilder
extends AvroDataWriterBuilder {
    @Override
    protected String getPartitionedFileName(State properties, String originalFileName) {
        Schema schema = this.getSchema();
        if (schema != null) {
            return new Path(schema.getName(), originalFileName).toString();
        }
        return originalFileName;
    }

    public Schema getSchema() {
        if (this.partition.isPresent()) {
            String schemaString = ((GenericRecord)this.partition.get()).get("schemaString").toString();
            this.withSchema(new Schema.Parser().parse(schemaString));
            return (Schema)this.schema;
        }
        return null;
    }

    @Override
    public boolean validatePartitionSchema(Schema partitionSchema) {
        return partitionSchema.getField("schemaString") != null;
    }
}

