/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer.test;

import com.google.common.base.Optional;
import com.google.common.eventbus.EventBus;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.util.ForkOperatorUtils;
import org.apache.gobblin.util.WriterUtils;
import org.apache.gobblin.writer.DataWriter;
import org.apache.gobblin.writer.DataWriterBuilder;
import org.apache.gobblin.writer.test.TestingEventBuses;

public class GobblinTestEventBusWriter
implements DataWriter<Object> {
    private final EventBus _eventBus;
    private final AtomicLong _recordCount = new AtomicLong();
    private final Mode _mode;
    private long _firstRecordTimestamp;
    private long _lastRecordTimestamp;
    public static final String EVENTBUSID_KEY = "GobblinTestEventBusWriter.eventBusId";
    public static final String MODE_KEY = "GobblinTestEventBusWriter.mode";
    public static final String FULL_EVENTBUSID_KEY = "writer.GobblinTestEventBusWriter.eventBusId";
    public static final String FULL_MODE_KEY = "writer.GobblinTestEventBusWriter.mode";

    public GobblinTestEventBusWriter(EventBus eventBus, Mode mode) {
        this._eventBus = eventBus;
        this._mode = mode;
    }

    public GobblinTestEventBusWriter(String eventBusId, Mode mode) {
        this(TestingEventBuses.getEventBus(eventBusId), mode);
    }

    public void close() throws IOException {
    }

    public void write(Object record) throws IOException {
        if (this._firstRecordTimestamp == 0L) {
            this._firstRecordTimestamp = System.currentTimeMillis();
        }
        if (this._mode == Mode.POST_RECORDS) {
            this._eventBus.post((Object)new TestingEventBuses.Event(record));
        }
        this._lastRecordTimestamp = System.currentTimeMillis();
        this._recordCount.incrementAndGet();
    }

    public void commit() throws IOException {
        if (this._mode == Mode.COUNTING) {
            this._eventBus.post((Object)new TestingEventBuses.Event(new RunSummary(this._recordCount.get(), this._lastRecordTimestamp - this._firstRecordTimestamp)));
        }
    }

    public void cleanup() throws IOException {
    }

    public long recordsWritten() {
        return this._recordCount.get();
    }

    public long bytesWritten() throws IOException {
        return this._recordCount.get();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class RunSummary {
        private final long recordsWritten;
        private final long timeElapsedMillis;

        public RunSummary(long recordsWritten, long timeElapsedMillis) {
            this.recordsWritten = recordsWritten;
            this.timeElapsedMillis = timeElapsedMillis;
        }

        public long getRecordsWritten() {
            return this.recordsWritten;
        }

        public long getTimeElapsedMillis() {
            return this.timeElapsedMillis;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RunSummary)) {
                return false;
            }
            RunSummary other = (RunSummary)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getRecordsWritten() != other.getRecordsWritten()) {
                return false;
            }
            return this.getTimeElapsedMillis() == other.getTimeElapsedMillis();
        }

        protected boolean canEqual(Object other) {
            return other instanceof RunSummary;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $recordsWritten = this.getRecordsWritten();
            result = result * 59 + (int)($recordsWritten >>> 32 ^ $recordsWritten);
            long $timeElapsedMillis = this.getTimeElapsedMillis();
            result = result * 59 + (int)($timeElapsedMillis >>> 32 ^ $timeElapsedMillis);
            return result;
        }

        public String toString() {
            return "GobblinTestEventBusWriter.RunSummary(recordsWritten=" + this.getRecordsWritten() + ", timeElapsedMillis=" + this.getTimeElapsedMillis() + ")";
        }
    }

    public static class Builder
    extends DataWriterBuilder<Object, Object> {
        private Optional<String> _eventBusId = Optional.absent();

        public String getDefaultEventBusId() {
            String eventBusIdKey;
            State destinationCfg = this.getDestination().getProperties();
            if (destinationCfg.contains(eventBusIdKey = ForkOperatorUtils.getPathForBranch((State)destinationCfg, (String)GobblinTestEventBusWriter.FULL_EVENTBUSID_KEY, (int)this.getBranches(), (int)this.getBranch()))) {
                return destinationCfg.getProp(eventBusIdKey);
            }
            return WriterUtils.getWriterOutputDir((State)destinationCfg, (int)this.getBranches(), (int)this.getBranch()).toString();
        }

        public String getEventBusId() {
            if (!this._eventBusId.isPresent()) {
                this._eventBusId = Optional.of((Object)this.getDefaultEventBusId());
            }
            return (String)this._eventBusId.get();
        }

        public Builder withEventBusId(String eventBusId) {
            this._eventBusId = Optional.of((Object)eventBusId);
            return this;
        }

        public Mode getDefaultMode() {
            try {
                State destinationCfg = this.getDestination().getProperties();
                String modeKey = ForkOperatorUtils.getPathForBranch((State)destinationCfg, (String)GobblinTestEventBusWriter.FULL_MODE_KEY, (int)this.getBranches(), (int)this.getBranch());
                return Mode.valueOf(destinationCfg.getProp(modeKey, Mode.POST_RECORDS.name()).toUpperCase());
            }
            catch (Throwable t) {
                return Mode.POST_RECORDS;
            }
        }

        public GobblinTestEventBusWriter build() throws IOException {
            return new GobblinTestEventBusWriter(this.getEventBusId(), this.getDefaultMode());
        }
    }

    public static enum Mode {
        POST_RECORDS,
        COUNTING;

    }
}

