/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter.avro;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.converter.SchemaConversionException;
import org.apache.gobblin.converter.SingleRecordIterable;
import org.apache.gobblin.converter.ToAvroConverterBase;
import org.apache.gobblin.converter.avro.JsonElementConversionFactory;
import org.apache.gobblin.converter.avro.UnsupportedDateTypeException;
import org.apache.gobblin.converter.json.JsonSchema;
import org.apache.gobblin.util.AvroUtils;
import org.apache.gobblin.util.EmptyIterable;
import org.apache.gobblin.util.WriterUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonIntermediateToAvroConverter
extends ToAvroConverterBase<JsonArray, JsonObject> {
    private static final Logger LOG = LoggerFactory.getLogger(JsonIntermediateToAvroConverter.class);
    private static final String CONVERTER_AVRO_NULLIFY_FIELDS_ENABLED = "converter.avro.nullify.fields.enabled";
    private static final boolean DEFAULT_CONVERTER_AVRO_NULLIFY_FIELDS_ENABLED = Boolean.FALSE;
    private static final String CONVERTER_AVRO_NULLIFY_FIELDS_ORIGINAL_SCHEMA_PATH = "converter.avro.nullify.fields.original.schema.path";
    private JsonElementConversionFactory.RecordConverter recordConverter;

    public Schema convertSchema(JsonArray schema, WorkUnitState workUnit) throws SchemaConversionException {
        try {
            JsonSchema jsonSchema = new JsonSchema(schema);
            jsonSchema.setColumnName(workUnit.getExtract().getTable());
            this.recordConverter = new JsonElementConversionFactory.RecordConverter(jsonSchema, workUnit, workUnit.getExtract().getNamespace());
        }
        catch (UnsupportedDateTypeException e) {
            throw new SchemaConversionException((Throwable)e);
        }
        Schema recordSchema = this.recordConverter.schema();
        if (workUnit.getPropAsBoolean(CONVERTER_AVRO_NULLIFY_FIELDS_ENABLED, DEFAULT_CONVERTER_AVRO_NULLIFY_FIELDS_ENABLED)) {
            return this.generateSchemaWithNullifiedField(workUnit, recordSchema);
        }
        return recordSchema;
    }

    public Iterable<GenericRecord> convertRecord(Schema outputSchema, JsonObject inputRecord, WorkUnitState workUnit) throws DataConversionException {
        Object record = this.recordConverter.convert((JsonElement)inputRecord);
        if (record instanceof EmptyIterable) {
            return (EmptyIterable)record;
        }
        return new SingleRecordIterable((Object)((GenericRecord)this.recordConverter.convert((JsonElement)inputRecord)));
    }

    protected Schema generateSchemaWithNullifiedField(WorkUnitState workUnitState, Schema currentAvroSchema) {
        Configuration conf = new Configuration();
        for (String key : workUnitState.getPropertyNames()) {
            conf.set(key, workUnitState.getProp(key));
        }
        Path originalSchemaPath = null;
        if (workUnitState.contains(CONVERTER_AVRO_NULLIFY_FIELDS_ORIGINAL_SCHEMA_PATH)) {
            originalSchemaPath = new Path(workUnitState.getProp(CONVERTER_AVRO_NULLIFY_FIELDS_ORIGINAL_SCHEMA_PATH));
        } else {
            LOG.info("Property converter.avro.nullify.fields.original.schema.pathis not specified. Trying to get the orignal schema from previous avro files.");
            originalSchemaPath = WriterUtils.getDataPublisherFinalDir((State)workUnitState, (int)workUnitState.getPropAsInt("fork.branches", 1), (int)workUnitState.getPropAsInt("fork.branch.id", 0)).getParent();
        }
        try {
            Schema prevSchema = AvroUtils.getDirectorySchema((Path)originalSchemaPath, (Configuration)conf, (boolean)false);
            Schema mergedSchema = AvroUtils.nullifyFieldsForSchemaMerge((Schema)prevSchema, (Schema)currentAvroSchema);
            return mergedSchema;
        }
        catch (IOException ioe) {
            LOG.error("Unable to nullify fields. Will retain the current avro schema.", (Throwable)ioe);
            return currentAvroSchema;
        }
    }
}

