/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter.filter;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.linkedin.avroutil1.compatibility.AvroCompatibilityHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.AvroToAvroConverterBase;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.converter.SchemaConversionException;
import org.apache.gobblin.converter.SingleRecordIterable;
import org.apache.gobblin.util.AvroUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroFieldsPickConverter
extends AvroToAvroConverterBase {
    private static final Logger LOG = LoggerFactory.getLogger(AvroFieldsPickConverter.class);
    private static final Splitter SPLITTER_ON_COMMA = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private static final Splitter SPLITTER_ON_DOT = Splitter.on((char)'.').trimResults().omitEmptyStrings();

    public Schema convertSchema(Schema inputSchema, WorkUnitState workUnit) throws SchemaConversionException {
        LOG.info("Converting schema " + inputSchema);
        String fieldsStr = workUnit.getProp("converter.avro.fields");
        Preconditions.checkNotNull((Object)fieldsStr, (Object)("converter.avro.fields is required for converter " + ((Object)((Object)this)).getClass().getSimpleName()));
        LOG.info("Converting schema to selected fields: " + fieldsStr);
        try {
            return AvroFieldsPickConverter.createSchema(inputSchema, fieldsStr);
        }
        catch (Exception e) {
            throw new SchemaConversionException((Throwable)e);
        }
    }

    private static Schema createSchema(Schema schema, String fieldsStr) {
        List fields = SPLITTER_ON_COMMA.splitToList((CharSequence)fieldsStr);
        TrieNode root = AvroFieldsPickConverter.buildTrie(fields);
        return AvroFieldsPickConverter.createSchemaHelper(schema, root);
    }

    private static Schema createSchemaHelper(Schema inputSchema, TrieNode node) {
        ArrayList newFields = Lists.newArrayList();
        for (TrieNode child : node.children.values()) {
            Schema recordSchema = AvroFieldsPickConverter.getActualRecord(inputSchema);
            Schema.Field innerSrcField = recordSchema.getField(child.val);
            Preconditions.checkNotNull((Object)innerSrcField, (Object)(child.val + " does not exist under " + recordSchema));
            if (child.children.isEmpty()) {
                newFields.add(AvroCompatibilityHelper.createSchemaField((String)innerSrcField.name(), (Schema)innerSrcField.schema(), (String)innerSrcField.doc(), (Object)AvroUtils.getCompatibleDefaultValue((Schema.Field)innerSrcField)));
                continue;
            }
            Schema innerSrcSchema = innerSrcField.schema();
            Schema innerDestSchema = AvroFieldsPickConverter.createSchemaHelper(innerSrcSchema, child);
            Schema.Field innerDestField = AvroCompatibilityHelper.createSchemaField((String)innerSrcField.name(), (Schema)innerDestSchema, (String)innerSrcField.doc(), (Object)AvroUtils.getCompatibleDefaultValue((Schema.Field)innerSrcField));
            newFields.add(innerDestField);
        }
        if (Schema.Type.UNION.equals((Object)inputSchema.getType())) {
            Preconditions.checkArgument((inputSchema.getTypes().size() <= 2 ? 1 : 0) != 0, (Object)"For union type in nested record, it should only have NULL and Record type");
            Schema recordSchema = AvroFieldsPickConverter.getActualRecord(inputSchema);
            Schema newRecord = Schema.createRecord((String)recordSchema.getName(), (String)recordSchema.getDoc(), (String)recordSchema.getNamespace(), (boolean)recordSchema.isError());
            newRecord.setFields((List)newFields);
            if (inputSchema.getTypes().size() == 1) {
                return Schema.createUnion((Schema[])new Schema[]{newRecord});
            }
            return Schema.createUnion((List)Lists.newArrayList((Object[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), newRecord}));
        }
        Schema newRecord = Schema.createRecord((String)inputSchema.getName(), (String)inputSchema.getDoc(), (String)inputSchema.getNamespace(), (boolean)inputSchema.isError());
        newRecord.setFields((List)newFields);
        return newRecord;
    }

    private static Schema getActualRecord(Schema inputSchema) {
        if (Schema.Type.RECORD.equals((Object)inputSchema.getType())) {
            return inputSchema;
        }
        Preconditions.checkArgument((boolean)Schema.Type.UNION.equals((Object)inputSchema.getType()), (Object)"Nested schema is only support with either record or union type of null with record");
        Preconditions.checkArgument((inputSchema.getTypes().size() <= 2 ? 1 : 0) != 0, (Object)"For union type in nested record, it should only have NULL and Record type");
        for (Schema inner : inputSchema.getTypes()) {
            if (Schema.Type.NULL.equals((Object)inner.getType())) continue;
            Preconditions.checkArgument((boolean)Schema.Type.RECORD.equals((Object)inner.getType()), (Object)"For union type in nested record, it should only have NULL and Record type");
            return inner;
        }
        throw new IllegalArgumentException(inputSchema + " is not supported.");
    }

    private static TrieNode buildTrie(List<String> fqns) {
        TrieNode root = new TrieNode(null);
        for (String fqn : fqns) {
            root.add(fqn);
        }
        return root;
    }

    public Iterable<GenericRecord> convertRecordImpl(Schema outputSchema, GenericRecord inputRecord, WorkUnitState workUnit) throws DataConversionException {
        try {
            return new SingleRecordIterable((Object)AvroUtils.convertRecordSchema((GenericRecord)inputRecord, (Schema)outputSchema));
        }
        catch (IOException e) {
            throw new DataConversionException((Throwable)e);
        }
    }

    private static class TrieNode {
        private String val;
        private Map<String, TrieNode> children;

        TrieNode(String val) {
            this.val = val;
            this.children = Maps.newLinkedHashMap();
        }

        void add(String fqn) {
            this.addHelper(this, SPLITTER_ON_DOT.splitToList((CharSequence)fqn).iterator(), fqn);
        }

        void addHelper(TrieNode node, Iterator<String> fqnIterator, String fqn) {
            if (!fqnIterator.hasNext()) {
                return;
            }
            String val = fqnIterator.next();
            TrieNode child = node.children.get(val);
            if (child == null) {
                child = new TrieNode(val);
                node.children.put(val, child);
            } else if (!fqnIterator.hasNext()) {
                throw new IllegalArgumentException("Duplicate record detected: " + fqn);
            }
            this.addHelper(child, fqnIterator, fqn);
        }

        public String toString() {
            return "[val: " + this.val + " , children: " + this.children.values() + " ]";
        }
    }
}

