/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter.filter;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.AvroToAvroConverterBase;
import org.apache.gobblin.converter.Converter;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.converter.EmptyIterable;
import org.apache.gobblin.converter.SchemaConversionException;
import org.apache.gobblin.converter.SingleRecordIterable;
import org.apache.gobblin.util.AvroUtils;

public class AvroFilterConverter
extends AvroToAvroConverterBase {
    private String fieldName;
    private String fieldValue;

    public Converter<Schema, Schema, GenericRecord, GenericRecord> init(WorkUnitState workUnit) {
        Preconditions.checkArgument((boolean)workUnit.contains("converter.filter.field"), (Object)"Missing required property converter.filter.field for the AvroFilterConverter class.");
        Preconditions.checkArgument((boolean)workUnit.contains("converter.filter.value"), (Object)"Missing required property converter.filter.value for the AvroFilterConverter class.");
        this.fieldName = workUnit.getProp("converter.filter.field");
        this.fieldValue = workUnit.getProp("converter.filter.value");
        return super.init(workUnit);
    }

    public Schema convertSchema(Schema inputSchema, WorkUnitState workUnit) throws SchemaConversionException {
        return inputSchema;
    }

    public Iterable<GenericRecord> convertRecordImpl(Schema outputSchema, GenericRecord inputRecord, WorkUnitState workUnit) throws DataConversionException {
        Optional fieldValue = AvroUtils.getFieldValue((GenericRecord)inputRecord, (String)this.fieldName);
        if (fieldValue.isPresent() && fieldValue.get().toString().equals(this.fieldValue)) {
            return new SingleRecordIterable((Object)inputRecord);
        }
        return new EmptyIterable();
    }
}

