/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.destination;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.gobblin.configuration.SourceState;
import org.apache.gobblin.destination.DestinationDatasetHandler;
import org.apache.gobblin.destination.DestinationDatasetHandlerFactory;
import org.apache.gobblin.metrics.event.EventSubmitter;
import org.apache.gobblin.source.workunit.WorkUnitStream;

public class DestinationDatasetHandlerService
implements Closeable {
    List<DestinationDatasetHandler> handlers = new ArrayList<DestinationDatasetHandler>();

    public DestinationDatasetHandlerService(SourceState jobState, Boolean canCleanUp, EventSubmitter eventSubmitter) {
        if (jobState.contains("gobblin.destination.datasetHandlerClass")) {
            List handlerList = jobState.getPropAsList("gobblin.destination.datasetHandlerClass");
            for (String handlerClass : handlerList) {
                this.handlers.add(DestinationDatasetHandlerFactory.newInstance(handlerClass, jobState, canCleanUp));
            }
        }
    }

    public WorkUnitStream executeHandlers(WorkUnitStream workUnitStream) {
        for (DestinationDatasetHandler handler : this.handlers) {
            try {
                workUnitStream = handler.handle(workUnitStream);
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Handler %s failed to execute", handler.getClass().getName()), e);
            }
        }
        return workUnitStream;
    }

    @Override
    public void close() throws IOException {
        for (DestinationDatasetHandler handler : this.handlers) {
            handler.close();
        }
    }
}

