/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.publisher;

import java.io.IOException;
import java.util.Collections;
import org.apache.gobblin.broker.ImmediatelyInvalidResourceEntry;
import org.apache.gobblin.broker.ResourceInstance;
import org.apache.gobblin.broker.iface.ConfigView;
import org.apache.gobblin.broker.iface.NotConfiguredException;
import org.apache.gobblin.broker.iface.ScopeType;
import org.apache.gobblin.broker.iface.ScopedConfigView;
import org.apache.gobblin.broker.iface.SharedResourceFactory;
import org.apache.gobblin.broker.iface.SharedResourceFactoryResponse;
import org.apache.gobblin.broker.iface.SharedResourceKey;
import org.apache.gobblin.broker.iface.SharedResourcesBroker;
import org.apache.gobblin.capability.Capability;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.publisher.DataPublisher;
import org.apache.gobblin.publisher.DataPublisherKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataPublisherFactory<S extends ScopeType<S>>
implements SharedResourceFactory<DataPublisher, DataPublisherKey, S> {
    private static final Logger log = LoggerFactory.getLogger(DataPublisherFactory.class);
    public static final String FACTORY_NAME = "dataPublisher";

    public static <S extends ScopeType<S>> DataPublisher get(String publisherClassName, State state, SharedResourcesBroker<S> broker) throws IOException {
        try {
            return (DataPublisher)broker.getSharedResource(new DataPublisherFactory<S>(), (SharedResourceKey)new DataPublisherKey(publisherClassName, state));
        }
        catch (NotConfiguredException nce) {
            throw new IOException(nce);
        }
    }

    public static boolean isPublisherCacheable(DataPublisher publisher) {
        return publisher.supportsCapability(Capability.THREADSAFE, Collections.EMPTY_MAP);
    }

    public String getName() {
        return FACTORY_NAME;
    }

    public SharedResourceFactoryResponse<DataPublisher> createResource(SharedResourcesBroker<S> broker, ScopedConfigView<S, DataPublisherKey> config) throws NotConfiguredException {
        try {
            DataPublisherKey key = (DataPublisherKey)config.getKey();
            String publisherClassName = key.getPublisherClassName();
            State state = key.getState();
            Class<?> dataPublisherClass = Class.forName(publisherClassName);
            log.info("Creating data publisher with class {} in scope {}. ", (Object)publisherClassName, (Object)config.getScope().toString());
            DataPublisher publisher = DataPublisher.getInstance(dataPublisherClass, (State)state);
            if (DataPublisherFactory.isPublisherCacheable(publisher)) {
                return new ResourceInstance((Object)publisher);
            }
            return new ImmediatelyInvalidResourceEntry((Object)publisher);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public S getAutoScope(SharedResourcesBroker<S> broker, ConfigView<S, DataPublisherKey> config) {
        return (S)broker.selfScope().getType();
    }
}

