/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.publisher;

import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import java.io.IOException;
import java.util.Set;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.publisher.BaseDataPublisher;
import org.apache.gobblin.util.ParallelRunner;
import org.apache.gobblin.util.WriterUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;

public class TimestampDataPublisher
extends BaseDataPublisher {
    private final String timestamp = String.valueOf(System.currentTimeMillis());

    public TimestampDataPublisher(State state) throws IOException {
        super(state);
    }

    @Override
    protected void publishData(WorkUnitState state, int branchId, boolean publishSingleTaskData, Set<Path> writerOutputPathsMoved) throws IOException {
        Path publisherOutputDir = this.getPublisherOutputDir(state, branchId);
        if (!((FileSystem)this.publisherFileSystemByBranches.get(branchId)).exists(publisherOutputDir)) {
            WriterUtils.mkdirsWithRecursivePermissionWithRetry((FileSystem)((FileSystem)this.publisherFileSystemByBranches.get(branchId)), (Path)publisherOutputDir, (FsPermission)((FsPermission)this.permissions.get(branchId)), (Config)this.retryerConfig);
        }
        super.publishData(state, branchId, publishSingleTaskData, writerOutputPathsMoved);
    }

    @Override
    protected void movePath(ParallelRunner parallelRunner, State state, Path src, Path dst, int branchId) throws IOException {
        String outputDir = dst.getParent().toString();
        String schemaName = dst.getName();
        Path newDst = new Path(new Path(outputDir, this.getDbTableName(schemaName)), this.timestamp);
        if (!((FileSystem)this.publisherFileSystemByBranches.get(branchId)).exists(newDst)) {
            WriterUtils.mkdirsWithRecursivePermissionWithRetry((FileSystem)((FileSystem)this.publisherFileSystemByBranches.get(branchId)), (Path)newDst.getParent(), (FsPermission)((FsPermission)this.permissions.get(branchId)), (Config)this.retryerConfig);
        }
        super.movePath(parallelRunner, state, src, newDst, branchId);
    }

    private String getDbTableName(String schemaName) {
        Preconditions.checkArgument((boolean)schemaName.matches(".+_.+_.+"));
        return schemaName.replaceFirst("_", ".").substring(0, schemaName.lastIndexOf(95));
    }
}

