/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.recordaccess;

import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericArray;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.util.Utf8;
import org.apache.gobblin.recordaccess.FieldDoesNotExistException;
import org.apache.gobblin.recordaccess.IncorrectTypeException;
import org.apache.gobblin.recordaccess.RecordAccessor;
import org.apache.gobblin.util.AvroUtils;

public class AvroGenericRecordAccessor
implements RecordAccessor {
    private final GenericRecord record;

    public AvroGenericRecordAccessor(GenericRecord record) {
        this.record = record;
    }

    public Map<String, String> getMultiAsString(String fieldName) {
        Map<String, Object> vals = this.getMultiGeneric(fieldName);
        HashMap<String, String> ret = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : vals.entrySet()) {
            Object val = entry.getValue();
            String convertedVal = this.convertToString(entry.getKey(), val);
            if (convertedVal == null) continue;
            ret.put(entry.getKey(), convertedVal);
        }
        return ret;
    }

    public String getAsString(String fieldName) {
        Object obj = this.getAsObject(fieldName);
        return this.convertToString(fieldName, obj);
    }

    private String convertToString(String fieldName, Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Utf8) {
            return obj.toString();
        }
        return this.castOrThrowTypeException(fieldName, obj, String.class);
    }

    public Map<String, Integer> getMultiAsInt(String fieldName) {
        Map<String, Object> vals = this.getMultiGeneric(fieldName);
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        for (Map.Entry<String, Object> entry : vals.entrySet()) {
            Object val = entry.getValue();
            Integer convertedVal = this.convertToInt(entry.getKey(), val);
            if (convertedVal == null) continue;
            ret.put(entry.getKey(), convertedVal);
        }
        return ret;
    }

    public Integer getAsInt(String fieldName) {
        return this.convertToInt(fieldName, this.getAsObject(fieldName));
    }

    private Integer convertToInt(String fieldName, Object obj) {
        return this.castOrThrowTypeException(fieldName, obj, Integer.class);
    }

    public Map<String, Long> getMultiAsLong(String fieldName) {
        Map<String, Object> vals = this.getMultiGeneric(fieldName);
        HashMap<String, Long> ret = new HashMap<String, Long>();
        for (Map.Entry<String, Object> entry : vals.entrySet()) {
            Object val = entry.getValue();
            Long convertedVal = this.convertToLong(entry.getKey(), val);
            if (convertedVal == null) continue;
            ret.put(entry.getKey(), convertedVal);
        }
        return ret;
    }

    public Long getAsLong(String fieldName) {
        return this.convertToLong(fieldName, this.getAsObject(fieldName));
    }

    private Long convertToLong(String fieldName, Object obj) {
        if (obj instanceof Integer) {
            return ((Integer)obj).longValue();
        }
        return this.castOrThrowTypeException(fieldName, obj, Long.class);
    }

    private <T> T castOrThrowTypeException(String fieldName, Object o, Class<? extends T> clazz) {
        try {
            if (o == null) {
                return null;
            }
            return clazz.cast(o);
        }
        catch (ClassCastException e) {
            throw new IncorrectTypeException("Incorrect type for field " + fieldName, (Throwable)e);
        }
    }

    private Object getAsObject(String fieldName) {
        Optional obj = AvroUtils.getFieldValue((GenericRecord)this.record, (String)fieldName);
        return obj.isPresent() ? obj.get() : null;
    }

    public Map<String, Object> getMultiGeneric(String fieldName) {
        Map vals = AvroUtils.getMultiFieldValue((GenericRecord)this.record, (String)fieldName);
        for (Map.Entry entry : vals.entrySet()) {
            vals.put(entry.getKey(), this.convertAvroToJava((String)entry.getKey(), entry.getValue()));
        }
        return vals;
    }

    public Object getGeneric(String fieldName) {
        Object val = this.getAsObject(fieldName);
        return this.convertAvroToJava(fieldName, val);
    }

    private Object convertAvroToJava(String fieldName, Object val) {
        if (val == null || val instanceof String || val instanceof Long || val instanceof Integer) {
            return val;
        }
        if (val instanceof Utf8) {
            return this.convertToString(fieldName, val);
        }
        if (val instanceof GenericArray) {
            return this.convertToList(fieldName, (GenericArray)val);
        }
        throw new IllegalArgumentException("Don't know how to parse object of type " + val.getClass().getCanonicalName());
    }

    public void set(String fieldName, String value) {
        this.set(fieldName, (Object)value);
    }

    public void set(String fieldName, Integer value) {
        this.set(fieldName, (Object)value);
    }

    public void set(String fieldName, Long value) {
        this.set(fieldName, (Object)value);
    }

    public void setStringArray(String fieldName, List<String> value) {
        GenericData.Array avroArray = new GenericData.Array(Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.STRING)), value);
        this.set(fieldName, avroArray);
    }

    public void setToNull(String fieldName) {
        this.set(fieldName, (Object)null);
    }

    private void set(String fieldName, Object value) {
        try {
            Iterator levels = Splitter.on((String)".").split((CharSequence)fieldName).iterator();
            GenericRecord toInsert = this.record;
            String subField = (String)levels.next();
            Object subRecord = toInsert;
            while (levels.hasNext()) {
                if (subRecord instanceof GenericRecord) {
                    subRecord = subRecord.get(subField);
                } else if (subRecord instanceof List) {
                    subRecord = ((List)subRecord).get(Integer.parseInt(subField));
                } else if (subRecord instanceof Map) {
                    subRecord = ((Map)subRecord).get(subField);
                }
                if (subRecord == null) {
                    throw new FieldDoesNotExistException("Field " + subField + " not found when trying to set " + fieldName);
                }
                subField = (String)levels.next();
            }
            if (!(subRecord instanceof GenericRecord)) {
                throw new IllegalArgumentException("Field " + fieldName + " does not refer to a record type.");
            }
            toInsert = subRecord;
            Object oldValue = toInsert.get(subField);
            toInsert.put(subField, value);
            Schema.Field changedField = toInsert.getSchema().getField(subField);
            GenericData genericData = GenericData.get();
            boolean valid = genericData.validate(changedField.schema(), genericData.getField((Object)toInsert, changedField.name(), changedField.pos()));
            if (!valid) {
                toInsert.put(subField, oldValue);
                throw new IncorrectTypeException("Incorrect type - can't insert a " + value.getClass().getCanonicalName() + " into an Avro record of type " + changedField.schema().getType().toString());
            }
        }
        catch (AvroRuntimeException e) {
            throw new FieldDoesNotExistException("Field not found setting name " + fieldName, (Throwable)e);
        }
    }

    private List convertToList(String fieldName, GenericArray arr) {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (int i = 0; i < arr.size(); ++i) {
            ret.add(this.convertAvroToJava(fieldName + "." + String.valueOf(i), arr.get(i)));
        }
        return ret;
    }
}

