/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.extract.restapi;

import com.google.common.base.Charsets;
import com.google.common.io.Closer;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.http.HttpClientConfiguratorLoader;
import org.apache.gobblin.source.extractor.exception.RestApiConnectionException;
import org.apache.gobblin.source.extractor.exception.RestApiProcessingException;
import org.apache.gobblin.source.extractor.extract.Command;
import org.apache.gobblin.source.extractor.extract.CommandOutput;
import org.apache.gobblin.source.extractor.extract.restapi.RestApiCommand;
import org.apache.gobblin.source.extractor.extract.restapi.RestApiCommandOutput;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RestApiConnector
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(RestApiConnector.class);
    public static final String REST_API_CONNECTOR_CLASS = "rest.api.connector.class";
    protected static final Gson GSON = new Gson();
    protected HttpClient httpClient = null;
    protected boolean autoEstablishAuthToken = false;
    protected long authTokenTimeout;
    protected String accessToken = null;
    protected long createdAt;
    protected String instanceUrl;
    protected String updatedQuery;
    protected Closer closer = Closer.create();
    protected final State state;

    public RestApiConnector(State state) {
        this.state = state;
        this.authTokenTimeout = state.getPropAsInt("source.conn.timeout", 500000);
    }

    @Override
    public void close() throws IOException {
        this.closer.close();
        if (this.getHttpClient() != null && !(this.getHttpClient() instanceof Closeable)) {
            log.warn("httpClient is not closable, we will only close the idle connections");
            this.getHttpClient().getConnectionManager().closeIdleConnections(0L, TimeUnit.MILLISECONDS);
        }
    }

    public boolean connect() throws RestApiConnectionException {
        if (this.autoEstablishAuthToken) {
            if (this.authTokenTimeout <= 0L) {
                return false;
            }
            if (System.currentTimeMillis() - this.createdAt > this.authTokenTimeout) {
                return false;
            }
        }
        HttpEntity httpEntity = null;
        try {
            httpEntity = this.getAuthentication();
            if (httpEntity != null) {
                JsonElement json = (JsonElement)GSON.fromJson(EntityUtils.toString((HttpEntity)httpEntity), JsonObject.class);
                if (json == null) {
                    log.error("Http entity: " + httpEntity);
                    log.error("entity class: " + httpEntity.getClass().getName());
                    log.error("entity string size: " + EntityUtils.toString((HttpEntity)httpEntity).length());
                    log.error("content length: " + httpEntity.getContentLength());
                    log.error("content: " + IOUtils.toString((InputStream)httpEntity.getContent(), (Charset)Charsets.UTF_8));
                    throw new RestApiConnectionException("JSON is NULL ! Failed on authentication with the following HTTP response received:\n" + EntityUtils.toString((HttpEntity)httpEntity));
                }
                JsonObject jsonRet = json.getAsJsonObject();
                log.info("jsonRet: " + jsonRet.toString());
                this.parseAuthenticationResponse(jsonRet);
            }
        }
        catch (IOException e) {
            throw new RestApiConnectionException("Failed to get rest api connection; error - " + e.getMessage(), e);
        }
        finally {
            if (httpEntity != null) {
                try {
                    EntityUtils.consume((HttpEntity)httpEntity);
                }
                catch (IOException e) {
                    throw new RestApiConnectionException("Failed to consume httpEntity; error - " + e.getMessage(), e);
                }
            }
        }
        return true;
    }

    protected HttpClient getHttpClient() {
        if (this.httpClient == null) {
            HttpClientConfiguratorLoader configuratorLoader = new HttpClientConfiguratorLoader(this.state);
            this.httpClient = configuratorLoader.getConfigurator().setStatePropertiesPrefix("source.conn.").configure(this.state).createClient();
            if (this.httpClient instanceof Closeable) {
                this.closer.register((Closeable)this.httpClient);
            }
        }
        return this.httpClient;
    }

    private static boolean hasId(JsonObject json) {
        return json.has("id") || json.has("Id") || json.has("ID") || json.has("iD");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CommandOutput<?, ?> getResponse(List<Command> cmds) throws RestApiProcessingException {
        String url = cmds.get(0).getParams().get(0);
        log.info("URL: " + url);
        String jsonStr = null;
        HttpGet httpRequest = new HttpGet(url);
        this.addHeaders((HttpRequestBase)httpRequest);
        HttpEntity httpEntity = null;
        HttpResponse httpResponse = null;
        try {
            httpResponse = this.httpClient.execute((HttpUriRequest)httpRequest);
            StatusLine status = httpResponse.getStatusLine();
            httpEntity = httpResponse.getEntity();
            if (httpEntity != null) {
                jsonStr = EntityUtils.toString((HttpEntity)httpEntity);
            }
            if (status.getStatusCode() >= 400) {
                log.info("Unable to get response using {} with status code {}: {}", new Object[]{url, status.getStatusCode(), jsonStr});
                JsonElement jsonRet = (JsonElement)GSON.fromJson(jsonStr, JsonArray.class);
                throw new RestApiProcessingException(RestApiConnector.getFirstErrorMessage("Failed to retrieve response from ", jsonRet));
            }
        }
        catch (Exception e) {
            try {
                throw new RestApiProcessingException("Failed to process rest api request; error - " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                try {
                    if (httpEntity != null) {
                        EntityUtils.consume(httpEntity);
                    }
                    if (!(httpResponse instanceof Closeable)) throw throwable;
                    this.closer.register((Closeable)httpResponse);
                    throw throwable;
                }
                catch (Exception e2) {
                    throw new RestApiProcessingException("Failed to consume httpEntity; error - " + e2.getMessage(), e2);
                }
            }
        }
        try {
            if (httpEntity != null) {
                EntityUtils.consume((HttpEntity)httpEntity);
            }
            if (httpResponse instanceof Closeable) {
                this.closer.register((Closeable)httpResponse);
            }
        }
        catch (Exception e) {
            throw new RestApiProcessingException("Failed to consume httpEntity; error - " + e.getMessage(), e);
        }
        RestApiCommandOutput output = new RestApiCommandOutput();
        output.put((RestApiCommand)cmds.get(0), jsonStr);
        return output;
    }

    protected void addHeaders(HttpRequestBase httpRequest) {
        if (this.accessToken != null) {
            httpRequest.addHeader("Authorization", "OAuth " + this.accessToken);
        }
        httpRequest.addHeader("Content-Type", "application/json");
    }

    private static String getFirstErrorMessage(String defaultMessage, JsonElement json) {
        if (json == null) {
            return defaultMessage;
        }
        JsonObject jsonObject = null;
        if (!json.isJsonArray()) {
            jsonObject = json.getAsJsonObject();
        } else {
            JsonArray jsonArray = json.getAsJsonArray();
            if (jsonArray.size() != 0) {
                jsonObject = jsonArray.get(0).getAsJsonObject();
            }
        }
        if (jsonObject != null) {
            if (jsonObject.has("error_description")) {
                defaultMessage = defaultMessage + jsonObject.get("error_description").getAsString();
            } else if (jsonObject.has("message")) {
                defaultMessage = defaultMessage + jsonObject.get("message").getAsString();
            }
        }
        return defaultMessage;
    }

    public static List<Command> constructGetCommand(String restQuery) {
        return Arrays.asList(new RestApiCommand().build(Arrays.asList(restQuery), RestApiCommand.RestApiCommandType.GET));
    }

    public boolean isConnectionClosed() {
        return this.httpClient == null;
    }

    public abstract HttpEntity getAuthentication() throws RestApiConnectionException;

    protected void parseAuthenticationResponse(JsonObject jsonRet) throws RestApiConnectionException {
        if (!RestApiConnector.hasId(jsonRet)) {
            throw new RestApiConnectionException("Failed on authentication with the following HTTP response received:" + jsonRet.toString());
        }
        this.instanceUrl = jsonRet.get("instance_url").getAsString();
        this.accessToken = jsonRet.get("access_token").getAsString();
        this.createdAt = System.currentTimeMillis();
    }

    public void setAuthTokenTimeout(long authTokenTimeout) {
        this.authTokenTimeout = authTokenTimeout;
    }
}

