/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.extract.restapi;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.source.extractor.DataRecordException;
import org.apache.gobblin.source.extractor.exception.HighWatermarkException;
import org.apache.gobblin.source.extractor.exception.RecordCountException;
import org.apache.gobblin.source.extractor.exception.RestApiConnectionException;
import org.apache.gobblin.source.extractor.exception.RestApiProcessingException;
import org.apache.gobblin.source.extractor.exception.SchemaException;
import org.apache.gobblin.source.extractor.extract.CommandOutput;
import org.apache.gobblin.source.extractor.extract.QueryBasedExtractor;
import org.apache.gobblin.source.extractor.extract.SourceSpecificLayer;
import org.apache.gobblin.source.extractor.extract.restapi.RestApiConnector;
import org.apache.gobblin.source.extractor.extract.restapi.RestApiSpecificLayer;
import org.apache.gobblin.source.extractor.schema.Schema;
import org.apache.gobblin.source.extractor.utils.Utils;
import org.apache.gobblin.source.extractor.watermark.Predicate;
import org.apache.gobblin.source.workunit.WorkUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RestApiExtractor
extends QueryBasedExtractor<JsonArray, JsonElement>
implements SourceSpecificLayer<JsonArray, JsonElement>,
RestApiSpecificLayer {
    private static final Logger log = LoggerFactory.getLogger(RestApiExtractor.class);
    private static final Gson GSON = new Gson();
    protected String instanceUrl;
    protected String updatedQuery;
    protected final RestApiConnector connector;

    public RestApiExtractor(WorkUnitState state) {
        super(state);
        this.connector = this.getConnector(state);
    }

    protected abstract RestApiConnector getConnector(WorkUnitState var1);

    protected String buildDataQuery(String inputQuery, String entity) {
        String dataQuery = null;
        if (inputQuery == null && this.columnList.size() != 0) {
            dataQuery = "SELECT " + Joiner.on((String)",").join((Iterable)this.columnList) + " FROM " + entity;
        } else if (inputQuery != null) {
            String queryLowerCase = inputQuery.toLowerCase();
            int columnsStartIndex = queryLowerCase.indexOf("select ") + 7;
            int columnsEndIndex = queryLowerCase.indexOf(" from ");
            if (columnsStartIndex > 0 && columnsEndIndex > 0) {
                String givenColumnList = inputQuery.substring(columnsStartIndex, columnsEndIndex);
                dataQuery = inputQuery.replace(givenColumnList, Joiner.on((String)",").join((Iterable)this.columnList));
            } else {
                dataQuery = inputQuery;
            }
        }
        log.info("Updated data query: " + dataQuery);
        return dataQuery;
    }

    protected List<String> extractColumnListInQuery(String query) {
        return Utils.getColumnListFromQuery(query);
    }

    @Override
    public void extractMetadata(String schema, String entity, WorkUnit workUnit) throws SchemaException {
        log.info("Extract Metadata using Rest Api");
        JsonArray columnArray = new JsonArray();
        String inputQuery = this.workUnitState.getProp("source.querybased.query");
        List<String> columnListInQuery = null;
        JsonArray array = null;
        if (!Strings.isNullOrEmpty((String)inputQuery)) {
            columnListInQuery = this.extractColumnListInQuery(inputQuery);
        }
        String excludedColumns = this.workUnitState.getProp("source.querybased.excluded.columns");
        Object columnListExcluded = ImmutableList.of();
        if (Strings.isNullOrEmpty((String)inputQuery) && !Strings.isNullOrEmpty((String)excludedColumns)) {
            Splitter splitter = Splitter.on((String)",").omitEmptyStrings().trimResults();
            columnListExcluded = splitter.splitToList((CharSequence)excludedColumns.toLowerCase());
        }
        try {
            boolean success = this.connector.connect();
            if (!success) {
                throw new SchemaException("Failed to connect.");
            }
            log.debug("Connected successfully.");
            List cmds = this.getSchemaMetadata(schema, entity);
            CommandOutput<?, ?> response = this.connector.getResponse(cmds);
            array = (JsonArray)this.getSchema(response);
            for (JsonElement columnElement : array) {
                Schema obj = (Schema)GSON.fromJson(columnElement, Schema.class);
                String columnName = obj.getColumnName();
                obj.setWaterMark(this.isWatermarkColumn(this.workUnitState.getProp("extract.delta.fields"), columnName));
                if (this.isWatermarkColumn(this.workUnitState.getProp("extract.delta.fields"), columnName)) {
                    obj.setNullable(false);
                } else if (this.getPrimarykeyIndex(this.workUnitState.getProp("extract.primary.key.fields"), columnName) == 0) {
                    obj.setNullable(true);
                }
                obj.setPrimaryKey(this.getPrimarykeyIndex(this.workUnitState.getProp("extract.primary.key.fields"), columnName));
                String jsonStr = GSON.toJson((Object)obj);
                JsonObject jsonObject = ((JsonObject)GSON.fromJson(jsonStr, JsonObject.class)).getAsJsonObject();
                if (inputQuery != null && columnListInQuery != null && (columnListInQuery.size() != 1 || !columnListInQuery.get(0).equals("*")) && (columnListInQuery.size() < 1 || !this.isMetadataColumn(columnName, columnListInQuery)) || columnListExcluded.contains(columnName.trim().toLowerCase())) continue;
                this.columnList.add(columnName);
                columnArray.add((JsonElement)jsonObject);
            }
            this.updatedQuery = this.buildDataQuery(inputQuery, entity);
            log.info("Schema:" + columnArray);
            this.setOutputSchema(columnArray);
        }
        catch (IOException | RuntimeException | RestApiConnectionException | RestApiProcessingException | SchemaException e) {
            throw new SchemaException("Failed to get schema using rest api; error - " + e.getMessage(), e);
        }
    }

    @Override
    public long getMaxWatermark(String schema, String entity, String watermarkColumn, List<Predicate> predicateList, String watermarkSourceFormat) throws HighWatermarkException {
        log.info("Get high watermark using Rest Api");
        long CalculatedHighWatermark = -1L;
        try {
            boolean success = this.connector.connect();
            if (!success) {
                throw new HighWatermarkException("Failed to connect.");
            }
            log.debug("Connected successfully.");
            List cmds = this.getHighWatermarkMetadata(schema, entity, watermarkColumn, predicateList);
            CommandOutput<?, ?> response = this.connector.getResponse(cmds);
            CalculatedHighWatermark = this.getHighWatermark(response, watermarkColumn, watermarkSourceFormat);
            log.info("High watermark:" + CalculatedHighWatermark);
            return CalculatedHighWatermark;
        }
        catch (Exception e) {
            throw new HighWatermarkException("Failed to get high watermark using rest api; error - " + e.getMessage(), e);
        }
    }

    @Override
    public long getSourceCount(String schema, String entity, WorkUnit workUnit, List<Predicate> predicateList) throws RecordCountException {
        log.info("Get source record count using Rest Api");
        long count = 0L;
        try {
            boolean success = this.connector.connect();
            if (!success) {
                throw new RecordCountException("Failed to connect.");
            }
            log.debug("Connected successfully.");
            List cmds = this.getCountMetadata(schema, entity, workUnit, predicateList);
            CommandOutput<?, ?> response = this.connector.getResponse(cmds);
            count = this.getCount(response);
            log.info("Source record count:" + count);
            return count;
        }
        catch (Exception e) {
            throw new RecordCountException("Failed to get record count using rest api; error - " + e.getMessage(), e);
        }
    }

    @Override
    public Iterator<JsonElement> getRecordSet(String schema, String entity, WorkUnit workUnit, List<Predicate> predicateList) throws DataRecordException {
        log.debug("Get data records using Rest Api");
        Iterator rs = null;
        try {
            boolean success = true;
            if (this.connector.isConnectionClosed()) {
                success = this.connector.connect();
            }
            if (!success) {
                throw new DataRecordException("Failed to connect.");
            }
            log.debug("Connected successfully.");
            if (!this.getPullStatus()) {
                return null;
            }
            List cmds = this.getNextUrl() == null ? this.getDataMetadata(schema, entity, workUnit, predicateList) : RestApiConnector.constructGetCommand(this.getNextUrl());
            CommandOutput<?, ?> response = this.connector.getResponse(cmds);
            rs = this.getData(response);
            return rs;
        }
        catch (Exception e) {
            throw new DataRecordException("Failed to get records using rest api; error - " + e.getMessage(), e);
        }
    }

    @Override
    public void setTimeOut(int timeOut) {
        this.connector.setAuthTokenTimeout(timeOut);
    }

    @Override
    public void closeConnection() throws Exception {
        this.connector.close();
    }
}

