/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.hadoop;

import java.io.IOException;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.source.extractor.Extractor;
import org.apache.gobblin.source.extractor.filebased.FileBasedHelperException;
import org.apache.gobblin.source.extractor.filebased.FileBasedSource;
import org.apache.gobblin.source.extractor.hadoop.AvroFileExtractor;
import org.apache.gobblin.source.extractor.hadoop.AvroFsHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroFileSource
extends FileBasedSource<Schema, GenericRecord> {
    private static final Logger log = LoggerFactory.getLogger(AvroFileSource.class);

    public Extractor<Schema, GenericRecord> getExtractor(WorkUnitState state) throws IOException {
        return new AvroFileExtractor(state);
    }

    @Override
    public void initFileSystemHelper(State state) throws FileBasedHelperException {
        this.fsHelper = new AvroFsHelper(state);
        this.fsHelper.connect();
    }

    @Override
    public List<String> getcurrentFsSnapshot(State state) {
        List<String> results;
        String path = state.getProp("source.filebased.data.directory");
        try {
            log.info("Running ls command with input " + path);
            results = this.fsHelper.ls(path);
        }
        catch (FileBasedHelperException e) {
            String errMsg = String.format("Not able to run ls command due to %s. Will not pull any files", e.getMessage());
            log.error(errMsg, (Throwable)e);
            throw new RuntimeException(errMsg, e);
        }
        return results;
    }
}

