/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.hadoop;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.gobblin.configuration.SourceState;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.source.extractor.Extractor;
import org.apache.gobblin.source.extractor.extract.AbstractSource;
import org.apache.gobblin.source.extractor.hadoop.HadoopFileInputExtractor;
import org.apache.gobblin.source.workunit.Extract;
import org.apache.gobblin.source.workunit.WorkUnit;
import org.apache.gobblin.util.HadoopUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.util.ReflectionUtils;

public abstract class HadoopFileInputSource<S, D, K, V>
extends AbstractSource<S, D> {
    private static final String HADOOP_SOURCE_KEY_PREFIX = "source.hadoop.";
    public static final String FILE_INPUT_FORMAT_CLASS_KEY = "source.hadoop.file.input.format.class";
    public static final String FILE_SPLITS_DESIRED_KEY = "source.hadoop.file.splits.desired";
    public static final int DEFAULT_FILE_SPLITS_DESIRED = 1;
    public static final String FILE_INPUT_PATHS_KEY = "source.hadoop.file.input.paths";
    public static final String FILE_INPUT_SPLIT_MINSIZE = "source.hadoop.file.input.split.minsize";
    public static final String FILE_INPUT_SPLIT_MAXSIZE = "source.hadoop.file.input.split.maxsize";
    public static final String FILE_INPUT_READ_KEYS_KEY = "source.hadoop.file.read.keys";
    public static final boolean DEFAULT_FILE_INPUT_READ_KEYS = false;
    public static final String FILE_SPLIT_PATH_KEY = "source.hadoop.file.split.path";
    static final String FILE_SPLIT_BYTES_STRING_KEY = "source.hadoop.file.split.bytes.string";

    public List<WorkUnit> getWorkunits(SourceState state) {
        try {
            FileInputFormat<K, V> fileInputFormat;
            List fileSplits;
            Job job = Job.getInstance((Configuration)new Configuration());
            if (state.contains(FILE_INPUT_PATHS_KEY)) {
                for (String inputPath : state.getPropAsList(FILE_INPUT_PATHS_KEY)) {
                    FileInputFormat.addInputPath((Job)job, (Path)new Path(inputPath));
                }
            }
            if (state.contains(FILE_INPUT_SPLIT_MINSIZE)) {
                FileInputFormat.setMinInputSplitSize((Job)job, (long)state.getPropAsLong(FILE_INPUT_SPLIT_MINSIZE));
            }
            if (state.contains(FILE_INPUT_SPLIT_MAXSIZE)) {
                FileInputFormat.setMaxInputSplitSize((Job)job, (long)state.getPropAsLong(FILE_INPUT_SPLIT_MAXSIZE));
            }
            if ((fileSplits = (fileInputFormat = this.getFileInputFormat((State)state, job.getConfiguration())).getSplits((JobContext)job)) == null || fileSplits.isEmpty()) {
                return ImmutableList.of();
            }
            Extract.TableType tableType = state.contains("extract.table.type") ? Extract.TableType.valueOf((String)state.getProp("extract.table.type").toUpperCase()) : null;
            String tableNamespace = state.getProp("extract.namespace");
            String tableName = state.getProp("extract.table.name");
            ArrayList workUnits = Lists.newArrayListWithCapacity((int)fileSplits.size());
            for (InputSplit inputSplit : fileSplits) {
                FileSplit fileSplit = (FileSplit)inputSplit;
                Extract extract = this.createExtract(tableType, tableNamespace, tableName);
                WorkUnit workUnit = WorkUnit.create((Extract)extract);
                workUnit.setProp(FILE_SPLIT_BYTES_STRING_KEY, (Object)HadoopUtils.serializeToString((Writable)fileSplit));
                workUnit.setProp(FILE_SPLIT_PATH_KEY, (Object)fileSplit.getPath().toString());
                workUnits.add(workUnit);
            }
            return workUnits;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to get workunits", ioe);
        }
    }

    public Extractor<S, D> getExtractor(WorkUnitState workUnitState) throws IOException {
        if (!workUnitState.contains(FILE_SPLIT_BYTES_STRING_KEY)) {
            throw new IOException("No serialized FileSplit found in WorkUnitState " + workUnitState.getId());
        }
        Configuration configuration = new Configuration();
        FileInputFormat<K, V> fileInputFormat = this.getFileInputFormat((State)workUnitState, configuration);
        String fileSplitBytesStr = workUnitState.getProp(FILE_SPLIT_BYTES_STRING_KEY);
        FileSplit fileSplit = (FileSplit)HadoopUtils.deserializeFromString(FileSplit.class, (String)fileSplitBytesStr);
        TaskAttemptContext taskAttemptContext = HadoopFileInputSource.getTaskAttemptContext(configuration, DummyTaskAttemptIDFactory.newTaskAttemptID());
        try {
            RecordReader recordReader = fileInputFormat.createRecordReader((InputSplit)fileSplit, taskAttemptContext);
            recordReader.initialize((InputSplit)fileSplit, taskAttemptContext);
            boolean readKeys = workUnitState.getPropAsBoolean(FILE_INPUT_READ_KEYS_KEY, false);
            return this.getExtractor(workUnitState, recordReader, fileSplit, readKeys);
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    public void shutdown(SourceState state) {
    }

    protected FileInputFormat<K, V> getFileInputFormat(State state, Configuration configuration) {
        Preconditions.checkArgument((boolean)state.contains(FILE_INPUT_FORMAT_CLASS_KEY));
        try {
            return (FileInputFormat)ReflectionUtils.newInstance(Class.forName(state.getProp(FILE_INPUT_FORMAT_CLASS_KEY)), (Configuration)configuration);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe);
        }
    }

    protected abstract HadoopFileInputExtractor<S, D, K, V> getExtractor(WorkUnitState var1, RecordReader<K, V> var2, FileSplit var3, boolean var4);

    private static TaskAttemptContext getTaskAttemptContext(Configuration configuration, TaskAttemptID taskAttemptID) {
        Class<?> taskAttemptContextClass;
        try {
            taskAttemptContextClass = Class.forName("org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl");
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe);
        }
        try {
            return (TaskAttemptContext)taskAttemptContextClass.getDeclaredConstructor(Configuration.class, TaskAttemptID.class).newInstance(configuration, taskAttemptID);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class DummyTaskAttemptIDFactory
    extends TaskAttemptID {
        private DummyTaskAttemptIDFactory() {
        }

        public static TaskAttemptID newTaskAttemptID() {
            return TaskAttemptID.forName((String)("attempt_" + Long.toString(System.currentTimeMillis()) + '_' + 0 + '_' + 'm' + '_' + 0 + '_' + 0));
        }
    }
}

