/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.hive.HiveSerDeWrapper;
import org.apache.gobblin.writer.DataWriter;
import org.apache.gobblin.writer.FsDataWriterBuilder;
import org.apache.gobblin.writer.HiveWritableHdfsDataWriter;
import org.apache.hadoop.hive.serde2.Serializer;
import org.apache.hadoop.io.Writable;

public class HiveWritableHdfsDataWriterBuilder<S>
extends FsDataWriterBuilder<S, Writable> {
    public static final String WRITER_WRITABLE_CLASS = "writer.writable.class";
    public static final String WRITER_OUTPUT_FORMAT_CLASS = "writer.output.format.class";

    public DataWriter<Writable> build() throws IOException {
        Preconditions.checkNotNull((Object)this.destination);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.writerId) ? 1 : 0) != 0);
        State properties = this.destination.getProperties();
        if (!properties.contains(WRITER_WRITABLE_CLASS) || !properties.contains(WRITER_OUTPUT_FORMAT_CLASS)) {
            HiveSerDeWrapper serializer = HiveSerDeWrapper.getSerializer((State)properties);
            properties.setProp(WRITER_WRITABLE_CLASS, (Object)((Serializer)serializer.getSerDe()).getSerializedClass().getName());
            properties.setProp(WRITER_OUTPUT_FORMAT_CLASS, (Object)serializer.getOutputFormatClassName());
        }
        return new HiveWritableHdfsDataWriter(this, properties);
    }

    @Override
    public boolean validatePartitionSchema(Schema partitionSchema) {
        return true;
    }
}

