/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.writer.partitioner;

import com.google.common.base.Enums;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.util.DatePartitionType;
import org.apache.gobblin.util.ForkOperatorUtils;
import org.apache.gobblin.writer.partitioner.WriterPartitioner;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public abstract class TimeBasedWriterPartitioner<D>
implements WriterPartitioner<D> {
    public static final String WRITER_PARTITION_PREFIX = "writer.partition.prefix";
    public static final String WRITER_PARTITION_SUFFIX = "writer.partition.suffix";
    public static final String WRITER_PARTITION_PATTERN = "writer.partition.pattern";
    public static final String WRITER_PARTITION_TIMEZONE = "writer.partition.timezone";
    public static final String DEFAULT_WRITER_PARTITION_TIMEZONE = "America/Los_Angeles";
    public static final String WRITER_PARTITION_TIMEUNIT = "writer.partition.timeUnit";
    public static final String DEFAULT_WRITER_PARTITION_TIMEUNIT = TimeUnit.MILLISECONDS.name();
    public static final String WRITER_PARTITION_GRANULARITY = "writer.partition.granularity";
    public static final DatePartitionType DEFAULT_WRITER_PARTITION_GRANULARITY = DatePartitionType.HOUR;
    public static final String PARTITIONED_PATH = "partitionedPath";
    public static final String PREFIX = "prefix";
    public static final String SUFFIX = "suffix";
    private final String writerPartitionPrefix;
    private final String writerPartitionSuffix;
    private final DatePartitionType granularity;
    private final DateTimeZone timeZone;
    protected final TimeUnit timeUnit;
    private final Optional<DateTimeFormatter> timestampToPathFormatter;
    private final Schema schema;

    public TimeBasedWriterPartitioner(State state, int numBranches, int branchId) {
        this.writerPartitionPrefix = TimeBasedWriterPartitioner.getWriterPartitionPrefix(state, numBranches, branchId);
        this.writerPartitionSuffix = TimeBasedWriterPartitioner.getWriterPartitionSuffix(state, numBranches, branchId);
        this.granularity = TimeBasedWriterPartitioner.getGranularity(state, numBranches, branchId);
        this.timeZone = TimeBasedWriterPartitioner.getTimeZone(state, numBranches, branchId);
        this.timeUnit = TimeBasedWriterPartitioner.getTimeUnit(state, numBranches, branchId);
        this.timestampToPathFormatter = this.getTimestampToPathFormatter(state, numBranches, branchId);
        this.schema = this.getSchema();
    }

    private static String getWriterPartitionPrefix(State state, int numBranches, int branchId) {
        String propName = ForkOperatorUtils.getPropertyNameForBranch((String)WRITER_PARTITION_PREFIX, (int)numBranches, (int)branchId);
        return state.getProp(propName, "");
    }

    private static String getWriterPartitionSuffix(State state, int numBranches, int branchId) {
        String propName = ForkOperatorUtils.getPropertyNameForBranch((String)WRITER_PARTITION_SUFFIX, (int)numBranches, (int)branchId);
        return state.getProp(propName, "");
    }

    private static DatePartitionType getGranularity(State state, int numBranches, int branchId) {
        String propName = ForkOperatorUtils.getPropertyNameForBranch((String)WRITER_PARTITION_GRANULARITY, (int)numBranches, (int)branchId);
        String granularityValue = state.getProp(propName, DEFAULT_WRITER_PARTITION_GRANULARITY.toString());
        Optional granularity = Enums.getIfPresent(DatePartitionType.class, (String)granularityValue.toUpperCase());
        Preconditions.checkState((boolean)granularity.isPresent(), (Object)(granularityValue + " is not a valid writer partition granularity"));
        return (DatePartitionType)granularity.get();
    }

    private Optional<DateTimeFormatter> getTimestampToPathFormatter(State state, int numBranches, int branchId) {
        String propName = ForkOperatorUtils.getPropertyNameForBranch((String)WRITER_PARTITION_PATTERN, (int)numBranches, (int)branchId);
        if (state.contains(propName)) {
            return Optional.of((Object)DateTimeFormat.forPattern((String)state.getProp(propName)).withZone(this.timeZone));
        }
        return Optional.absent();
    }

    private static DateTimeZone getTimeZone(State state, int numBranches, int branchId) {
        String propName = ForkOperatorUtils.getPropertyNameForBranch((String)WRITER_PARTITION_TIMEZONE, (int)numBranches, (int)branchId);
        return DateTimeZone.forID((String)state.getProp(propName, DEFAULT_WRITER_PARTITION_TIMEZONE));
    }

    private static TimeUnit getTimeUnit(State state, int numBranches, int branchId) {
        String propName = ForkOperatorUtils.getPropertyNameForBranch((String)WRITER_PARTITION_TIMEUNIT, (int)numBranches, (int)branchId);
        return TimeUnit.valueOf(state.getProp(propName, DEFAULT_WRITER_PARTITION_TIMEUNIT).toUpperCase());
    }

    private Schema getSchema() {
        if (this.timestampToPathFormatter.isPresent()) {
            return this.getDateTimeFormatBasedSchema();
        }
        return this.getGranularityBasedSchema();
    }

    public Schema partitionSchema() {
        return this.schema;
    }

    public GenericRecord partitionForRecord(D record) {
        long timestamp = this.timeUnit.toMillis(this.getRecordTimestamp(record));
        GenericData.Record partition = new GenericData.Record(this.schema);
        if (!Strings.isNullOrEmpty((String)this.writerPartitionPrefix)) {
            partition.put(PREFIX, (Object)this.writerPartitionPrefix);
        }
        if (!Strings.isNullOrEmpty((String)this.writerPartitionSuffix)) {
            partition.put(SUFFIX, (Object)this.writerPartitionSuffix);
        }
        if (this.timestampToPathFormatter.isPresent()) {
            String partitionedPath = this.getPartitionedPath(timestamp);
            partition.put(PARTITIONED_PATH, (Object)partitionedPath);
        } else {
            DateTime dateTime = new DateTime(timestamp, this.timeZone);
            partition.put(this.granularity.toString(), (Object)this.granularity.getField(dateTime));
        }
        return partition;
    }

    private Schema getDateTimeFormatBasedSchema() {
        SchemaBuilder.FieldAssembler assembler = ((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"GenericRecordTimePartition").namespace("gobblin.writer.partitioner")).fields();
        if (!Strings.isNullOrEmpty((String)this.writerPartitionPrefix)) {
            assembler = assembler.name(PREFIX).type(Schema.create((Schema.Type)Schema.Type.STRING)).noDefault();
        }
        assembler = assembler.name(PARTITIONED_PATH).type(Schema.create((Schema.Type)Schema.Type.STRING)).noDefault();
        if (!Strings.isNullOrEmpty((String)this.writerPartitionSuffix)) {
            assembler = assembler.name(SUFFIX).type(Schema.create((Schema.Type)Schema.Type.STRING)).noDefault();
        }
        return (Schema)assembler.endRecord();
    }

    private Schema getGranularityBasedSchema() {
        SchemaBuilder.FieldAssembler assembler = ((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"GenericRecordTimePartition").namespace("gobblin.writer.partitioner")).fields();
        if (!Strings.isNullOrEmpty((String)this.writerPartitionSuffix)) {
            assembler = assembler.name(SUFFIX).type(Schema.create((Schema.Type)Schema.Type.STRING)).noDefault();
        }
        assembler = assembler.name(this.granularity.toString()).type(Schema.create((Schema.Type)Schema.Type.STRING)).noDefault();
        if (!Strings.isNullOrEmpty((String)this.writerPartitionPrefix)) {
            assembler = assembler.name(PREFIX).type(Schema.create((Schema.Type)Schema.Type.STRING)).noDefault();
        }
        Schema schema = (Schema)assembler.endRecord();
        Collections.reverse(schema.getFields());
        return schema;
    }

    private String getPartitionedPath(long timestamp) {
        return ((DateTimeFormatter)this.timestampToPathFormatter.get()).print(timestamp);
    }

    public abstract long getRecordTimestamp(D var1);

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }
}

