/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.ast.tools;

import java.util.List;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.transform.ImmutableASTTransformation;

public class ConstructorNodeUtils {
    private static final ClassNode EXCEPTION = ClassHelper.make(IllegalArgumentException.class);
    private static final ClassNode IMMUTABLE_TYPE = ClassHelper.make(ImmutableASTTransformation.class);

    private ConstructorNodeUtils() {
    }

    public static ConstructorCallExpression getFirstIfSpecialConstructorCall(Statement code) {
        if (code == null) {
            return null;
        }
        if (code instanceof BlockStatement) {
            BlockStatement block = (BlockStatement)code;
            List<Statement> statementList = block.getStatements();
            if (statementList.isEmpty()) {
                return null;
            }
            return ConstructorNodeUtils.getFirstIfSpecialConstructorCall(statementList.get(0));
        }
        if (!(code instanceof ExpressionStatement)) {
            return null;
        }
        Expression expression = ((ExpressionStatement)code).getExpression();
        if (!(expression instanceof ConstructorCallExpression)) {
            return null;
        }
        ConstructorCallExpression cce = (ConstructorCallExpression)expression;
        if (cce.isSpecialCall()) {
            return cce;
        }
        return null;
    }

    public static Statement checkPropNamesS(VariableExpression namedArgs, boolean pojo, List<PropertyNode> props) {
        if (!pojo) {
            return GeneralUtils.stmt(GeneralUtils.callX(IMMUTABLE_TYPE, "checkPropNames", (Expression)GeneralUtils.args(GeneralUtils.varX("this"), namedArgs)));
        }
        BlockStatement block = new BlockStatement();
        ListExpression knownPropNames = new ListExpression();
        for (PropertyNode pNode : props) {
            knownPropNames.addExpression(GeneralUtils.constX(pNode.getName()));
        }
        VariableExpression validNames = GeneralUtils.localVarX("validNames", ClassHelper.LIST_TYPE);
        Parameter name = GeneralUtils.param(ClassHelper.STRING_TYPE, "arg");
        Statement loopS = GeneralUtils.ifS((Expression)GeneralUtils.notX(GeneralUtils.callX((Expression)validNames, "contains", (Expression)GeneralUtils.varX(name))), GeneralUtils.throwS(GeneralUtils.ctorX(EXCEPTION, GeneralUtils.plusX(GeneralUtils.constX("Unknown named argument: "), GeneralUtils.varX(name)))));
        block.addStatement(GeneralUtils.declS(validNames, knownPropNames));
        block.addStatement(GeneralUtils.forS(name, GeneralUtils.callX(namedArgs, "keySet"), loopS));
        return block;
    }
}

