/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.decompiled;

import groovyjarjarasm.asm.Type;
import groovyjarjarasm.asm.signature.SignatureReader;
import groovyjarjarasm.asm.signature.SignatureVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.groovy.util.ObjectHolder;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.RecordComponentNode;
import org.codehaus.groovy.ast.decompiled.Annotations;
import org.codehaus.groovy.ast.decompiled.AsmDecompiler;
import org.codehaus.groovy.ast.decompiled.AsmReferenceResolver;
import org.codehaus.groovy.ast.decompiled.ClassStub;
import org.codehaus.groovy.ast.decompiled.FormalParameterParser;
import org.codehaus.groovy.ast.decompiled.TypeSignatureParser;

class ClassSignatureParser {
    ClassSignatureParser() {
    }

    static void configureClass(ClassNode classNode, ClassStub stub, AsmReferenceResolver resolver) {
        if (stub.signature != null) {
            ClassSignatureParser.parseClassSignature(classNode, stub.signature, resolver);
            return;
        }
        if (stub.superName != null) {
            classNode.setSuperClass(resolver.resolveClass(AsmDecompiler.fromInternalName(stub.superName)));
        }
        ClassNode[] interfaces = new ClassNode[stub.interfaceNames.length];
        for (int i = 0; i < stub.interfaceNames.length; ++i) {
            interfaces[i] = resolver.resolveClass(AsmDecompiler.fromInternalName(stub.interfaceNames[i]));
        }
        classNode.setInterfaces(interfaces);
        if (!stub.permittedSubclasses.isEmpty()) {
            List<ClassNode> permittedSubclasses = classNode.getPermittedSubclasses();
            for (String name : stub.permittedSubclasses) {
                permittedSubclasses.add(resolver.resolveClass(AsmDecompiler.fromInternalName(name)));
            }
        }
        if (!stub.recordComponents.isEmpty()) {
            classNode.setRecordComponentNodes(stub.recordComponents.stream().map(r -> {
                ClassNode type = resolver.resolveType(Type.getType(r.descriptor));
                final ObjectHolder<ClassNode> typeHolder = new ObjectHolder<ClassNode>(type);
                if (null != r.signature) {
                    new SignatureReader(r.signature).accept(new TypeSignatureParser(resolver){

                        @Override
                        void finished(ClassNode result) {
                            typeHolder.setObject(1.applyErasure(result, (ClassNode)typeHolder.getObject()));
                        }
                    });
                }
                ClassNode cn = typeHolder.getObject();
                Annotations.addTypeAnnotations(r, cn, resolver);
                RecordComponentNode recordComponentNode = new RecordComponentNode(classNode, r.name, cn);
                Annotations.addAnnotations(r, recordComponentNode, resolver);
                return recordComponentNode;
            }).collect(Collectors.toList()));
        }
    }

    private static void parseClassSignature(final ClassNode classNode, String signature, final AsmReferenceResolver resolver) {
        final ArrayList interfaces = new ArrayList();
        FormalParameterParser v = new FormalParameterParser(resolver){

            @Override
            public SignatureVisitor visitSuperclass() {
                this.flushTypeParameter();
                return new TypeSignatureParser(resolver){

                    @Override
                    void finished(ClassNode result) {
                        classNode.setSuperClass(result);
                    }
                };
            }

            @Override
            public SignatureVisitor visitInterface() {
                this.flushTypeParameter();
                return new TypeSignatureParser(resolver){

                    @Override
                    void finished(ClassNode result) {
                        interfaces.add(result);
                    }
                };
            }
        };
        new SignatureReader(signature).accept(v);
        GenericsType[] typeParameters = v.getTypeParameters();
        if (typeParameters.length > 0) {
            classNode.setGenericsTypes(typeParameters);
        }
        classNode.setInterfaces(interfaces.toArray(ClassNode.EMPTY_ARRAY));
    }
}

