/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform.sc.transformers;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.groovy.ast.tools.ExpressionUtils;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.ast.tools.WideningCategories;
import org.codehaus.groovy.classgen.asm.sc.StaticPropertyAccessHelper;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.syntax.Types;
import org.codehaus.groovy.transform.sc.ListOfExpressionsExpression;
import org.codehaus.groovy.transform.sc.StaticCompilationMetadataKeys;
import org.codehaus.groovy.transform.sc.TemporaryVariableExpression;
import org.codehaus.groovy.transform.sc.transformers.CompareIdentityExpression;
import org.codehaus.groovy.transform.sc.transformers.CompareToNullExpression;
import org.codehaus.groovy.transform.sc.transformers.StaticCompilationTransformer;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingSupport;
import org.codehaus.groovy.transform.stc.StaticTypesMarker;

public class BinaryExpressionTransformer {
    private static final MethodNode COMPARE_TO_METHOD = ClassHelper.COMPARABLE_TYPE.getMethods("compareTo").get(0);
    private static final ConstantExpression CONSTANT_MINUS_ONE = GeneralUtils.constX(-1, true);
    private static final ConstantExpression CONSTANT_ZERO = GeneralUtils.constX(0, true);
    private static final ConstantExpression CONSTANT_ONE = GeneralUtils.constX(1, true);
    private int tmpVarCounter;
    private final StaticCompilationTransformer staticCompilationTransformer;

    public BinaryExpressionTransformer(StaticCompilationTransformer staticCompilationTransformer) {
        this.staticCompilationTransformer = staticCompilationTransformer;
    }

    public Expression transformBinaryExpression(BinaryExpression bin) {
        Expression optimized;
        if (bin instanceof DeclarationExpression && (optimized = BinaryExpressionTransformer.transformDeclarationExpression(bin)) != null) {
            return optimized;
        }
        Token operation = bin.getOperation();
        int operationType = operation.getType();
        Expression leftExpression = bin.getLeftExpression();
        Expression rightExpression = bin.getRightExpression();
        if (bin instanceof DeclarationExpression && leftExpression instanceof VariableExpression && rightExpression instanceof ConstantExpression) {
            ConstantExpression constant;
            ClassNode declarationType = ((VariableExpression)leftExpression).getOriginType();
            if (!rightExpression.getType().equals(declarationType) && ClassHelper.getWrapper(declarationType).isDerivedFrom(ClassHelper.Number_TYPE) && WideningCategories.isDoubleCategory(ClassHelper.getUnwrapper(declarationType)) && !(constant = (ConstantExpression)rightExpression).isNullExpression()) {
                return BinaryExpressionTransformer.optimizeConstantInitialization(bin, operation, constant, leftExpression, declarationType);
            }
        }
        if (operationType == 100) {
            MethodNode directMCT;
            ClassNode leftType = this.findType(leftExpression);
            ClassNode rightType = this.findType(rightExpression);
            if (leftType.isArray() && !(rightExpression instanceof ListExpression) && GeneralUtils.isOrImplements(rightType, ClassHelper.COLLECTION_TYPE)) {
                ArrayExpression emptyArray = new ArrayExpression(leftType.getComponentType(), null, Collections.singletonList(CONSTANT_ZERO));
                rightExpression = GeneralUtils.callX(rightExpression, "toArray", (Expression)GeneralUtils.args(emptyArray));
                rightExpression.putNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, leftType);
                ((MethodCallExpression)rightExpression).setMethodTarget(rightType.getMethod("toArray", new Parameter[]{new Parameter(ClassHelper.OBJECT_TYPE.makeArray(), "a")}));
                ((MethodCallExpression)rightExpression).setImplicitThis(false);
                ((MethodCallExpression)rightExpression).setSafe(true);
            }
            if ((directMCT = (MethodNode)leftExpression.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET)) != null) {
                Expression left = this.staticCompilationTransformer.transform(leftExpression);
                Expression right = this.staticCompilationTransformer.transform(rightExpression);
                if (left instanceof PropertyExpression) {
                    PropertyExpression pe = (PropertyExpression)left;
                    return BinaryExpressionTransformer.transformAssignmentToSetterCall(pe.getObjectExpression(), directMCT, right, false, pe.isSafe(), pe.getProperty(), bin);
                }
                if (left instanceof VariableExpression) {
                    return BinaryExpressionTransformer.transformAssignmentToSetterCall(GeneralUtils.varX("this"), directMCT, right, true, false, left, bin);
                }
            }
            if (rightExpression != bin.getRightExpression()) {
                bin.setRightExpression(rightExpression);
            }
        } else if (operationType == 123 || operationType == 120) {
            ASTNode compareToNullExpression = null;
            if (ExpressionUtils.isNullConstant(leftExpression)) {
                compareToNullExpression = new CompareToNullExpression(this.staticCompilationTransformer.transform(rightExpression), operationType == 123);
            } else if (ExpressionUtils.isNullConstant(rightExpression)) {
                compareToNullExpression = new CompareToNullExpression(this.staticCompilationTransformer.transform(leftExpression), operationType == 123);
            }
            if (compareToNullExpression != null) {
                compareToNullExpression.setSourcePosition(bin);
                return compareToNullExpression;
            }
        } else if (operationType == 573) {
            return this.staticCompilationTransformer.transform(BinaryExpressionTransformer.convertInOperatorToTernary(bin, rightExpression, leftExpression));
        }
        Object[] list = (Object[])bin.getNodeMetaData((Object)StaticCompilationMetadataKeys.BINARY_EXP_TARGET);
        if (list != null) {
            Expression expr;
            MethodCallExpression call;
            Expression left = this.staticCompilationTransformer.transform(leftExpression);
            Expression right = this.staticCompilationTransformer.transform(rightExpression);
            if (operationType == 128 && this.findType(left).implementsInterface(ClassHelper.COMPARABLE_TYPE) && this.findType(right).implementsInterface(ClassHelper.COMPARABLE_TYPE)) {
                call = GeneralUtils.callX(left, "compareTo", (Expression)GeneralUtils.args(right));
                call.setImplicitThis(false);
                call.setMethodTarget(COMPARE_TO_METHOD);
                call.setSourcePosition(bin);
                expr = GeneralUtils.ternaryX(GeneralUtils.boolX(new CompareToNullExpression(right, true)), CONSTANT_ONE, call);
                expr.putNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, ClassHelper.int_TYPE);
                expr = GeneralUtils.ternaryX(GeneralUtils.boolX(new CompareToNullExpression(left, true)), CONSTANT_MINUS_ONE, expr);
                expr.putNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, ClassHelper.int_TYPE);
                expr = GeneralUtils.ternaryX(GeneralUtils.boolX(new CompareIdentityExpression(left, right)), CONSTANT_ZERO, expr);
                expr.putNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, ClassHelper.int_TYPE);
                return expr;
            }
            expr = BinaryExpressionTransformer.tryOptimizeCharComparison(left, right, bin);
            if (expr != null) {
                expr.removeNodeMetaData((Object)StaticCompilationMetadataKeys.BINARY_EXP_TARGET);
                expr.removeNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET);
                return expr;
            }
            MethodNode adapter = StaticCompilationTransformer.BYTECODE_BINARY_ADAPTERS.get(operationType);
            if (adapter != null) {
                ClassExpression sba = GeneralUtils.classX(StaticCompilationTransformer.BYTECODE_ADAPTER_CLASS);
                call = GeneralUtils.callX((Expression)sba, adapter.getName(), (Expression)GeneralUtils.args(left, right));
                call.setMethodTarget(adapter);
            } else {
                call = GeneralUtils.callX(left, (String)list[1], (Expression)GeneralUtils.args(right));
                call.setMethodTarget((MethodNode)list[0]);
            }
            call.setImplicitThis(false);
            if (Types.isAssignment(operationType)) {
                BinaryExpression be;
                if (left instanceof BinaryExpression && (be = (BinaryExpression)left).getOperation().getType() == 30) {
                    be.setLeftExpression(new TemporaryVariableExpression(be.getLeftExpression()));
                    be.setRightExpression(new TemporaryVariableExpression(be.getRightExpression()));
                }
                expr = GeneralUtils.binX(left, Token.newSymbol(100, operation.getStartLine(), operation.getStartColumn()), call);
            } else {
                expr = call;
            }
            expr.setSourcePosition(bin);
            return expr;
        }
        if (operationType == 100 && leftExpression instanceof TupleExpression && rightExpression instanceof ListExpression) {
            ListOfExpressionsExpression cle = new ListOfExpressionsExpression();
            boolean isDeclaration = bin instanceof DeclarationExpression;
            List<Expression> leftExpressions = ((TupleExpression)leftExpression).getExpressions();
            List<Expression> rightExpressions = ((ListExpression)rightExpression).getExpressions();
            Iterator<Expression> leftIt = leftExpressions.iterator();
            Iterator<Expression> rightIt = rightExpressions.iterator();
            if (isDeclaration) {
                while (leftIt.hasNext()) {
                    Expression left = leftIt.next();
                    if (!rightIt.hasNext()) continue;
                    Expression right = rightIt.next();
                    DeclarationExpression bexp = new DeclarationExpression(left, operation, right);
                    bexp.setSourcePosition(right);
                    cle.addExpression(bexp);
                }
            } else {
                int size = rightExpressions.size();
                ArrayList<DeclarationExpression> tmpAssignments = new ArrayList<DeclarationExpression>(size);
                ArrayList<BinaryExpression> finalAssignments = new ArrayList<BinaryExpression>(size);
                int n = Math.min(size, leftExpressions.size());
                for (int i = 0; i < n; ++i) {
                    Expression left = leftIt.next();
                    Expression right = rightIt.next();
                    VariableExpression tmpVar = GeneralUtils.varX("$tmpVar$" + this.tmpVarCounter++);
                    BinaryExpression bexp = new DeclarationExpression(tmpVar, operation, right);
                    bexp.setSourcePosition(right);
                    tmpAssignments.add((DeclarationExpression)bexp);
                    bexp = GeneralUtils.binX(left, operation, GeneralUtils.varX(tmpVar));
                    bexp.setSourcePosition(left);
                    finalAssignments.add(bexp);
                }
                for (Expression expression : tmpAssignments) {
                    cle.addExpression(expression);
                }
                for (Expression expression : finalAssignments) {
                    cle.addExpression(expression);
                }
            }
            return this.staticCompilationTransformer.transform(cle);
        }
        return this.staticCompilationTransformer.superTransform(bin);
    }

    private ClassNode findType(Expression expression) {
        ClassNode classNode = this.staticCompilationTransformer.getClassNode();
        return this.staticCompilationTransformer.getTypeChooser().resolveType(expression, classNode);
    }

    private static BinaryExpression tryOptimizeCharComparison(Expression left, Expression right, BinaryExpression bin) {
        int op = bin.getOperation().getType();
        if (StaticTypeCheckingSupport.isCompareToBoolean(op) || op == 123 || op == 120) {
            Character cLeft = BinaryExpressionTransformer.tryCharConstant(left);
            Character cRight = BinaryExpressionTransformer.tryCharConstant(right);
            if (cLeft != null || cRight != null) {
                Expression oRight;
                Expression oLeft;
                Expression expression = oLeft = cLeft == null ? left : GeneralUtils.constX(cLeft, true);
                if (oLeft instanceof PropertyExpression && !BinaryExpressionTransformer.hasCharType((PropertyExpression)oLeft)) {
                    return null;
                }
                oLeft.setSourcePosition(left);
                Expression expression2 = oRight = cRight == null ? right : GeneralUtils.constX(cRight, true);
                if (oRight instanceof PropertyExpression && !BinaryExpressionTransformer.hasCharType((PropertyExpression)oRight)) {
                    return null;
                }
                oRight.setSourcePosition(right);
                bin.setLeftExpression(oLeft);
                bin.setRightExpression(oRight);
                return bin;
            }
        }
        return null;
    }

    private static boolean hasCharType(PropertyExpression pe) {
        ClassNode inferredType = (ClassNode)pe.getNodeMetaData((Object)StaticTypesMarker.INFERRED_RETURN_TYPE);
        return inferredType != null && ClassHelper.Character_TYPE.equals(ClassHelper.getWrapper(inferredType));
    }

    private static Character tryCharConstant(Expression expr) {
        String value;
        if (expr instanceof ConstantExpression && ClassHelper.STRING_TYPE.equals(expr.getType()) && (value = (String)((ConstantExpression)expr).getValue()) != null && value.length() == 1) {
            return Character.valueOf(value.charAt(0));
        }
        return null;
    }

    private static Expression transformDeclarationExpression(BinaryExpression bin) {
        Expression rightExpression;
        Character c;
        Expression leftExpression = bin.getLeftExpression();
        if (leftExpression instanceof VariableExpression && ClassHelper.char_TYPE.equals(((VariableExpression)leftExpression).getOriginType()) && (c = BinaryExpressionTransformer.tryCharConstant(rightExpression = bin.getRightExpression())) != null) {
            ConstantExpression ce = GeneralUtils.constX(c, true);
            ce.setSourcePosition(rightExpression);
            bin.setRightExpression(ce);
            return bin;
        }
        return null;
    }

    private static Expression convertInOperatorToTernary(BinaryExpression bin, Expression rightExpression, Expression leftExpression) {
        MethodCallExpression call = GeneralUtils.callX(rightExpression, "isCase", leftExpression);
        call.setMethodTarget((MethodNode)bin.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET));
        call.setSourcePosition(bin);
        call.copyNodeMetaData(bin);
        TernaryExpression tExp = GeneralUtils.ternaryX(GeneralUtils.boolX(GeneralUtils.binX(rightExpression, Token.newSymbol("==", -1, -1), GeneralUtils.nullX())), GeneralUtils.binX(leftExpression, Token.newSymbol("==", -1, -1), GeneralUtils.nullX()), call);
        return tExp;
    }

    private static DeclarationExpression optimizeConstantInitialization(BinaryExpression originalDeclaration, Token operation, ConstantExpression constant, Expression leftExpression, ClassNode declarationType) {
        ConstantExpression cexp = GeneralUtils.constX(BinaryExpressionTransformer.convertConstant((Number)constant.getValue(), ClassHelper.getWrapper(declarationType)), true);
        cexp.setType(declarationType);
        cexp.setSourcePosition(constant);
        DeclarationExpression result = new DeclarationExpression(leftExpression, operation, (Expression)cexp);
        result.setSourcePosition(originalDeclaration);
        result.copyNodeMetaData(originalDeclaration);
        return result;
    }

    private static Object convertConstant(Number source, ClassNode target) {
        if (ClassHelper.isWrapperByte(target)) {
            return source.byteValue();
        }
        if (ClassHelper.isWrapperShort(target)) {
            return source.shortValue();
        }
        if (ClassHelper.isWrapperInteger(target)) {
            return source.intValue();
        }
        if (ClassHelper.isWrapperLong(target)) {
            return source.longValue();
        }
        if (ClassHelper.isWrapperFloat(target)) {
            return Float.valueOf(source.floatValue());
        }
        if (ClassHelper.isWrapperDouble(target)) {
            return source.doubleValue();
        }
        if (ClassHelper.isBigIntegerType(target)) {
            return DefaultGroovyMethods.asType(source, BigInteger.class);
        }
        if (ClassHelper.isBigDecimalType(target)) {
            return DefaultGroovyMethods.asType(source, BigDecimal.class);
        }
        throw new IllegalArgumentException("Unsupported conversion");
    }

    private static Expression transformAssignmentToSetterCall(Expression receiver, MethodNode setterMethod, Expression valueExpression, boolean implicitThis, boolean safeNavigation, Expression nameExpression, Expression binaryExpression) {
        PropertyExpression pos = new PropertyExpression(null, nameExpression);
        pos.setSourcePosition(binaryExpression);
        return StaticPropertyAccessHelper.transformToSetterCall(receiver, setterMethod, valueExpression, implicitThis, safeNavigation, false, true, pos);
    }
}

