/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform.tailrec;

import groovy.lang.Closure;
import java.util.ArrayList;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.DoWhileStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;

public class StatementReplacer
extends CodeVisitorSupport {
    private Closure<Boolean> when;
    private Closure<Statement> replaceWith;
    private int closureLevel = 0;

    public StatementReplacer(Closure<Boolean> when, Closure<Statement> replaceWith) {
        this.when = when;
        this.replaceWith = replaceWith;
    }

    public void replaceIn(ASTNode root) {
        root.visit(this);
    }

    @Override
    public void visitClosureExpression(ClosureExpression expression) {
        ++this.closureLevel;
        try {
            super.visitClosureExpression(expression);
        }
        finally {
            --this.closureLevel;
        }
    }

    @Override
    public void visitBlockStatement(final BlockStatement block) {
        ArrayList<Statement> copyOfStatements = new ArrayList<Statement>(block.getStatements());
        DefaultGroovyMethods.eachWithIndex(copyOfStatements, (Closure)new Closure<Void>((Object)this, (Object)this){

            public void doCall(Statement statement, final int index) {
                StatementReplacer.this.replaceIfNecessary(statement, new Closure<Statement>((Object)StatementReplacer.this, (Object)StatementReplacer.this){

                    public Statement doCall(Statement node) {
                        block.getStatements().set(index, node);
                        return node;
                    }
                });
            }
        });
        super.visitBlockStatement(block);
    }

    @Override
    public void visitIfElse(final IfStatement ifElse) {
        this.replaceIfNecessary(ifElse.getIfBlock(), new Closure<Statement>((Object)this, (Object)this){

            public Statement doCall(Statement s) {
                ifElse.setIfBlock(s);
                return s;
            }
        });
        this.replaceIfNecessary(ifElse.getElseBlock(), new Closure<Statement>((Object)this, (Object)this){

            public Statement doCall(Statement s) {
                ifElse.setElseBlock(s);
                return s;
            }
        });
        super.visitIfElse(ifElse);
    }

    @Override
    public void visitForLoop(final ForStatement forLoop) {
        this.replaceIfNecessary(forLoop.getLoopBlock(), new Closure<Statement>((Object)this, (Object)this){

            public Statement doCall(Statement s) {
                forLoop.setLoopBlock(s);
                return s;
            }
        });
        super.visitForLoop(forLoop);
    }

    @Override
    public void visitWhileLoop(final WhileStatement loop) {
        this.replaceIfNecessary(loop.getLoopBlock(), new Closure<Statement>((Object)this, (Object)this){

            public Statement doCall(Statement s) {
                loop.setLoopBlock(s);
                return s;
            }
        });
        super.visitWhileLoop(loop);
    }

    @Override
    public void visitDoWhileLoop(final DoWhileStatement loop) {
        this.replaceIfNecessary(loop.getLoopBlock(), new Closure<Statement>((Object)this, (Object)this){

            public Statement doCall(Statement s) {
                loop.setLoopBlock(s);
                return s;
            }
        });
        super.visitDoWhileLoop(loop);
    }

    private void replaceIfNecessary(Statement nodeToCheck, Closure replacementCode) {
        if (this.conditionFulfilled(nodeToCheck)) {
            Statement replacement = this.replaceWith.call((Object)nodeToCheck);
            replacement.setSourcePosition(nodeToCheck);
            replacement.copyNodeMetaData(nodeToCheck);
            replacementCode.call((Object)replacement);
        }
    }

    private boolean conditionFulfilled(ASTNode nodeToCheck) {
        if (this.when.getMaximumNumberOfParameters() < 2) {
            return this.when.call((Object)nodeToCheck);
        }
        return this.when.call(nodeToCheck, this.isInClosure());
    }

    private boolean isInClosure() {
        return this.closureLevel > 0;
    }

    public Closure<Boolean> getWhen() {
        return this.when;
    }

    public void setWhen(Closure<Boolean> when) {
        this.when = when;
    }

    public Closure<Statement> getReplaceWith() {
        return this.replaceWith;
    }

    public void setReplaceWith(Closure<Statement> replaceWith) {
        this.replaceWith = replaceWith;
    }

    public int getClosureLevel() {
        return this.closureLevel;
    }

    public void setClosureLevel(int closureLevel) {
        this.closureLevel = closureLevel;
    }
}

