/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.control;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.net.URI;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;

public abstract class XStreamUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serialize(String name, Object ast) {
        if (name == null || name.length() == 0) {
            return;
        }
        XStream xstream = new XStream((HierarchicalStreamDriver)new StaxDriver());
        FileWriter astFileWriter = null;
        try {
            File astFile = XStreamUtils.astFile(name);
            if (astFile == null) {
                System.out.println("File-name for writing " + name + " AST could not be determined!");
                return;
            }
            astFileWriter = new FileWriter(astFile, false);
            xstream.toXML(ast, (Writer)astFileWriter);
            System.out.println("Written AST to " + name + ".xml");
            DefaultGroovyMethods.closeQuietly(astFileWriter);
        }
        catch (Exception e) {
            System.out.println("Couldn't write to " + name + ".xml");
            e.printStackTrace();
        }
        finally {
            DefaultGroovyMethods.closeQuietly(astFileWriter);
        }
    }

    private static File astFile(String uriOrFileName) {
        try {
            String astFileName = uriOrFileName + ".xml";
            return uriOrFileName.startsWith("file:") ? new File(URI.create(astFileName)) : new File(astFileName);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

