/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.scm.protocol.ScmBlockLocationProtocol;
import org.apache.hadoop.ozone.common.BlockGroup;
import org.apache.hadoop.ozone.common.DeleteBlockGroupResult;
import org.apache.hadoop.ozone.om.KeyManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.utils.BackgroundService;
import org.apache.hadoop.utils.BackgroundTask;
import org.apache.hadoop.utils.BackgroundTaskQueue;
import org.apache.hadoop.utils.BackgroundTaskResult;
import org.apache.hadoop.utils.db.BatchOperation;
import org.apache.hadoop.utils.db.DBStore;
import org.apache.hadoop.utils.db.Table;
import org.apache.ratis.protocol.ClientId;
import org.rocksdb.RocksDBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyDeletingService
extends BackgroundService {
    private static final Logger LOG = LoggerFactory.getLogger(KeyDeletingService.class);
    private static final int KEY_DELETING_CORE_POOL_SIZE = 2;
    private final OzoneManager ozoneManager;
    private final ScmBlockLocationProtocol scmClient;
    private final KeyManager manager;
    private ClientId clientId = ClientId.randomId();
    private final int keyLimitPerTask;
    private final AtomicLong deletedKeyCount;
    private final AtomicLong runCount;

    KeyDeletingService(OzoneManager ozoneManager, ScmBlockLocationProtocol scmClient, KeyManager manager, long serviceInterval, long serviceTimeout, Configuration conf) {
        super("KeyDeletingService", serviceInterval, TimeUnit.MILLISECONDS, 2, serviceTimeout);
        this.ozoneManager = ozoneManager;
        this.scmClient = scmClient;
        this.manager = manager;
        this.keyLimitPerTask = conf.getInt("ozone.key.deleting.limit.per.task", 1000);
        this.deletedKeyCount = new AtomicLong(0L);
        this.runCount = new AtomicLong(0L);
    }

    @VisibleForTesting
    public AtomicLong getRunCount() {
        return this.runCount;
    }

    @VisibleForTesting
    public AtomicLong getDeletedKeyCount() {
        return this.deletedKeyCount;
    }

    public BackgroundTaskQueue getTasks() {
        BackgroundTaskQueue queue = new BackgroundTaskQueue();
        queue.add((BackgroundTask)new KeyDeletingTask());
        return queue;
    }

    private boolean shouldRun() {
        if (this.ozoneManager == null) {
            return true;
        }
        return this.ozoneManager.isLeader();
    }

    private boolean isRatisEnabled() {
        if (this.ozoneManager == null) {
            return false;
        }
        return this.ozoneManager.isRatisEnabled();
    }

    private class KeyDeletingTask
    implements BackgroundTask<BackgroundTaskResult> {
        private KeyDeletingTask() {
        }

        public int getPriority() {
            return 0;
        }

        public BackgroundTaskResult call() throws Exception {
            if (KeyDeletingService.this.shouldRun()) {
                KeyDeletingService.this.runCount.incrementAndGet();
                try {
                    List results;
                    long startTime = Time.monotonicNow();
                    List<BlockGroup> keyBlocksList = KeyDeletingService.this.manager.getPendingDeletionKeys(KeyDeletingService.this.keyLimitPerTask);
                    if (keyBlocksList != null && keyBlocksList.size() > 0 && (results = KeyDeletingService.this.scmClient.deleteKeyBlocks(keyBlocksList)) != null) {
                        int delCount = KeyDeletingService.this.isRatisEnabled() ? this.submitPurgeKeysRequest(results) : this.deleteAllKeys(results);
                        LOG.debug("Number of keys deleted: {}, elapsed time: {}ms", (Object)delCount, (Object)(Time.monotonicNow() - startTime));
                        KeyDeletingService.this.deletedKeyCount.addAndGet(delCount);
                    }
                }
                catch (IOException e) {
                    LOG.error("Error while running delete keys background task. Will retry at next run.", (Throwable)e);
                }
            }
            return BackgroundTaskResult.EmptyTaskResult.newResult();
        }

        private int deleteAllKeys(List<DeleteBlockGroupResult> results) throws RocksDBException, IOException {
            Table deletedTable = KeyDeletingService.this.manager.getMetadataManager().getDeletedTable();
            DBStore store = KeyDeletingService.this.manager.getMetadataManager().getStore();
            int deletedCount = 0;
            try (BatchOperation writeBatch = store.initBatchOperation();){
                for (DeleteBlockGroupResult result : results) {
                    if (!result.isSuccess()) continue;
                    deletedTable.deleteWithBatch(writeBatch, (Object)result.getObjectKey());
                    LOG.debug("Key {} deleted from OM DB", (Object)result.getObjectKey());
                    ++deletedCount;
                }
                store.commitBatchOperation(writeBatch);
            }
            return deletedCount;
        }

        public int submitPurgeKeysRequest(List<DeleteBlockGroupResult> results) {
            ArrayList<String> purgeKeysList = new ArrayList<String>();
            int deletedCount = 0;
            for (DeleteBlockGroupResult result : results) {
                if (!result.isSuccess()) continue;
                String deletedKey = result.getObjectKey();
                purgeKeysList.add(deletedKey);
                LOG.debug("Key {} set to be purged from OM DB", (Object)deletedKey);
                ++deletedCount;
            }
            OzoneManagerProtocolProtos.PurgeKeysRequest purgeKeysRequest = OzoneManagerProtocolProtos.PurgeKeysRequest.newBuilder().addAllKeys(purgeKeysList).build();
            OzoneManagerProtocolProtos.OMRequest omRequest = OzoneManagerProtocolProtos.OMRequest.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.PurgeKeys).setPurgeKeysRequest(purgeKeysRequest).setClientId(KeyDeletingService.this.clientId.toString()).build();
            try {
                KeyDeletingService.this.ozoneManager.getOmServerProtocol().submitRequest(null, omRequest);
            }
            catch (ServiceException e) {
                LOG.error("PurgeKey request failed. Will retry at next run.");
                return 0;
            }
            return deletedCount;
        }
    }
}

