/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.StorageUnit;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.AllocatedBlock;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerWithPipeline;
import org.apache.hadoop.hdds.scm.container.common.helpers.ExcludeList;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.protocol.ScmBlockLocationProtocol;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.common.BlockGroup;
import org.apache.hadoop.ozone.om.KeyDeletingService;
import org.apache.hadoop.ozone.om.KeyManager;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.PrefixManager;
import org.apache.hadoop.ozone.om.ScmClient;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.BucketEncryptionKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyArgs;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.om.helpers.OmMultipartCommitUploadPartInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadCompleteInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadList;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadListParts;
import org.apache.hadoop.ozone.om.helpers.OmPartInfo;
import org.apache.hadoop.ozone.om.helpers.OmPrefixInfo;
import org.apache.hadoop.ozone.om.helpers.OpenKeySession;
import org.apache.hadoop.ozone.om.helpers.OzoneAclUtil;
import org.apache.hadoop.ozone.om.helpers.OzoneFSUtils;
import org.apache.hadoop.ozone.om.helpers.OzoneFileStatus;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.OzoneBlockTokenSecretManager;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.security.acl.RequestContext;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.utils.BackgroundService;
import org.apache.hadoop.utils.UniqueId;
import org.apache.hadoop.utils.db.BatchOperation;
import org.apache.hadoop.utils.db.CodecRegistry;
import org.apache.hadoop.utils.db.DBStore;
import org.apache.hadoop.utils.db.RDBStore;
import org.apache.hadoop.utils.db.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyManagerImpl
implements KeyManager {
    private static final Logger LOG = LoggerFactory.getLogger(KeyManagerImpl.class);
    private final OzoneManager ozoneManager;
    private final ScmClient scmClient;
    private final OMMetadataManager metadataManager;
    private final long scmBlockSize;
    private final boolean useRatis;
    private final int preallocateBlocksMax;
    private final String omId;
    private final OzoneBlockTokenSecretManager secretManager;
    private final boolean grpcBlockTokenEnabled;
    private BackgroundService keyDeletingService;
    private final KeyProviderCryptoExtension kmsProvider;
    private final PrefixManager prefixManager;

    @VisibleForTesting
    public KeyManagerImpl(ScmBlockLocationProtocol scmBlockClient, OMMetadataManager metadataManager, OzoneConfiguration conf, String omId, OzoneBlockTokenSecretManager secretManager) {
        this(null, new ScmClient(scmBlockClient, null), metadataManager, conf, omId, secretManager, null, null);
    }

    public KeyManagerImpl(OzoneManager om, ScmClient scmClient, OzoneConfiguration conf, String omId) {
        this(om, scmClient, om.getMetadataManager(), conf, omId, om.getBlockTokenMgr(), om.getKmsProvider(), om.getPrefixManager());
    }

    private KeyManagerImpl(OzoneManager om, ScmClient scmClient, OMMetadataManager metadataManager, OzoneConfiguration conf, String omId, OzoneBlockTokenSecretManager secretManager, KeyProviderCryptoExtension kmsProvider, PrefixManager prefixManager) {
        this.scmBlockSize = (long)conf.getStorageSize("ozone.scm.block.size", "256MB", StorageUnit.BYTES);
        this.useRatis = conf.getBoolean("dfs.container.ratis.enabled", false);
        this.preallocateBlocksMax = conf.getInt("ozone.key.preallocation.max.blocks", 64);
        this.grpcBlockTokenEnabled = conf.getBoolean("hdds.block.token.enabled", false);
        this.ozoneManager = om;
        this.omId = omId;
        this.scmClient = scmClient;
        this.metadataManager = metadataManager;
        this.prefixManager = prefixManager;
        this.secretManager = secretManager;
        this.kmsProvider = kmsProvider;
        this.start(conf);
    }

    @Override
    public void start(OzoneConfiguration configuration) {
        if (this.keyDeletingService == null) {
            long blockDeleteInterval = configuration.getTimeDuration("ozone.block.deleting.service.interval", "60s", TimeUnit.MILLISECONDS);
            long serviceTimeout = configuration.getTimeDuration("ozone.block.deleting.service.timeout", "300s", TimeUnit.MILLISECONDS);
            this.keyDeletingService = new KeyDeletingService(this.ozoneManager, this.scmClient.getBlockClient(), this, blockDeleteInterval, serviceTimeout, (Configuration)configuration);
            this.keyDeletingService.start();
        }
    }

    KeyProviderCryptoExtension getKMSProvider() {
        return this.kmsProvider;
    }

    @Override
    public void stop() throws IOException {
        if (this.keyDeletingService != null) {
            this.keyDeletingService.shutdown();
            this.keyDeletingService = null;
        }
    }

    private OmBucketInfo getBucketInfo(String volumeName, String bucketName) throws IOException {
        String bucketKey = this.metadataManager.getBucketKey(volumeName, bucketName);
        return (OmBucketInfo)this.metadataManager.getBucketTable().get((Object)bucketKey);
    }

    private void validateBucket(String volumeName, String bucketName) throws IOException {
        String bucketKey = this.metadataManager.getBucketKey(volumeName, bucketName);
        if (this.metadataManager.getBucketTable().get((Object)bucketKey) == null) {
            String volumeKey = this.metadataManager.getVolumeKey(volumeName);
            if (this.metadataManager.getVolumeTable().get((Object)volumeKey) == null) {
                LOG.error("volume not found: {}", (Object)volumeName);
                throw new OMException("Volume not found", OMException.ResultCodes.VOLUME_NOT_FOUND);
            }
            LOG.error("bucket not found: {}/{} ", (Object)volumeName, (Object)bucketName);
            throw new OMException("Bucket not found", OMException.ResultCodes.BUCKET_NOT_FOUND);
        }
    }

    private OmBucketInfo validateS3Bucket(String volumeName, String bucketName) throws IOException {
        String bucketKey = this.metadataManager.getBucketKey(volumeName, bucketName);
        OmBucketInfo omBucketInfo = (OmBucketInfo)this.metadataManager.getBucketTable().get((Object)bucketKey);
        if (omBucketInfo == null) {
            LOG.error("bucket not found: {}/{} ", (Object)volumeName, (Object)bucketName);
            throw new OMException("Bucket not found", OMException.ResultCodes.BUCKET_NOT_FOUND);
        }
        return omBucketInfo;
    }

    @Override
    public OmKeyLocationInfo allocateBlock(OmKeyArgs args, long clientID, ExcludeList excludeList) throws IOException {
        Preconditions.checkNotNull((Object)args);
        String volumeName = args.getVolumeName();
        String bucketName = args.getBucketName();
        String keyName = args.getKeyName();
        this.validateBucket(volumeName, bucketName);
        String openKey = this.metadataManager.getOpenKey(volumeName, bucketName, keyName, clientID);
        OmKeyInfo keyInfo = (OmKeyInfo)this.metadataManager.getOpenKeyTable().get((Object)openKey);
        if (keyInfo == null) {
            LOG.error("Allocate block for a key not in open status in meta store /{}/{}/{} with ID {}", new Object[]{volumeName, bucketName, keyName, clientID});
            throw new OMException("Open Key not found", OMException.ResultCodes.KEY_NOT_FOUND);
        }
        List<OmKeyLocationInfo> locationInfos = this.allocateBlock(keyInfo, excludeList, this.scmBlockSize);
        keyInfo.appendNewBlocks(locationInfos, true);
        keyInfo.updateModifcationTime();
        this.metadataManager.getOpenKeyTable().put((Object)openKey, (Object)keyInfo);
        return locationInfos.get(0);
    }

    private List<OmKeyLocationInfo> allocateBlock(OmKeyInfo keyInfo, ExcludeList excludeList, long requestedSize) throws IOException {
        List allocatedBlocks;
        int numBlocks = Math.min((int)((requestedSize - 1L) / this.scmBlockSize + 1L), this.preallocateBlocksMax);
        ArrayList<OmKeyLocationInfo> locationInfos = new ArrayList<OmKeyLocationInfo>(numBlocks);
        String remoteUser = KeyManagerImpl.getRemoteUser().getShortUserName();
        try {
            allocatedBlocks = this.scmClient.getBlockClient().allocateBlock(this.scmBlockSize, numBlocks, keyInfo.getType(), keyInfo.getFactor(), this.omId, excludeList);
        }
        catch (SCMException ex) {
            if (ex.getResult().equals((Object)SCMException.ResultCodes.SAFE_MODE_EXCEPTION)) {
                throw new OMException(ex.getMessage(), OMException.ResultCodes.SCM_IN_SAFE_MODE);
            }
            throw ex;
        }
        for (AllocatedBlock allocatedBlock : allocatedBlocks) {
            OmKeyLocationInfo.Builder builder = new OmKeyLocationInfo.Builder().setBlockID(new BlockID(allocatedBlock.getBlockID())).setLength(this.scmBlockSize).setOffset(0L).setPipeline(allocatedBlock.getPipeline());
            if (this.grpcBlockTokenEnabled) {
                builder.setToken(this.secretManager.generateToken(remoteUser, allocatedBlock.getBlockID().toString(), this.getAclForUser(remoteUser), this.scmBlockSize));
            }
            locationInfos.add(builder.build());
        }
        return locationInfos;
    }

    public static UserGroupInformation getRemoteUser() throws IOException {
        UserGroupInformation ugi = Server.getRemoteUser();
        return ugi != null ? ugi : UserGroupInformation.getCurrentUser();
    }

    private EnumSet<HddsProtos.BlockTokenSecretProto.AccessModeProto> getAclForUser(String user) {
        return EnumSet.allOf(HddsProtos.BlockTokenSecretProto.AccessModeProto.class);
    }

    private KeyProviderCryptoExtension.EncryptedKeyVersion generateEDEK(final String ezKeyName) throws IOException {
        if (ezKeyName == null) {
            return null;
        }
        long generateEDEKStartTime = Time.monotonicNow();
        KeyProviderCryptoExtension.EncryptedKeyVersion edek = (KeyProviderCryptoExtension.EncryptedKeyVersion)SecurityUtil.doAsLoginUser((PrivilegedExceptionAction)new PrivilegedExceptionAction<KeyProviderCryptoExtension.EncryptedKeyVersion>(){

            @Override
            public KeyProviderCryptoExtension.EncryptedKeyVersion run() throws IOException {
                try {
                    return KeyManagerImpl.this.getKMSProvider().generateEncryptedKey(ezKeyName);
                }
                catch (GeneralSecurityException e) {
                    throw new IOException(e);
                }
            }
        });
        long generateEDEKTime = Time.monotonicNow() - generateEDEKStartTime;
        LOG.debug("generateEDEK takes {} ms", (Object)generateEDEKTime);
        Preconditions.checkNotNull((Object)edek);
        return edek;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OpenKeySession openKey(OmKeyArgs args) throws IOException {
        OmKeyInfo keyInfo;
        FileEncryptionInfo encInfo;
        OmBucketInfo bucketInfo;
        HddsProtos.ReplicationType type;
        Preconditions.checkNotNull((Object)args);
        Preconditions.checkNotNull((Object)args.getAcls(), (Object)"Default acls should be set.");
        String volumeName = args.getVolumeName();
        String bucketName = args.getBucketName();
        String keyName = args.getKeyName();
        this.validateBucket(volumeName, bucketName);
        long currentTime = UniqueId.next();
        long size = args.getDataSize() > 0L ? args.getDataSize() : this.scmBlockSize;
        ArrayList<OmKeyLocationInfo> locations = new ArrayList<OmKeyLocationInfo>();
        HddsProtos.ReplicationFactor factor = args.getFactor();
        if (factor == null) {
            HddsProtos.ReplicationFactor replicationFactor = factor = this.useRatis ? HddsProtos.ReplicationFactor.THREE : HddsProtos.ReplicationFactor.ONE;
        }
        if ((type = args.getType()) == null) {
            type = this.useRatis ? HddsProtos.ReplicationType.RATIS : HddsProtos.ReplicationType.STAND_ALONE;
        }
        String dbKeyName = this.metadataManager.getOzoneKey(args.getVolumeName(), args.getBucketName(), args.getKeyName());
        this.metadataManager.getLock().acquireLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        try {
            bucketInfo = this.getBucketInfo(volumeName, bucketName);
            encInfo = this.getFileEncryptionInfo(bucketInfo);
            keyInfo = this.prepareKeyInfo(args, dbKeyName, size, locations, encInfo);
        }
        catch (OMException e) {
            try {
                throw e;
                catch (IOException ex) {
                    LOG.error("Key open failed for volume:{} bucket:{} key:{}", new Object[]{volumeName, bucketName, keyName, ex});
                    throw new OMException(ex.getMessage(), OMException.ResultCodes.KEY_ALLOCATION_ERROR);
                }
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                throw throwable;
            }
        }
        this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        if (keyInfo == null) {
            keyInfo = this.createKeyInfo(args, locations, factor, type, size, encInfo, bucketInfo);
        }
        long openVersion = keyInfo.getLatestVersionLocations().getVersion();
        LOG.debug("Key {} allocated in volume {} bucket {}", new Object[]{keyName, volumeName, bucketName});
        this.allocateBlockInKey(keyInfo, size, currentTime);
        return new OpenKeySession(currentTime, keyInfo, openVersion);
    }

    private void allocateBlockInKey(OmKeyInfo keyInfo, long size, long sessionId) throws IOException {
        String openKey = this.metadataManager.getOpenKey(keyInfo.getVolumeName(), keyInfo.getBucketName(), keyInfo.getKeyName(), sessionId);
        if (size > 0L) {
            List<OmKeyLocationInfo> locationInfos = this.allocateBlock(keyInfo, new ExcludeList(), size);
            keyInfo.appendNewBlocks(locationInfos, true);
        }
        this.metadataManager.getOpenKeyTable().put((Object)openKey, (Object)keyInfo);
    }

    private OmKeyInfo prepareKeyInfo(OmKeyArgs keyArgs, String dbKeyName, long size, List<OmKeyLocationInfo> locations, FileEncryptionInfo encInfo) throws IOException {
        OmKeyInfo keyInfo = null;
        if (keyArgs.getIsMultipartKey()) {
            keyInfo = this.prepareMultipartKeyInfo(keyArgs, size, locations, encInfo);
        } else if (this.metadataManager.getKeyTable().isExist((Object)dbKeyName)) {
            keyInfo = (OmKeyInfo)this.metadataManager.getKeyTable().get((Object)dbKeyName);
            keyInfo.addNewVersion(locations, true);
            keyInfo.setDataSize(size + keyInfo.getDataSize());
        }
        return keyInfo;
    }

    private OmKeyInfo prepareMultipartKeyInfo(OmKeyArgs args, long size, List<OmKeyLocationInfo> locations, FileEncryptionInfo encInfo) throws IOException {
        Preconditions.checkArgument((args.getMultipartUploadPartNumber() > 0 ? 1 : 0) != 0, (Object)"PartNumber Should be greater than zero");
        String uploadID = args.getMultipartUploadID();
        Preconditions.checkNotNull((Object)uploadID);
        String multipartKey = this.metadataManager.getMultipartKey(args.getVolumeName(), args.getBucketName(), args.getKeyName(), uploadID);
        OmKeyInfo partKeyInfo = (OmKeyInfo)this.metadataManager.getOpenKeyTable().get((Object)multipartKey);
        if (partKeyInfo == null) {
            throw new OMException("No such Multipart upload is with specified uploadId " + uploadID, OMException.ResultCodes.NO_SUCH_MULTIPART_UPLOAD_ERROR);
        }
        HddsProtos.ReplicationFactor factor = partKeyInfo.getFactor();
        HddsProtos.ReplicationType type = partKeyInfo.getType();
        return this.createKeyInfo(args, locations, factor, type, size, encInfo, this.getBucketInfo(args.getVolumeName(), args.getBucketName()));
    }

    private OmKeyInfo createKeyInfo(OmKeyArgs keyArgs, List<OmKeyLocationInfo> locations, HddsProtos.ReplicationFactor factor, HddsProtos.ReplicationType type, long size, FileEncryptionInfo encInfo, OmBucketInfo omBucketInfo) {
        OmKeyInfo.Builder builder = new OmKeyInfo.Builder().setVolumeName(keyArgs.getVolumeName()).setBucketName(keyArgs.getBucketName()).setKeyName(keyArgs.getKeyName()).setOmKeyLocationInfos(Collections.singletonList(new OmKeyLocationInfoGroup(0L, locations))).setCreationTime(Time.now()).setModificationTime(Time.now()).setDataSize(size).setReplicationType(type).setReplicationFactor(factor).setFileEncryptionInfo(encInfo);
        builder.setAcls(this.getAclsForKey(keyArgs, omBucketInfo));
        return builder.build();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void commitKey(OmKeyArgs args, long clientID) throws IOException {
        Preconditions.checkNotNull((Object)args);
        String volumeName = args.getVolumeName();
        String bucketName = args.getBucketName();
        String keyName = args.getKeyName();
        List locationInfoList = args.getLocationInfoList();
        String objectKey = this.metadataManager.getOzoneKey(volumeName, bucketName, keyName);
        String openKey = this.metadataManager.getOpenKey(volumeName, bucketName, keyName, clientID);
        Preconditions.checkNotNull((Object)locationInfoList);
        try {
            this.metadataManager.getLock().acquireLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            this.validateBucket(volumeName, bucketName);
            OmKeyInfo keyInfo = (OmKeyInfo)this.metadataManager.getOpenKeyTable().get((Object)openKey);
            if (keyInfo == null) {
                throw new OMException("Failed to commit key, as " + openKey + "entry is not found in the openKey table", OMException.ResultCodes.KEY_NOT_FOUND);
            }
            keyInfo.setDataSize(args.getDataSize());
            keyInfo.setModificationTime(Time.now());
            keyInfo.updateLocationInfoList(locationInfoList);
            this.metadataManager.getStore().move((Object)openKey, (Object)objectKey, (Object)keyInfo, this.metadataManager.getOpenKeyTable(), this.metadataManager.getKeyTable());
        }
        catch (OMException e) {
            try {
                throw e;
                catch (IOException ex) {
                    LOG.error("Key commit failed for volume:{} bucket:{} key:{}", new Object[]{volumeName, bucketName, keyName, ex});
                    throw new OMException(ex.getMessage(), OMException.ResultCodes.KEY_ALLOCATION_ERROR);
                }
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                throw throwable;
            }
        }
        this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
    }

    @Override
    public OmKeyInfo lookupKey(OmKeyArgs args, String clientAddress) throws IOException {
        OmKeyInfo omKeyInfo;
        Preconditions.checkNotNull((Object)args);
        String volumeName = args.getVolumeName();
        String bucketName = args.getBucketName();
        String keyName = args.getKeyName();
        this.metadataManager.getLock().acquireLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        try {
            String keyBytes = this.metadataManager.getOzoneKey(volumeName, bucketName, keyName);
            OmKeyInfo value = (OmKeyInfo)this.metadataManager.getKeyTable().get((Object)keyBytes);
            if (value == null) {
                LOG.debug("volume:{} bucket:{} Key:{} not found", new Object[]{volumeName, bucketName, keyName});
                throw new OMException("Key not found", OMException.ResultCodes.KEY_NOT_FOUND);
            }
            if (this.grpcBlockTokenEnabled) {
                String remoteUser = KeyManagerImpl.getRemoteUser().getShortUserName();
                for (OmKeyLocationInfoGroup key : value.getKeyLocationVersions()) {
                    key.getLocationList().forEach(k -> k.setToken(this.secretManager.generateToken(remoteUser, k.getBlockID().getContainerBlockID().toString(), this.getAclForUser(remoteUser), k.getLength())));
                }
            }
            if (args.getRefreshPipeline()) {
                for (OmKeyLocationInfoGroup key : value.getKeyLocationVersions()) {
                    key.getLocationList().forEach(k -> {
                        if (this.scmClient.getContainerClient() != null) {
                            try {
                                ContainerWithPipeline cp = this.scmClient.getContainerClient().getContainerWithPipeline(k.getContainerID());
                                if (!cp.getPipeline().equals((Object)k.getPipeline())) {
                                    k.setPipeline(cp.getPipeline());
                                }
                            }
                            catch (IOException e) {
                                LOG.error("Unable to update pipeline for container:{}", (Object)k.getContainerID());
                            }
                        }
                    });
                }
            }
            this.sortDatanodeInPipeline(value, clientAddress);
            omKeyInfo = value;
        }
        catch (IOException ex) {
            try {
                LOG.debug("Get key failed for volume:{} bucket:{} key:{}", new Object[]{volumeName, bucketName, keyName, ex});
                throw new OMException(ex.getMessage(), OMException.ResultCodes.KEY_NOT_FOUND);
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                throw throwable;
            }
        }
        this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        return omKeyInfo;
    }

    @Override
    public void renameKey(OmKeyArgs args, String toKeyName) throws IOException {
        OmKeyInfo fromKeyValue;
        String fromKey;
        String fromKeyName;
        String bucketName;
        String volumeName;
        block21: {
            Preconditions.checkNotNull((Object)args);
            Preconditions.checkNotNull((Object)toKeyName);
            volumeName = args.getVolumeName();
            bucketName = args.getBucketName();
            fromKeyName = args.getKeyName();
            if (toKeyName.length() == 0 || fromKeyName.length() == 0) {
                LOG.error("Rename key failed for volume:{} bucket:{} fromKey:{} toKey:{}", new Object[]{volumeName, bucketName, fromKeyName, toKeyName});
                throw new OMException("Key name is empty", OMException.ResultCodes.INVALID_KEY_NAME);
            }
            this.metadataManager.getLock().acquireLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            fromKey = this.metadataManager.getOzoneKey(volumeName, bucketName, fromKeyName);
            fromKeyValue = (OmKeyInfo)this.metadataManager.getKeyTable().get((Object)fromKey);
            if (fromKeyValue == null) {
                LOG.error("Rename key failed for volume:{} bucket:{} fromKey:{} toKey:{}. Key: {} not found.", new Object[]{volumeName, bucketName, fromKeyName, toKeyName, fromKeyName});
                throw new OMException("Key not found", OMException.ResultCodes.KEY_NOT_FOUND);
            }
            if (!fromKeyName.equals(toKeyName)) break block21;
            this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            return;
        }
        try {
            String toKey = this.metadataManager.getOzoneKey(volumeName, bucketName, toKeyName);
            OmKeyInfo toKeyValue = (OmKeyInfo)this.metadataManager.getKeyTable().get((Object)toKey);
            if (toKeyValue != null) {
                LOG.error("Rename key failed for volume:{} bucket:{} fromKey:{} toKey:{}. Key: {} already exists.", new Object[]{volumeName, bucketName, fromKeyName, toKeyName, toKeyName});
                throw new OMException("Key already exists", OMException.ResultCodes.KEY_ALREADY_EXISTS);
            }
            fromKeyValue.setKeyName(toKeyName);
            fromKeyValue.updateModifcationTime();
            DBStore store = this.metadataManager.getStore();
            try (BatchOperation batch = store.initBatchOperation();){
                this.metadataManager.getKeyTable().deleteWithBatch(batch, (Object)fromKey);
                this.metadataManager.getKeyTable().putWithBatch(batch, (Object)toKey, (Object)fromKeyValue);
                store.commitBatchOperation(batch);
            }
        }
        catch (IOException ex) {
            try {
                if (ex instanceof OMException) {
                    throw ex;
                }
                LOG.error("Rename key failed for volume:{} bucket:{} fromKey:{} toKey:{}", new Object[]{volumeName, bucketName, fromKeyName, toKeyName, ex});
                throw new OMException(ex.getMessage(), OMException.ResultCodes.KEY_RENAME_ERROR);
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                throw throwable;
            }
        }
        this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void deleteKey(OmKeyArgs args) throws IOException {
        String objectKey;
        String keyName;
        String bucketName;
        String volumeName;
        block7: {
            Preconditions.checkNotNull((Object)args);
            volumeName = args.getVolumeName();
            bucketName = args.getBucketName();
            keyName = args.getKeyName();
            this.metadataManager.getLock().acquireLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            objectKey = this.metadataManager.getOzoneKey(volumeName, bucketName, keyName);
            OmKeyInfo keyInfo = (OmKeyInfo)this.metadataManager.getKeyTable().get((Object)objectKey);
            if (keyInfo == null) {
                throw new OMException("Key not found", OMException.ResultCodes.KEY_NOT_FOUND);
            }
            if (!this.isKeyEmpty(keyInfo)) break block7;
            this.metadataManager.getKeyTable().delete((Object)objectKey);
            LOG.debug("Key {} deleted from OM DB", (Object)keyName);
            this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            return;
        }
        try {
            this.metadataManager.getStore().move((Object)objectKey, this.metadataManager.getKeyTable(), this.metadataManager.getDeletedTable());
        }
        catch (OMException ex) {
            try {
                throw ex;
                catch (IOException ex2) {
                    LOG.error(String.format("Delete key failed for volume:%s bucket:%s key:%s", volumeName, bucketName, keyName), (Throwable)ex2);
                    throw new OMException(ex2.getMessage(), (Throwable)ex2, OMException.ResultCodes.KEY_DELETION_ERROR);
                }
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                throw throwable;
            }
        }
        this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        return;
    }

    private boolean isKeyEmpty(OmKeyInfo keyInfo) {
        for (OmKeyLocationInfoGroup keyLocationList : keyInfo.getKeyLocationVersions()) {
            if (keyLocationList.getLocationList().size() == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<OmKeyInfo> listKeys(String volumeName, String bucketName, String startKey, String keyPrefix, int maxKeys) throws IOException {
        Preconditions.checkNotNull((Object)volumeName);
        Preconditions.checkNotNull((Object)bucketName);
        return this.metadataManager.listKeys(volumeName, bucketName, startKey, keyPrefix, maxKeys);
    }

    @Override
    public List<BlockGroup> getPendingDeletionKeys(int count) throws IOException {
        return this.metadataManager.getPendingDeletionKeys(count);
    }

    @Override
    public List<BlockGroup> getExpiredOpenKeys() throws IOException {
        return this.metadataManager.getExpiredOpenKeys();
    }

    @Override
    public void deleteExpiredOpenKey(String objectKeyName) throws IOException {
        Preconditions.checkNotNull((Object)objectKeyName);
    }

    @Override
    public OMMetadataManager getMetadataManager() {
        return this.metadataManager;
    }

    @Override
    public BackgroundService getDeletingService() {
        return this.keyDeletingService;
    }

    @Override
    public OmMultipartInfo initiateMultipartUpload(OmKeyArgs omKeyArgs) throws IOException {
        Preconditions.checkNotNull((Object)omKeyArgs);
        String uploadID = UUID.randomUUID().toString() + "-" + UniqueId.next();
        return this.createMultipartInfo(omKeyArgs, uploadID);
    }

    /*
     * Exception decompiling
     */
    private OmMultipartInfo createMultipartInfo(OmKeyArgs keyArgs, String multipartUploadID) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<OzoneAcl> getAclsForKey(OmKeyArgs keyArgs, OmBucketInfo bucketInfo) {
        OmPrefixInfo prefixInfo;
        List<OmPrefixInfo> prefixList;
        ArrayList<OzoneAcl> acls = new ArrayList<OzoneAcl>();
        if (keyArgs.getAcls() != null) {
            acls.addAll(keyArgs.getAcls());
        }
        if (this.prefixManager != null && (prefixList = this.prefixManager.getLongestPrefixPath("/" + keyArgs.getVolumeName() + "/" + keyArgs.getBucketName() + "/" + keyArgs.getKeyName())).size() > 0 && (prefixInfo = prefixList.get(prefixList.size() - 1)) != null && OzoneAclUtil.inheritDefaultAcls(acls, (List)prefixInfo.getAcls())) {
            return acls;
        }
        if (bucketInfo != null && OzoneAclUtil.inheritDefaultAcls(acls, (List)bucketInfo.getAcls())) {
            return acls;
        }
        return acls;
    }

    @Override
    public OmMultipartCommitUploadPartInfo commitMultipartUploadPart(OmKeyArgs omKeyArgs, long clientID) throws IOException {
        String partName;
        String bucketName;
        String volumeName;
        block30: {
            Preconditions.checkNotNull((Object)omKeyArgs);
            volumeName = omKeyArgs.getVolumeName();
            bucketName = omKeyArgs.getBucketName();
            String keyName = omKeyArgs.getKeyName();
            String uploadID = omKeyArgs.getMultipartUploadID();
            int partNumber = omKeyArgs.getMultipartUploadPartNumber();
            this.metadataManager.getLock().acquireLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            this.validateS3Bucket(volumeName, bucketName);
            try {
                String multipartKey = this.metadataManager.getMultipartKey(volumeName, bucketName, keyName, uploadID);
                OmMultipartKeyInfo multipartKeyInfo = (OmMultipartKeyInfo)this.metadataManager.getMultipartInfoTable().get((Object)multipartKey);
                String openKey = this.metadataManager.getOpenKey(volumeName, bucketName, keyName, clientID);
                OmKeyInfo keyInfo = (OmKeyInfo)this.metadataManager.getOpenKeyTable().get((Object)openKey);
                keyInfo.setDataSize(omKeyArgs.getDataSize());
                keyInfo.updateLocationInfoList(omKeyArgs.getLocationInfoList());
                partName = this.metadataManager.getOzoneKey(volumeName, bucketName, keyName) + clientID;
                if (multipartKeyInfo == null) {
                    this.metadataManager.getDeletedTable().put((Object)partName, (Object)keyInfo);
                    throw new OMException("No such Multipart upload is with specified uploadId " + uploadID, OMException.ResultCodes.NO_SUCH_MULTIPART_UPLOAD_ERROR);
                }
                OzoneManagerProtocolProtos.PartKeyInfo oldPartKeyInfo = multipartKeyInfo.getPartKeyInfo(partNumber);
                OzoneManagerProtocolProtos.PartKeyInfo.Builder partKeyInfo = OzoneManagerProtocolProtos.PartKeyInfo.newBuilder();
                partKeyInfo.setPartName(partName);
                partKeyInfo.setPartNumber(partNumber);
                partKeyInfo.setPartKeyInfo(keyInfo.getProtobuf());
                multipartKeyInfo.addPartKeyInfo(partNumber, partKeyInfo.build());
                if (oldPartKeyInfo == null) {
                    DBStore store = this.metadataManager.getStore();
                    try (BatchOperation batch = store.initBatchOperation();){
                        this.metadataManager.getOpenKeyTable().deleteWithBatch(batch, (Object)openKey);
                        this.metadataManager.getMultipartInfoTable().putWithBatch(batch, (Object)multipartKey, (Object)multipartKeyInfo);
                        store.commitBatchOperation(batch);
                        break block30;
                    }
                }
                DBStore store = this.metadataManager.getStore();
                try (BatchOperation batch = store.initBatchOperation();){
                    this.metadataManager.getDeletedTable().putWithBatch(batch, (Object)oldPartKeyInfo.getPartName(), (Object)OmKeyInfo.getFromProtobuf((OzoneManagerProtocolProtos.KeyInfo)oldPartKeyInfo.getPartKeyInfo()));
                    this.metadataManager.getOpenKeyTable().deleteWithBatch(batch, (Object)openKey);
                    this.metadataManager.getMultipartInfoTable().putWithBatch(batch, (Object)multipartKey, (Object)multipartKeyInfo);
                    store.commitBatchOperation(batch);
                }
            }
            catch (IOException ex) {
                try {
                    LOG.error("Upload part Failed: volume:{} bucket:{} key:{} PartNumber: {}", new Object[]{volumeName, bucketName, keyName, partNumber, ex});
                    throw new OMException(ex.getMessage(), OMException.ResultCodes.MULTIPART_UPLOAD_PARTFILE_ERROR);
                }
                catch (Throwable throwable) {
                    this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                    throw throwable;
                }
            }
        }
        this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        return new OmMultipartCommitUploadPartInfo(partName);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OmMultipartUploadCompleteInfo completeMultipartUpload(OmKeyArgs omKeyArgs, OmMultipartUploadList multipartUploadList) throws IOException {
        OmMultipartUploadCompleteInfo omMultipartUploadCompleteInfo;
        Preconditions.checkNotNull((Object)omKeyArgs);
        Preconditions.checkNotNull((Object)multipartUploadList);
        String volumeName = omKeyArgs.getVolumeName();
        String bucketName = omKeyArgs.getBucketName();
        String keyName = omKeyArgs.getKeyName();
        String uploadID = omKeyArgs.getMultipartUploadID();
        this.metadataManager.getLock().acquireLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        this.validateS3Bucket(volumeName, bucketName);
        try {
            String multipartKey = this.metadataManager.getMultipartKey(volumeName, bucketName, keyName, uploadID);
            String ozoneKey = this.metadataManager.getOzoneKey(volumeName, bucketName, keyName);
            OmKeyInfo keyInfo = (OmKeyInfo)this.metadataManager.getKeyTable().get((Object)ozoneKey);
            OmMultipartKeyInfo multipartKeyInfo = (OmMultipartKeyInfo)this.metadataManager.getMultipartInfoTable().get((Object)multipartKey);
            if (multipartKeyInfo == null) {
                throw new OMException("Complete Multipart Upload Failed: volume: " + volumeName + "bucket: " + bucketName + "key: " + keyName, OMException.ResultCodes.NO_SUCH_MULTIPART_UPLOAD_ERROR);
            }
            TreeMap partKeyInfoMap = multipartKeyInfo.getPartKeyInfoMap();
            TreeMap multipartMap = multipartUploadList.getMultipartMap();
            Map.Entry multipartMapLastEntry = multipartMap.lastEntry();
            Map.Entry partKeyInfoLastEntry = partKeyInfoMap.lastEntry();
            if (partKeyInfoMap.size() != multipartMap.size()) {
                throw new OMException("Complete Multipart Upload Failed: volume: " + volumeName + "bucket: " + bucketName + "key: " + keyName, OMException.ResultCodes.MISMATCH_MULTIPART_LIST);
            }
            if (((Integer)multipartMapLastEntry.getKey()).intValue() != partKeyInfoMap.size() || ((Integer)partKeyInfoLastEntry.getKey()).intValue() != partKeyInfoMap.size()) {
                throw new OMException("Complete Multipart Upload Failed: volume: " + volumeName + "bucket: " + bucketName + "key: " + keyName, OMException.ResultCodes.MISSING_UPLOAD_PARTS);
            }
            HddsProtos.ReplicationType type = ((OzoneManagerProtocolProtos.PartKeyInfo)partKeyInfoLastEntry.getValue()).getPartKeyInfo().getType();
            HddsProtos.ReplicationFactor factor = ((OzoneManagerProtocolProtos.PartKeyInfo)partKeyInfoLastEntry.getValue()).getPartKeyInfo().getFactor();
            ArrayList locations = new ArrayList();
            long size = 0L;
            int partsCount = 1;
            int partsMapSize = partKeyInfoMap.size();
            for (Map.Entry partKeyInfoEntry : partKeyInfoMap.entrySet()) {
                int partNumber = (Integer)partKeyInfoEntry.getKey();
                OzoneManagerProtocolProtos.PartKeyInfo partKeyInfo = (OzoneManagerProtocolProtos.PartKeyInfo)partKeyInfoEntry.getValue();
                String providedPartName = (String)multipartMap.get(partNumber);
                String actualPartName = partKeyInfo.getPartName();
                if (partNumber != partsCount) {
                    throw new OMException("Complete Multipart Upload Failed: volume: " + volumeName + "bucket: " + bucketName + "key: " + keyName, OMException.ResultCodes.MISSING_UPLOAD_PARTS);
                }
                if (!actualPartName.equals(providedPartName)) {
                    throw new OMException("Complete Multipart Upload Failed: volume: " + volumeName + "bucket: " + bucketName + "key: " + keyName, OMException.ResultCodes.MISMATCH_MULTIPART_LIST);
                }
                OmKeyInfo currentPartKeyInfo = OmKeyInfo.getFromProtobuf((OzoneManagerProtocolProtos.KeyInfo)partKeyInfo.getPartKeyInfo());
                if (partsCount != partsMapSize && currentPartKeyInfo.getDataSize() < 0x500000L) {
                    LOG.error("MultipartUpload: " + ozoneKey + "Part number: " + partKeyInfo.getPartNumber() + "size " + currentPartKeyInfo.getDataSize() + " is less than minimum part size " + 0x500000);
                    throw new OMException("Complete Multipart Upload Failed: Entity too small: volume: " + volumeName + "bucket: " + bucketName + "key: " + keyName, OMException.ResultCodes.ENTITY_TOO_SMALL);
                }
                OmKeyLocationInfoGroup currentKeyInfoGroup = (OmKeyLocationInfoGroup)currentPartKeyInfo.getKeyLocationVersions().get(0);
                locations.addAll(currentKeyInfoGroup.getLocationList());
                size += currentPartKeyInfo.getDataSize();
                ++partsCount;
            }
            if (keyInfo == null) {
                OmKeyLocationInfoGroup keyLocationInfoGroup = new OmKeyLocationInfoGroup(0L, locations);
                keyInfo = new OmKeyInfo.Builder().setVolumeName(omKeyArgs.getVolumeName()).setBucketName(omKeyArgs.getBucketName()).setKeyName(omKeyArgs.getKeyName()).setReplicationFactor(factor).setReplicationType(type).setCreationTime(Time.now()).setModificationTime(Time.now()).setDataSize(size).setOmKeyLocationInfos(Collections.singletonList(keyLocationInfoGroup)).setAcls(omKeyArgs.getAcls()).build();
            } else {
                keyInfo.updateLocationInfoList(locations);
            }
            DBStore store = this.metadataManager.getStore();
            try (BatchOperation batch = store.initBatchOperation();){
                this.metadataManager.getMultipartInfoTable().deleteWithBatch(batch, (Object)multipartKey);
                this.metadataManager.getKeyTable().putWithBatch(batch, (Object)ozoneKey, (Object)keyInfo);
                this.metadataManager.getOpenKeyTable().deleteWithBatch(batch, (Object)multipartKey);
                store.commitBatchOperation(batch);
            }
            omMultipartUploadCompleteInfo = new OmMultipartUploadCompleteInfo(omKeyArgs.getVolumeName(), omKeyArgs.getBucketName(), omKeyArgs.getKeyName(), DigestUtils.sha256Hex((String)keyName));
        }
        catch (OMException ex) {
            try {
                throw ex;
                catch (IOException ex2) {
                    LOG.error("Complete Multipart Upload Failed: volume: " + volumeName + "bucket: " + bucketName + "key: " + keyName, (Throwable)ex2);
                    throw new OMException(ex2.getMessage(), OMException.ResultCodes.COMPLETE_MULTIPART_UPLOAD_ERROR);
                }
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                throw throwable;
            }
        }
        this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        return omMultipartUploadCompleteInfo;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void abortMultipartUpload(OmKeyArgs omKeyArgs) throws IOException {
        Preconditions.checkNotNull((Object)omKeyArgs);
        String volumeName = omKeyArgs.getVolumeName();
        String bucketName = omKeyArgs.getBucketName();
        String keyName = omKeyArgs.getKeyName();
        String uploadID = omKeyArgs.getMultipartUploadID();
        Preconditions.checkNotNull((Object)uploadID, (Object)"uploadID cannot be null");
        this.validateS3Bucket(volumeName, bucketName);
        this.metadataManager.getLock().acquireLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        try {
            String multipartKey = this.metadataManager.getMultipartKey(volumeName, bucketName, keyName, uploadID);
            OmMultipartKeyInfo multipartKeyInfo = (OmMultipartKeyInfo)this.metadataManager.getMultipartInfoTable().get((Object)multipartKey);
            OmKeyInfo openKeyInfo = (OmKeyInfo)this.metadataManager.getOpenKeyTable().get((Object)multipartKey);
            if (openKeyInfo == null) {
                LOG.error("Abort Multipart Upload Failed: volume: " + volumeName + "bucket: " + bucketName + "key: " + keyName + "with error no such uploadID:" + uploadID);
                throw new OMException("Abort Multipart Upload Failed: volume: " + volumeName + "bucket: " + bucketName + "key: " + keyName, OMException.ResultCodes.NO_SUCH_MULTIPART_UPLOAD_ERROR);
            }
            TreeMap partKeyInfoMap = multipartKeyInfo.getPartKeyInfoMap();
            DBStore store = this.metadataManager.getStore();
            try (BatchOperation batch = store.initBatchOperation();){
                for (Map.Entry partKeyInfoEntry : partKeyInfoMap.entrySet()) {
                    OzoneManagerProtocolProtos.PartKeyInfo partKeyInfo = (OzoneManagerProtocolProtos.PartKeyInfo)partKeyInfoEntry.getValue();
                    OmKeyInfo currentKeyPartInfo = OmKeyInfo.getFromProtobuf((OzoneManagerProtocolProtos.KeyInfo)partKeyInfo.getPartKeyInfo());
                    this.metadataManager.getDeletedTable().putWithBatch(batch, (Object)partKeyInfo.getPartName(), (Object)currentKeyPartInfo);
                }
                this.metadataManager.getMultipartInfoTable().deleteWithBatch(batch, (Object)multipartKey);
                this.metadataManager.getOpenKeyTable().deleteWithBatch(batch, (Object)multipartKey);
                store.commitBatchOperation(batch);
            }
        }
        catch (OMException ex) {
            try {
                throw ex;
                catch (IOException ex2) {
                    LOG.error("Abort Multipart Upload Failed: volume: " + volumeName + "bucket: " + bucketName + "key: " + keyName, (Throwable)ex2);
                    throw new OMException(ex2.getMessage(), OMException.ResultCodes.ABORT_MULTIPART_UPLOAD_FAILED);
                }
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                throw throwable;
            }
        }
        this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OmMultipartUploadListParts listParts(String volumeName, String bucketName, String keyName, String uploadID, int partNumberMarker, int maxParts) throws IOException {
        OmMultipartUploadListParts omMultipartUploadListParts;
        Preconditions.checkNotNull((Object)volumeName);
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)keyName);
        Preconditions.checkNotNull((Object)uploadID);
        boolean isTruncated = false;
        int nextPartNumberMarker = 0;
        this.metadataManager.getLock().acquireLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        try {
            Map.Entry partKeyInfoEntry;
            String multipartKey = this.metadataManager.getMultipartKey(volumeName, bucketName, keyName, uploadID);
            OmMultipartKeyInfo multipartKeyInfo = (OmMultipartKeyInfo)this.metadataManager.getMultipartInfoTable().get((Object)multipartKey);
            if (multipartKeyInfo == null) {
                throw new OMException("No Such Multipart upload exists for this key.", OMException.ResultCodes.NO_SUCH_MULTIPART_UPLOAD_ERROR);
            }
            TreeMap partKeyInfoMap = multipartKeyInfo.getPartKeyInfoMap();
            Iterator partKeyInfoMapIterator = partKeyInfoMap.entrySet().iterator();
            HddsProtos.ReplicationType replicationType = null;
            int count = 0;
            ArrayList<OmPartInfo> omPartInfoList = new ArrayList<OmPartInfo>();
            while (count < maxParts && partKeyInfoMapIterator.hasNext()) {
                partKeyInfoEntry = partKeyInfoMapIterator.next();
                nextPartNumberMarker = (Integer)partKeyInfoEntry.getKey();
                if ((Integer)partKeyInfoEntry.getKey() <= partNumberMarker) continue;
                OzoneManagerProtocolProtos.PartKeyInfo partKeyInfo = (OzoneManagerProtocolProtos.PartKeyInfo)partKeyInfoEntry.getValue();
                OmPartInfo omPartInfo = new OmPartInfo(partKeyInfo.getPartNumber(), partKeyInfo.getPartName(), partKeyInfo.getPartKeyInfo().getModificationTime(), partKeyInfo.getPartKeyInfo().getDataSize());
                omPartInfoList.add(omPartInfo);
                replicationType = partKeyInfo.getPartKeyInfo().getType();
                ++count;
            }
            if (replicationType == null) {
                OmKeyInfo omKeyInfo = (OmKeyInfo)this.metadataManager.getOpenKeyTable().get((Object)multipartKey);
                if (omKeyInfo == null) {
                    throw new IllegalStateException("Open key is missing for multipart upload " + multipartKey);
                }
                replicationType = omKeyInfo.getType();
            }
            Preconditions.checkNotNull(replicationType, (Object)"Replication type can't be identified");
            if (partKeyInfoMapIterator.hasNext()) {
                partKeyInfoEntry = partKeyInfoMapIterator.next();
                isTruncated = true;
            } else {
                isTruncated = false;
                nextPartNumberMarker = 0;
            }
            OmMultipartUploadListParts omMultipartUploadListParts2 = new OmMultipartUploadListParts(replicationType, nextPartNumberMarker, isTruncated);
            omMultipartUploadListParts2.addPartList(omPartInfoList);
            omMultipartUploadListParts = omMultipartUploadListParts2;
        }
        catch (OMException ex) {
            try {
                throw ex;
                catch (IOException ex2) {
                    LOG.error("List Multipart Upload Parts Failed: volume: " + volumeName + "bucket: " + bucketName + "key: " + keyName, (Throwable)ex2);
                    throw new OMException(ex2.getMessage(), OMException.ResultCodes.LIST_MULTIPART_UPLOAD_PARTS_FAILED);
                }
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                throw throwable;
            }
        }
        this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        return omMultipartUploadListParts;
    }

    @Override
    public boolean addAcl(OzoneObj obj, OzoneAcl acl) throws IOException {
        this.validateOzoneObj(obj);
        String volume = obj.getVolumeName();
        String bucket = obj.getBucketName();
        String keyName = obj.getKeyName();
        boolean changed = false;
        this.metadataManager.getLock().acquireLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
        try {
            this.validateBucket(volume, bucket);
            String objectKey = this.metadataManager.getOzoneKey(volume, bucket, keyName);
            OmKeyInfo keyInfo = (OmKeyInfo)this.metadataManager.getKeyTable().get((Object)objectKey);
            if (keyInfo == null) {
                throw new OMException("Key not found. Key:" + objectKey, OMException.ResultCodes.KEY_NOT_FOUND);
            }
            if (keyInfo.getAcls() == null) {
                keyInfo.setAcls(new ArrayList());
            }
            if (changed = keyInfo.addAcl(acl)) {
                this.metadataManager.getKeyTable().put((Object)objectKey, (Object)keyInfo);
            }
        }
        catch (IOException ex) {
            try {
                if (!(ex instanceof OMException)) {
                    LOG.error("Add acl operation failed for key:{}/{}/{}", new Object[]{volume, bucket, keyName, ex});
                }
                throw ex;
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
                throw throwable;
            }
        }
        this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
        return changed;
    }

    @Override
    public boolean removeAcl(OzoneObj obj, OzoneAcl acl) throws IOException {
        this.validateOzoneObj(obj);
        String volume = obj.getVolumeName();
        String bucket = obj.getBucketName();
        String keyName = obj.getKeyName();
        boolean changed = false;
        this.metadataManager.getLock().acquireLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
        try {
            this.validateBucket(volume, bucket);
            String objectKey = this.metadataManager.getOzoneKey(volume, bucket, keyName);
            OmKeyInfo keyInfo = (OmKeyInfo)this.metadataManager.getKeyTable().get((Object)objectKey);
            if (keyInfo == null) {
                throw new OMException("Key not found. Key:" + objectKey, OMException.ResultCodes.KEY_NOT_FOUND);
            }
            changed = keyInfo.removeAcl(acl);
            if (changed) {
                this.metadataManager.getKeyTable().put((Object)objectKey, (Object)keyInfo);
            }
        }
        catch (IOException ex) {
            try {
                if (!(ex instanceof OMException)) {
                    LOG.error("Remove acl operation failed for key:{}/{}/{}", new Object[]{volume, bucket, keyName, ex});
                }
                throw ex;
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
                throw throwable;
            }
        }
        this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
        return changed;
    }

    @Override
    public boolean setAcl(OzoneObj obj, List<OzoneAcl> acls) throws IOException {
        this.validateOzoneObj(obj);
        String volume = obj.getVolumeName();
        String bucket = obj.getBucketName();
        String keyName = obj.getKeyName();
        boolean changed = false;
        this.metadataManager.getLock().acquireLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
        try {
            this.validateBucket(volume, bucket);
            String objectKey = this.metadataManager.getOzoneKey(volume, bucket, keyName);
            OmKeyInfo keyInfo = (OmKeyInfo)this.metadataManager.getKeyTable().get((Object)objectKey);
            if (keyInfo == null) {
                throw new OMException("Key not found. Key:" + objectKey, OMException.ResultCodes.KEY_NOT_FOUND);
            }
            changed = keyInfo.setAcls(acls);
            if (changed) {
                this.metadataManager.getKeyTable().put((Object)objectKey, (Object)keyInfo);
            }
        }
        catch (IOException ex) {
            try {
                if (!(ex instanceof OMException)) {
                    LOG.error("Set acl operation failed for key:{}/{}/{}", new Object[]{volume, bucket, keyName, ex});
                }
                throw ex;
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
                throw throwable;
            }
        }
        this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
        return changed;
    }

    @Override
    public List<OzoneAcl> getAcl(OzoneObj obj) throws IOException {
        List list;
        this.validateOzoneObj(obj);
        String volume = obj.getVolumeName();
        String bucket = obj.getBucketName();
        String keyName = obj.getKeyName();
        this.metadataManager.getLock().acquireLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
        try {
            this.validateBucket(volume, bucket);
            String objectKey = this.metadataManager.getOzoneKey(volume, bucket, keyName);
            OmKeyInfo keyInfo = (OmKeyInfo)this.metadataManager.getKeyTable().get((Object)objectKey);
            if (keyInfo == null) {
                throw new OMException("Key not found. Key:" + objectKey, OMException.ResultCodes.KEY_NOT_FOUND);
            }
            list = keyInfo.getAcls();
        }
        catch (IOException ex) {
            try {
                if (!(ex instanceof OMException)) {
                    LOG.error("Get acl operation failed for key:{}/{}/{}", new Object[]{volume, bucket, keyName, ex});
                }
                throw ex;
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
                throw throwable;
            }
        }
        this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean checkAccess(OzoneObj ozObject, RequestContext context) throws OMException {
        OmKeyInfo keyInfo;
        String objectKey;
        String bucket;
        String volume;
        block10: {
            boolean bl2;
            Objects.requireNonNull(ozObject);
            Objects.requireNonNull(context);
            Objects.requireNonNull(context.getClientUgi());
            volume = ozObject.getVolumeName();
            bucket = ozObject.getBucketName();
            String keyName = ozObject.getKeyName();
            objectKey = this.metadataManager.getOzoneKey(volume, bucket, keyName);
            OmKeyArgs args = new OmKeyArgs.Builder().setVolumeName(volume).setBucketName(bucket).setKeyName(keyName).build();
            this.metadataManager.getLock().acquireLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
            try {
                this.validateBucket(volume, bucket);
                keyInfo = null;
                try {
                    OzoneFileStatus fileStatus = this.getFileStatus(args);
                    keyInfo = fileStatus.getKeyInfo();
                    if (keyInfo != null) break block10;
                    LOG.debug("key:{} is non-existent parent, permit access to user:{}", (Object)keyName, (Object)context.getClientUgi());
                    bl2 = true;
                }
                catch (OMException e) {
                    if (e.getResult() == OMException.ResultCodes.FILE_NOT_FOUND) {
                        keyInfo = (OmKeyInfo)this.metadataManager.getOpenKeyTable().get((Object)objectKey);
                    }
                    break block10;
                }
            }
            catch (IOException ex) {
                try {
                    if (ex instanceof OMException) {
                        throw (OMException)((Object)ex);
                    }
                    LOG.error("CheckAccess operation failed for key:{}/{}/{}", new Object[]{volume, bucket, keyName, ex});
                    throw new OMException("Check access operation failed for key:" + keyName, (Throwable)ex, OMException.ResultCodes.INTERNAL_ERROR);
                }
                catch (Throwable throwable) {
                    this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
                    throw throwable;
                }
            }
            this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
            return bl2;
        }
        if (keyInfo == null) {
            throw new OMException("Key not found, checkAccess failed. Key:" + objectKey, OMException.ResultCodes.KEY_NOT_FOUND);
        }
        boolean hasAccess = OzoneAclUtil.checkAclRight((List)keyInfo.getAcls(), (RequestContext)context);
        LOG.debug("user:{} has access rights for key:{} :{} ", new Object[]{context.getClientUgi(), ozObject.getKeyName(), hasAccess});
        boolean bl = hasAccess;
        this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
        return bl;
    }

    private void validateOzoneObj(OzoneObj obj) throws OMException {
        Objects.requireNonNull(obj);
        if (!obj.getResourceType().equals((Object)OzoneObj.ResourceType.KEY)) {
            throw new IllegalArgumentException("Unexpected argument passed to KeyManager. OzoneObj type:" + obj.getResourceType());
        }
        String volume = obj.getVolumeName();
        String bucket = obj.getBucketName();
        String keyName = obj.getKeyName();
        if (Strings.isNullOrEmpty((String)volume)) {
            throw new OMException("Volume name is required.", OMException.ResultCodes.VOLUME_NOT_FOUND);
        }
        if (Strings.isNullOrEmpty((String)bucket)) {
            throw new OMException("Bucket name is required.", OMException.ResultCodes.BUCKET_NOT_FOUND);
        }
        if (Strings.isNullOrEmpty((String)keyName)) {
            throw new OMException("Key name is required.", OMException.ResultCodes.KEY_NOT_FOUND);
        }
    }

    @Override
    public OzoneFileStatus getFileStatus(OmKeyArgs args) throws IOException {
        String keyName;
        String bucketName;
        String volumeName;
        block9: {
            String dirKey;
            block8: {
                block7: {
                    block6: {
                        OzoneFileStatus ozoneFileStatus;
                        Preconditions.checkNotNull((Object)args, (Object)"Key args can not be null");
                        volumeName = args.getVolumeName();
                        bucketName = args.getBucketName();
                        keyName = args.getKeyName();
                        this.metadataManager.getLock().acquireLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                        try {
                            if (keyName.length() != 0) break block6;
                            this.validateBucket(volumeName, bucketName);
                            ozoneFileStatus = new OzoneFileStatus("/");
                        }
                        catch (Throwable throwable) {
                            this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                            throw throwable;
                        }
                        this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                        return ozoneFileStatus;
                    }
                    String fileKeyBytes = this.metadataManager.getOzoneKey(volumeName, bucketName, keyName);
                    OmKeyInfo fileKeyInfo = (OmKeyInfo)this.metadataManager.getKeyTable().get((Object)fileKeyBytes);
                    if (fileKeyInfo == null) break block7;
                    OzoneFileStatus ozoneFileStatus = new OzoneFileStatus(fileKeyInfo, this.scmBlockSize, false);
                    this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                    return ozoneFileStatus;
                }
                dirKey = OzoneFSUtils.addTrailingSlashIfNeeded((String)keyName);
                String dirKeyBytes = this.metadataManager.getOzoneKey(volumeName, bucketName, dirKey);
                OmKeyInfo dirKeyInfo = (OmKeyInfo)this.metadataManager.getKeyTable().get((Object)dirKeyBytes);
                if (dirKeyInfo == null) break block8;
                OzoneFileStatus ozoneFileStatus = new OzoneFileStatus(dirKeyInfo, this.scmBlockSize, true);
                this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                return ozoneFileStatus;
            }
            List keys = this.metadataManager.listKeys(volumeName, bucketName, null, dirKey, 1);
            if (!keys.iterator().hasNext()) break block9;
            OzoneFileStatus ozoneFileStatus = new OzoneFileStatus(keyName);
            this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            return ozoneFileStatus;
        }
        LOG.debug("Unable to get file status for the key: volume:" + volumeName + " bucket:" + bucketName + " key:" + keyName + " with error no such file exists:");
        throw new OMException("Unable to get file status: volume: " + volumeName + " bucket: " + bucketName + " key: " + keyName, OMException.ResultCodes.FILE_NOT_FOUND);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createDirectory(OmKeyArgs args) throws IOException {
        String keyName;
        String bucketName;
        String volumeName;
        block5: {
            block4: {
                Preconditions.checkNotNull((Object)args, (Object)"Key args can not be null");
                volumeName = args.getVolumeName();
                bucketName = args.getBucketName();
                keyName = args.getKeyName();
                this.metadataManager.getLock().acquireLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                try {
                    if (keyName.length() != 0) break block4;
                }
                catch (Throwable throwable) {
                    this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                    throw throwable;
                }
                this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                return;
            }
            Path keyPath = Paths.get(keyName, new String[0]);
            OzoneFileStatus status = this.verifyNoFilesInPath(volumeName, bucketName, keyPath, false);
            if (status == null || !OzoneFSUtils.pathToKey((org.apache.hadoop.fs.Path)status.getPath()).equals(keyName)) break block5;
            this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            return;
        }
        OmKeyInfo dirDbKeyInfo = this.createDirectoryKey(volumeName, bucketName, keyName, args.getAcls());
        String dirDbKey = this.metadataManager.getOzoneKey(volumeName, bucketName, dirDbKeyInfo.getKeyName());
        this.metadataManager.getKeyTable().put((Object)dirDbKey, (Object)dirDbKeyInfo);
        this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
    }

    private OmKeyInfo createDirectoryKey(String volumeName, String bucketName, String keyName, List<OzoneAcl> acls) throws IOException {
        OmBucketInfo bucketInfo = this.getBucketInfo(volumeName, bucketName);
        String dir = OzoneFSUtils.addTrailingSlashIfNeeded((String)keyName);
        FileEncryptionInfo encInfo = this.getFileEncryptionInfo(bucketInfo);
        return new OmKeyInfo.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(dir).setOmKeyLocationInfos(Collections.singletonList(new OmKeyLocationInfoGroup(0L, new ArrayList()))).setCreationTime(Time.now()).setModificationTime(Time.now()).setDataSize(0L).setReplicationType(HddsProtos.ReplicationType.RATIS).setReplicationFactor(HddsProtos.ReplicationFactor.ONE).setFileEncryptionInfo(encInfo).setAcls(acls).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OpenKeySession createFile(OmKeyArgs args, boolean isOverWrite, boolean isRecursive) throws IOException {
        OpenKeySession keySession;
        Preconditions.checkNotNull((Object)args, (Object)"Key args can not be null");
        String volumeName = args.getVolumeName();
        String bucketName = args.getBucketName();
        String keyName = args.getKeyName();
        this.metadataManager.getLock().acquireLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        try {
            block6: {
                try {
                    OzoneFileStatus fileStatus = this.getFileStatus(args);
                    if (fileStatus.isDirectory()) {
                        throw new OMException("Can not write to directory: " + keyName, OMException.ResultCodes.NOT_A_FILE);
                    }
                    if (fileStatus.isFile() && !isOverWrite) {
                        throw new OMException("File " + keyName + " already exists", OMException.ResultCodes.FILE_ALREADY_EXISTS);
                    }
                }
                catch (OMException ex) {
                    if (ex.getResult() == OMException.ResultCodes.FILE_NOT_FOUND) break block6;
                    throw ex;
                }
            }
            this.verifyNoFilesInPath(volumeName, bucketName, Paths.get(keyName, new String[0]).getParent(), !isRecursive);
            keySession = this.openKey(args);
        }
        catch (Throwable throwable) {
            this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            throw throwable;
        }
        this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        return keySession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OmKeyInfo lookupFile(OmKeyArgs args, String clientAddress) throws IOException {
        String keyName;
        String bucketName;
        String volumeName;
        block2: {
            OmKeyInfo omKeyInfo;
            Preconditions.checkNotNull((Object)args, (Object)"Key args can not be null");
            volumeName = args.getVolumeName();
            bucketName = args.getBucketName();
            keyName = args.getKeyName();
            this.metadataManager.getLock().acquireLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            try {
                OzoneFileStatus fileStatus = this.getFileStatus(args);
                if (!fileStatus.isFile()) break block2;
                this.sortDatanodeInPipeline(fileStatus.getKeyInfo(), clientAddress);
                omKeyInfo = fileStatus.getKeyInfo();
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                throw throwable;
            }
            this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            return omKeyInfo;
        }
        this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        throw new OMException("Can not write to directory: " + keyName, OMException.ResultCodes.NOT_A_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public List<OzoneFileStatus> listStatus(OmKeyArgs args, boolean recursive, String startKey, long numEntries) throws IOException {
        block9: {
            block8: {
                Preconditions.checkNotNull((Object)args, (Object)"Key args can not be null");
                volumeName = args.getVolumeName();
                bucketName = args.getBucketName();
                keyName = args.getKeyName();
                fileStatusList = new ArrayList<OzoneFileStatus>();
                this.metadataManager.getLock().acquireLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                if (!Strings.isNullOrEmpty((String)startKey)) ** GOTO lbl19
                fileStatus = this.getFileStatus(args);
                if (!fileStatus.isFile()) break block8;
                var11_10 = Collections.singletonList(fileStatus);
                this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                return var11_10;
            }
            startKey = OzoneFSUtils.addTrailingSlashIfNeeded((String)keyName);
lbl19:
            // 2 sources

            seekKeyInDb = this.metadataManager.getOzoneKey(volumeName, bucketName, startKey);
            keyInDb = OzoneFSUtils.addTrailingSlashIfNeeded((String)this.metadataManager.getOzoneKey(volumeName, bucketName, keyName));
            iterator = this.metadataManager.getKeyTable().iterator();
            iterator.seek((Object)seekKeyInDb);
            if (iterator.hasNext()) break block9;
            var13_13 = Collections.emptyList();
            this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            return var13_13;
        }
        try {
            if (((String)iterator.key()).equals(keyInDb)) {
                iterator.next();
            }
            while (iterator.hasNext() && numEntries - (long)fileStatusList.size() > 0L) {
                entryInDb = (String)iterator.key();
                value = (OmKeyInfo)((Table.KeyValue)iterator.value()).getValue();
                if (!entryInDb.startsWith(keyInDb)) ** break;
                entryKeyName = value.getKeyName();
                if (recursive) {
                    fileStatusList.add(new OzoneFileStatus(value, this.scmBlockSize, OzoneFSUtils.isFile((String)entryKeyName) == false));
                    iterator.next();
                    continue;
                }
                immediateChild = OzoneFSUtils.getImmediateChild((String)entryKeyName, (String)keyName);
                isFile = OzoneFSUtils.isFile((String)immediateChild);
                if (isFile) {
                    fileStatusList.add(new OzoneFileStatus(value, this.scmBlockSize, isFile == false));
                    iterator.next();
                    continue;
                }
                fileStatusList.add(new OzoneFileStatus(immediateChild));
                iterator.seek((Object)this.getNextGreaterString(volumeName, bucketName, immediateChild));
            }
        }
        catch (Throwable var18_19) {
            this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            throw var18_19;
        }
        this.metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        return fileStatusList;
    }

    private String getNextGreaterString(String volumeName, String bucketName, String keyPrefix) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)keyPrefix) ? 1 : 0) != 0, (Object)"Key prefix is null or empty");
        CodecRegistry codecRegistry = ((RDBStore)this.metadataManager.getStore()).getCodecRegistry();
        byte[] keyPrefixInBytes = codecRegistry.asRawData((Object)keyPrefix);
        int n = keyPrefixInBytes.length - 1;
        keyPrefixInBytes[n] = (byte)(keyPrefixInBytes[n] + 1);
        String nextPrefix = (String)codecRegistry.asObject(keyPrefixInBytes, String.class);
        return this.metadataManager.getOzoneKey(volumeName, bucketName, nextPrefix);
    }

    private OzoneFileStatus verifyNoFilesInPath(String volumeName, String bucketName, Path path, boolean directoryMustExist) throws IOException {
        OmKeyArgs.Builder argsBuilder = new OmKeyArgs.Builder().setVolumeName(volumeName).setBucketName(bucketName);
        while (path != null) {
            block6: {
                String keyName = path.toString();
                try {
                    OzoneFileStatus fileStatus = this.getFileStatus(argsBuilder.setKeyName(keyName).build());
                    if (fileStatus.isFile()) {
                        LOG.error("Unable to create directory (File already exists): volume: " + volumeName + "bucket: " + bucketName + "key: " + keyName);
                        throw new OMException("Unable to create directory at : volume: " + volumeName + "bucket: " + bucketName + "key: " + keyName, OMException.ResultCodes.FILE_ALREADY_EXISTS);
                    }
                    if (fileStatus.isDirectory()) {
                        return fileStatus;
                    }
                }
                catch (OMException ex) {
                    if (ex.getResult() != OMException.ResultCodes.FILE_NOT_FOUND) {
                        throw ex;
                    }
                    if (ex.getResult() != OMException.ResultCodes.FILE_NOT_FOUND || !directoryMustExist) break block6;
                    throw new OMException("Parent directory does not exist", ex.getCause(), OMException.ResultCodes.DIRECTORY_NOT_FOUND);
                }
            }
            path = path.getParent();
        }
        return null;
    }

    private FileEncryptionInfo getFileEncryptionInfo(OmBucketInfo bucketInfo) throws IOException {
        FileEncryptionInfo encInfo = null;
        BucketEncryptionKeyInfo ezInfo = bucketInfo.getEncryptionKeyInfo();
        if (ezInfo != null) {
            if (this.getKMSProvider() == null) {
                throw new OMException("Invalid KMS provider, check configuration hadoop.security.key.provider.path", OMException.ResultCodes.INVALID_KMS_PROVIDER);
            }
            String ezKeyName = ezInfo.getKeyName();
            KeyProviderCryptoExtension.EncryptedKeyVersion edek = this.generateEDEK(ezKeyName);
            encInfo = new FileEncryptionInfo(ezInfo.getSuite(), ezInfo.getVersion(), edek.getEncryptedKeyVersion().getMaterial(), edek.getEncryptedKeyIv(), ezKeyName, edek.getEncryptionKeyVersionName());
        }
        return encInfo;
    }

    private void sortDatanodeInPipeline(OmKeyInfo keyInfo, String clientMachine) {
        if (keyInfo != null && clientMachine != null && !clientMachine.isEmpty()) {
            for (OmKeyLocationInfoGroup key : keyInfo.getKeyLocationVersions()) {
                key.getLocationList().forEach(k -> {
                    List nodes = k.getPipeline().getNodes();
                    if (nodes == null || nodes.size() == 0) {
                        LOG.warn("Datanodes for pipeline {} is empty", (Object)k.getPipeline().getId().toString());
                        return;
                    }
                    ArrayList nodeList = new ArrayList();
                    nodes.stream().forEach(node -> nodeList.add(node.getUuidString()));
                    try {
                        List sortedNodes = this.scmClient.getBlockClient().sortDatanodes(nodeList, clientMachine);
                        k.getPipeline().setNodesInOrder(sortedNodes);
                        LOG.debug("Sort datanodes {} for client {}, return {}", new Object[]{nodes, clientMachine, sortedNodes});
                    }
                    catch (IOException e) {
                        LOG.warn("Unable to sort datanodes based on distance to client, volume=" + keyInfo.getVolumeName() + ", bucket=" + keyInfo.getBucketName() + ", key=" + keyInfo.getKeyName() + ", client=" + clientMachine + ", datanodes=" + nodes.toString() + ", exception=" + e.getMessage());
                    }
                });
            }
        }
    }
}

