/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdfs.server.namenode.TransferFsImage;
import org.apache.hadoop.hdfs.util.DataTransferThrottler;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.utils.db.DBCheckpoint;
import org.apache.hadoop.utils.db.DBStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMDBCheckpointServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(OMDBCheckpointServlet.class);
    private static final long serialVersionUID = 1L;
    private transient OzoneManager om;
    private transient DBStore omDbStore;
    private transient OMMetrics omMetrics;
    private transient DataTransferThrottler throttler = null;

    public void init() throws ServletException {
        this.om = (OzoneManager)this.getServletContext().getAttribute("ozone.om");
        if (this.om == null) {
            LOG.error("Unable to initialize OMDBCheckpointServlet. OM is null");
            return;
        }
        this.omDbStore = this.om.getMetadataManager().getStore();
        this.omMetrics = this.om.getMetrics();
        OzoneConfiguration configuration = this.om.getConfiguration();
        long transferBandwidth = configuration.getLongBytes("ozone.manager.db.checkpoint.transfer.bandwidthPerSec", 0L);
        if (transferBandwidth > 0L) {
            this.throttler = new DataTransferThrottler(transferBandwidth);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        block14: {
            FileInputStream checkpointFileInputStream;
            block13: {
                LOG.info("Received request to obtain OM DB checkpoint snapshot");
                if (this.omDbStore == null) {
                    LOG.error("Unable to process metadata snapshot request. DB Store is null");
                    response.setStatus(500);
                    return;
                }
                checkpointFileInputStream = null;
                File checkPointTarFile = null;
                try {
                    long ratisSnapshotIndex;
                    boolean flush = false;
                    String flushParam = request.getParameter("flushBeforeCheckpoint");
                    if (StringUtils.isNotEmpty((CharSequence)flushParam)) {
                        flush = Boolean.valueOf(flushParam);
                    }
                    boolean takeRatisSnapshot = false;
                    String snapshotBeforeCheckpointParam = request.getParameter("snapshotBeforeCheckpoint");
                    if (StringUtils.isNotEmpty((CharSequence)snapshotBeforeCheckpointParam)) {
                        takeRatisSnapshot = Boolean.valueOf(snapshotBeforeCheckpointParam);
                    }
                    if (takeRatisSnapshot) {
                        flush = false;
                        ratisSnapshotIndex = this.om.saveRatisSnapshot(true);
                    } else {
                        ratisSnapshotIndex = this.om.loadRatisSnapshotIndex();
                    }
                    DBCheckpoint checkpoint = this.omDbStore.getCheckpoint(flush);
                    if (checkpoint == null) {
                        LOG.error("Unable to process metadata snapshot request. Checkpoint request returned null.");
                        response.setStatus(500);
                        return;
                    }
                    this.omMetrics.setLastCheckpointCreationTimeTaken(checkpoint.checkpointCreationTimeTaken());
                    Instant start = Instant.now();
                    checkPointTarFile = OmUtils.createTarFile((Path)checkpoint.getCheckpointLocation());
                    Instant end = Instant.now();
                    long duration = Duration.between(start, end).toMillis();
                    LOG.debug("Time taken to archive the checkpoint : " + duration + " milliseconds");
                    LOG.info("Checkpoint Tar location = " + checkPointTarFile.getAbsolutePath());
                    this.omMetrics.setLastCheckpointTarOperationTimeTaken(duration);
                    response.setContentType("application/x-tgz");
                    response.setHeader("Content-Disposition", "attachment; filename=\"" + checkPointTarFile.getName() + "\"");
                    response.setHeader("ratisSnapshotIndex", String.valueOf(ratisSnapshotIndex));
                    checkpointFileInputStream = new FileInputStream(checkPointTarFile);
                    start = Instant.now();
                    TransferFsImage.copyFileToStream((OutputStream)response.getOutputStream(), (File)checkPointTarFile, (FileInputStream)checkpointFileInputStream, (DataTransferThrottler)this.throttler);
                    end = Instant.now();
                    duration = Duration.between(start, end).toMillis();
                    LOG.debug("Time taken to write the checkpoint to response output stream: " + duration + " milliseconds");
                    this.omMetrics.setLastCheckpointStreamingTimeTaken(duration);
                    checkpoint.cleanupCheckpoint();
                    if (checkPointTarFile == null) break block13;
                }
                catch (IOException e) {
                    LOG.error("Unable to process metadata snapshot request. ", (Throwable)e);
                    response.setStatus(500);
                    break block14;
                }
                finally {
                    if (checkPointTarFile != null) {
                        FileUtils.deleteQuietly(checkPointTarFile);
                    }
                    IOUtils.closeStream(checkpointFileInputStream);
                }
                FileUtils.deleteQuietly((File)checkPointTarFile);
            }
            IOUtils.closeStream((Closeable)checkpointFileInputStream);
        }
    }
}

