/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import java.io.IOException;
import java.util.Properties;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.common.Storage;

public class OMStorage
extends Storage {
    public static final String STORAGE_DIR = "om";
    public static final String OM_ID = "omUuid";
    public static final String OM_CERT_SERIAL_ID = "omCertSerialId";

    public OMStorage(OzoneConfiguration conf) throws IOException {
        super(HddsProtos.NodeType.OM, OmUtils.getOmDbDir((Configuration)conf), STORAGE_DIR);
    }

    public void setScmId(String scmId) throws IOException {
        if (this.getState() == Storage.StorageState.INITIALIZED) {
            throw new IOException("OM is already initialized.");
        }
        this.getStorageInfo().setProperty("scmUuid", scmId);
    }

    public void setOmCertSerialId(String certSerialId) throws IOException {
        this.getStorageInfo().setProperty(OM_CERT_SERIAL_ID, certSerialId);
    }

    public void setOmId(String omId) throws IOException {
        if (this.getState() == Storage.StorageState.INITIALIZED) {
            throw new IOException("OM is already initialized.");
        }
        this.getStorageInfo().setProperty(OM_ID, omId);
    }

    public String getScmId() {
        return this.getStorageInfo().getProperty("scmUuid");
    }

    public String getOmId() {
        return this.getStorageInfo().getProperty(OM_ID);
    }

    public String getOmCertSerialId() {
        return this.getStorageInfo().getProperty(OM_CERT_SERIAL_ID);
    }

    protected Properties getNodeProperties() {
        String omId = this.getOmId();
        if (omId == null) {
            omId = UUID.randomUUID().toString();
        }
        Properties omProperties = new Properties();
        omProperties.setProperty(OM_ID, omId);
        if (this.getOmCertSerialId() != null) {
            omProperties.setProperty(OM_CERT_SERIAL_ID, this.getOmCertSerialId());
        }
        return omProperties;
    }
}

