/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import java.io.IOException;
import org.apache.hadoop.hdds.cli.GenericCli;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.ozone.om.OMStarterInterface;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="ozone om", hidden=true, description={"Start or initialize the Ozone Manager."}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true)
public class OzoneManagerStarter
extends GenericCli {
    private OzoneConfiguration conf;
    private OMStarterInterface receiver;
    private static final Logger LOG = LoggerFactory.getLogger(OzoneManagerStarter.class);

    public static void main(String[] args) throws Exception {
        TracingUtil.initTracing((String)"OzoneManager");
        new OzoneManagerStarter(new OMStarterHelper()).run(args);
    }

    public OzoneManagerStarter(OMStarterInterface receiverObj) {
        this.receiver = receiverObj;
    }

    public Void call() throws Exception {
        this.commonInit();
        this.startOm();
        return null;
    }

    private void startOm() throws Exception {
        this.receiver.start(this.conf);
    }

    @CommandLine.Command(name="--init", customSynopsis={"ozone om [global options] --init"}, hidden=false, description={"Initialize the Ozone Manager if not already initialized"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
    public void initOm() throws Exception {
        this.commonInit();
        boolean result = this.receiver.init(this.conf);
        if (!result) {
            throw new IOException("OM Init failed.");
        }
    }

    private void commonInit() {
        this.conf = this.createOzoneConfiguration();
        String[] originalArgs = this.getCmd().getParseResult().originalArgs().toArray(new String[0]);
        StringUtils.startupShutdownMessage(OzoneManager.class, (String[])originalArgs, (Logger)LOG);
    }

    static class OMStarterHelper
    implements OMStarterInterface {
        OMStarterHelper() {
        }

        @Override
        public void start(OzoneConfiguration conf) throws IOException, AuthenticationException {
            OzoneManager om = OzoneManager.createOm(conf);
            om.start();
            om.join();
        }

        @Override
        public boolean init(OzoneConfiguration conf) throws IOException, AuthenticationException {
            return OzoneManager.omInit(conf);
        }
    }
}

