/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.ratis;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.ozone.container.common.transport.server.ratis.ContainerStateMachine;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OMRatisHelper;
import org.apache.hadoop.ozone.om.ratis.OzoneManagerDoubleBuffer;
import org.apache.hadoop.ozone.om.ratis.OzoneManagerRatisServer;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocolPB.OzoneManagerHARequestHandler;
import org.apache.hadoop.ozone.protocolPB.OzoneManagerHARequestHandlerImpl;
import org.apache.hadoop.util.concurrent.HadoopExecutors;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.statemachine.impl.BaseStateMachine;
import org.apache.ratis.statemachine.impl.SimpleStateMachineStorage;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.LifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OzoneManagerStateMachine
extends BaseStateMachine {
    static final Logger LOG = LoggerFactory.getLogger(ContainerStateMachine.class);
    private final SimpleStateMachineStorage storage = new SimpleStateMachineStorage();
    private final OzoneManagerRatisServer omRatisServer;
    private final OzoneManager ozoneManager;
    private OzoneManagerHARequestHandler handler;
    private RaftGroupId raftGroupId;
    private long lastAppliedIndex = 0L;
    private OzoneManagerDoubleBuffer ozoneManagerDoubleBuffer;
    private final ExecutorService executorService;
    private final ExecutorService installSnapshotExecutor;

    public OzoneManagerStateMachine(OzoneManagerRatisServer ratisServer) {
        this.omRatisServer = ratisServer;
        this.ozoneManager = this.omRatisServer.getOzoneManager();
        this.ozoneManagerDoubleBuffer = new OzoneManagerDoubleBuffer(this.ozoneManager.getMetadataManager(), this::updateLastAppliedIndex);
        this.handler = new OzoneManagerHARequestHandlerImpl(this.ozoneManager, this.ozoneManagerDoubleBuffer);
        ThreadFactory build = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("OM StateMachine ApplyTransaction Thread - %d").build();
        this.executorService = HadoopExecutors.newSingleThreadExecutor((ThreadFactory)build);
        this.installSnapshotExecutor = HadoopExecutors.newSingleThreadExecutor();
    }

    public void initialize(RaftServer server, RaftGroupId id, RaftStorage raftStorage) throws IOException {
        this.lifeCycle.startAndTransition(() -> {
            super.initialize(server, id, raftStorage);
            this.raftGroupId = id;
            this.storage.init(raftStorage);
        }, new Class[0]);
    }

    public TransactionContext startTransaction(RaftClientRequest raftClientRequest) throws IOException {
        ByteString messageContent = raftClientRequest.getMessage().getContent();
        OzoneManagerProtocolProtos.OMRequest omRequest = OMRatisHelper.convertByteStringToOMRequest((ByteString)messageContent);
        Preconditions.checkArgument((boolean)raftClientRequest.getRaftGroupId().equals((Object)this.raftGroupId));
        try {
            this.handler.validateRequest(omRequest);
        }
        catch (IOException ioe) {
            TransactionContext ctxt = TransactionContext.newBuilder().setClientRequest(raftClientRequest).setStateMachine((StateMachine)this).setServerRole(RaftProtos.RaftPeerRole.LEADER).build();
            ctxt.setException((Exception)ioe);
            return ctxt;
        }
        return this.handleStartTransactionRequests(raftClientRequest, omRequest);
    }

    public CompletableFuture<Message> applyTransaction(TransactionContext trx) {
        try {
            OzoneManagerProtocolProtos.OMRequest request = OMRatisHelper.convertByteStringToOMRequest((ByteString)trx.getStateMachineLogEntry().getLogData());
            long trxLogIndex = trx.getLogEntry().getIndex();
            CompletableFuture<Message> future = CompletableFuture.supplyAsync(() -> this.runCommand(request, trxLogIndex), this.executorService);
            return future;
        }
        catch (IOException e) {
            return OzoneManagerStateMachine.completeExceptionally(e);
        }
    }

    public CompletableFuture<Message> query(Message request) {
        try {
            OzoneManagerProtocolProtos.OMRequest omRequest = OMRatisHelper.convertByteStringToOMRequest((ByteString)request.getContent());
            return CompletableFuture.completedFuture(this.queryCommand(omRequest));
        }
        catch (IOException e) {
            return OzoneManagerStateMachine.completeExceptionally(e);
        }
    }

    public void pause() {
        this.lifeCycle.transition(LifeCycle.State.PAUSING);
        this.lifeCycle.transition(LifeCycle.State.PAUSED);
        this.ozoneManagerDoubleBuffer.stop();
    }

    public void unpause(long newLastAppliedSnaphsotIndex) {
        this.lifeCycle.startAndTransition(() -> {
            this.ozoneManagerDoubleBuffer = new OzoneManagerDoubleBuffer(this.ozoneManager.getMetadataManager(), this::updateLastAppliedIndex);
            this.updateLastAppliedIndex(newLastAppliedSnaphsotIndex);
        }, new Class[0]);
    }

    public long takeSnapshot() throws IOException {
        LOG.info("Saving Ratis snapshot on the OM.");
        if (this.ozoneManager != null) {
            return this.ozoneManager.saveRatisSnapshot(true);
        }
        return 0L;
    }

    public CompletableFuture<TermIndex> notifyInstallSnapshotFromLeader(RaftProtos.RoleInfoProto roleInfoProto, TermIndex firstTermIndexInLog) {
        String leaderNodeId = RaftPeerId.valueOf((ByteString)roleInfoProto.getSelf().getId()).toString();
        LOG.info("Received install snapshot notificaiton form OM leader: {} with term index: {}", (Object)leaderNodeId, (Object)firstTermIndexInLog);
        if (!roleInfoProto.getRole().equals((Object)RaftProtos.RaftPeerRole.LEADER)) {
            LOG.error("Received Install Snapshot notification from non-leader OM node: {}. Ignoring the notification.", (Object)leaderNodeId);
            return OzoneManagerStateMachine.completeExceptionally((Exception)((Object)new OMException("Received notification to install snaphost from non-leader OM node", OMException.ResultCodes.RATIS_ERROR)));
        }
        CompletableFuture<TermIndex> future = CompletableFuture.supplyAsync(() -> this.ozoneManager.installSnapshot(leaderNodeId), this.installSnapshotExecutor);
        return future;
    }

    public void notifyNotLeader(Collection<TransactionContext> pendingEntries) throws IOException {
        this.omRatisServer.updateServerRole();
    }

    private TransactionContext handleStartTransactionRequests(RaftClientRequest raftClientRequest, OzoneManagerProtocolProtos.OMRequest omRequest) {
        return TransactionContext.newBuilder().setClientRequest(raftClientRequest).setStateMachine((StateMachine)this).setServerRole(RaftProtos.RaftPeerRole.LEADER).setLogData(raftClientRequest.getMessage().getContent()).build();
    }

    private Message runCommand(OzoneManagerProtocolProtos.OMRequest request, long trxLogIndex) {
        OzoneManagerProtocolProtos.OMResponse response = this.handler.handleApplyTransaction(request, trxLogIndex);
        this.lastAppliedIndex = trxLogIndex;
        return OMRatisHelper.convertResponseToMessage((OzoneManagerProtocolProtos.OMResponse)response);
    }

    public void updateLastAppliedIndex(long lastAppliedIndex) {
        this.lastAppliedIndex = lastAppliedIndex;
    }

    private Message queryCommand(OzoneManagerProtocolProtos.OMRequest request) {
        OzoneManagerProtocolProtos.OMResponse response = this.handler.handle(request);
        return OMRatisHelper.convertResponseToMessage((OzoneManagerProtocolProtos.OMResponse)response);
    }

    public long getLastAppliedIndex() {
        return this.lastAppliedIndex;
    }

    private static <T> CompletableFuture<T> completeExceptionally(Exception e) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(e);
        return future;
    }

    @VisibleForTesting
    public void setHandler(OzoneManagerHARequestHandler handler) {
        this.handler = handler;
    }

    @VisibleForTesting
    public void setRaftGroupId(RaftGroupId raftGroupId) {
        this.raftGroupId = raftGroupId;
    }

    public void stop() {
        this.ozoneManagerDoubleBuffer.stop();
        HadoopExecutors.shutdown((ExecutorService)this.executorService, (Logger)LOG, (long)5L, (TimeUnit)TimeUnit.SECONDS);
        HadoopExecutors.shutdown((ExecutorService)this.installSnapshotExecutor, (Logger)LOG, (long)5L, (TimeUnit)TimeUnit.SECONDS);
    }
}

