/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.ratis.metrics;

import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;

public class OzoneManagerDoubleBufferMetrics {
    private static final String SOURCE_NAME = OzoneManagerDoubleBufferMetrics.class.getSimpleName();
    @Metric(about="Total Number of flush operations happened in OzoneManagerDoubleBuffer.")
    private MutableCounterLong totalNumOfFlushOperations;
    @Metric(about="Total Number of flushed transactions happened in OzoneManagerDoubleBuffer.")
    private MutableCounterLong totalNumOfFlushedTransactions;
    @Metric(about="Max Number of transactions flushed in a iteration in OzoneManagerDoubleBuffer. This will provide a value which is maximum number of transactions flushed in a single flush iteration till now.")
    private MutableCounterLong maxNumberOfTransactionsFlushedInOneIteration;

    public static OzoneManagerDoubleBufferMetrics create() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        return (OzoneManagerDoubleBufferMetrics)ms.register(SOURCE_NAME, "OzoneManager DoubleBuffer Metrics", (Object)new OzoneManagerDoubleBufferMetrics());
    }

    public void incrTotalNumOfFlushOperations() {
        this.totalNumOfFlushOperations.incr();
    }

    public void incrTotalSizeOfFlushedTransactions(long flushedTransactions) {
        this.totalNumOfFlushedTransactions.incr(flushedTransactions);
    }

    public void setMaxNumberOfTransactionsFlushedInOneIteration(long maxTransactions) {
        this.maxNumberOfTransactionsFlushedInOneIteration.incr(Math.negateExact(this.getMaxNumberOfTransactionsFlushedInOneIteration()) + maxTransactions);
    }

    public long getTotalNumOfFlushOperations() {
        return this.totalNumOfFlushOperations.value();
    }

    public long getTotalNumOfFlushedTransactions() {
        return this.totalNumOfFlushedTransactions.value();
    }

    public long getMaxNumberOfTransactionsFlushedInOneIteration() {
        return this.maxNumberOfTransactionsFlushedInOneIteration.value();
    }

    public void unRegister() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(SOURCE_NAME);
    }
}

