/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.bucket;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hdds.protocol.StorageType;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.KeyValueUtil;
import org.apache.hadoop.ozone.om.helpers.OmBucketArgs;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.bucket.OMBucketSetPropertyResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.utils.db.cache.CacheKey;
import org.apache.hadoop.utils.db.cache.CacheValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMBucketSetPropertyRequest
extends OMClientRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMBucketSetPropertyRequest.class);

    public OMBucketSetPropertyRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex) {
        OzoneManagerProtocolProtos.SetBucketPropertyRequest setBucketPropertyRequest = this.getOmRequest().getSetBucketPropertyRequest();
        Preconditions.checkNotNull((Object)setBucketPropertyRequest);
        OMMetrics omMetrics = ozoneManager.getMetrics();
        omMetrics.incNumBucketUpdates();
        OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
        OzoneManagerProtocolProtos.BucketArgs bucketArgs = setBucketPropertyRequest.getBucketArgs();
        OmBucketArgs omBucketArgs = OmBucketArgs.getFromProtobuf((OzoneManagerProtocolProtos.BucketArgs)bucketArgs);
        String volumeName = bucketArgs.getVolumeName();
        String bucketName = bucketArgs.getBucketName();
        OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OzoneManagerProtocolProtos.OMResponse.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.CreateBucket).setStatus(OzoneManagerProtocolProtos.Status.OK);
        OmBucketInfo omBucketInfo = null;
        AuditLogger auditLogger = ozoneManager.getAuditLogger();
        OzoneManagerProtocolProtos.UserInfo userInfo = this.getOmRequest().getUserInfo();
        try {
            if (ozoneManager.getAclsEnabled()) {
                this.checkAcls(ozoneManager, OzoneObj.ResourceType.BUCKET, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE, volumeName, bucketName, null);
            }
        }
        catch (IOException ex) {
            LOG.error("Setting bucket property failed for bucket:{} in volume:{}", new Object[]{bucketName, volumeName, ex});
            omMetrics.incNumBucketUpdateFails();
            this.auditLog(auditLogger, this.buildAuditMessage((AuditAction)OMAction.UPDATE_BUCKET, omBucketArgs.toAuditMap(), ex, userInfo));
            return new OMBucketSetPropertyResponse(omBucketInfo, this.createErrorOMResponse(omResponse, ex));
        }
        IOException exception = null;
        omMetadataManager.getLock().acquireLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        try {
            String bucketKey = omMetadataManager.getBucketKey(volumeName, bucketName);
            OmBucketInfo oldBucketInfo = (OmBucketInfo)omMetadataManager.getBucketTable().get((Object)bucketKey);
            if (oldBucketInfo == null) {
                LOG.debug("bucket: {} not found ", (Object)bucketName);
                throw new OMException("Bucket doesn't exist", OMException.ResultCodes.BUCKET_NOT_FOUND);
            }
            OmBucketInfo.Builder bucketInfoBuilder = OmBucketInfo.newBuilder();
            bucketInfoBuilder.setVolumeName(oldBucketInfo.getVolumeName()).setBucketName(oldBucketInfo.getBucketName());
            bucketInfoBuilder.addAllMetadata(KeyValueUtil.getFromProtobuf((List)bucketArgs.getMetadataList()));
            StorageType storageType = omBucketArgs.getStorageType();
            if (storageType != null) {
                bucketInfoBuilder.setStorageType(storageType);
                LOG.debug("Updating bucket storage type for bucket: {} in volume: {}", (Object)bucketName, (Object)volumeName);
            } else {
                bucketInfoBuilder.setStorageType(oldBucketInfo.getStorageType());
            }
            Boolean versioning = omBucketArgs.getIsVersionEnabled();
            if (versioning != null) {
                bucketInfoBuilder.setIsVersionEnabled(versioning);
                LOG.debug("Updating bucket versioning for bucket: {} in volume: {}", (Object)bucketName, (Object)volumeName);
            } else {
                bucketInfoBuilder.setIsVersionEnabled(Boolean.valueOf(oldBucketInfo.getIsVersionEnabled()));
            }
            bucketInfoBuilder.setCreationTime(oldBucketInfo.getCreationTime());
            if (oldBucketInfo.getAcls() != null) {
                bucketInfoBuilder.setAcls(oldBucketInfo.getAcls());
            }
            omBucketInfo = bucketInfoBuilder.build();
            omMetadataManager.getBucketTable().addCacheEntry(new CacheKey((Object)bucketKey), new CacheValue(Optional.of((Object)omBucketInfo), transactionLogIndex));
        }
        catch (IOException ex) {
            try {
                exception = ex;
            }
            catch (Throwable throwable) {
                omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                throw throwable;
            }
            omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        }
        omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        this.auditLog(auditLogger, this.buildAuditMessage((AuditAction)OMAction.UPDATE_BUCKET, omBucketArgs.toAuditMap(), exception, userInfo));
        if (exception == null) {
            LOG.debug("Setting bucket property for bucket:{} in volume:{}", (Object)bucketName, (Object)volumeName);
            omResponse.setSetBucketPropertyResponse(OzoneManagerProtocolProtos.SetBucketPropertyResponse.newBuilder().build());
            return new OMBucketSetPropertyResponse(omBucketInfo, omResponse.build());
        }
        LOG.error("Setting bucket property failed for bucket:{} in volume:{}", new Object[]{bucketName, volumeName, exception});
        omMetrics.incNumBucketUpdateFails();
        return new OMBucketSetPropertyResponse(omBucketInfo, this.createErrorOMResponse(omResponse, exception));
    }
}

