/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.file;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.ExcludeList;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.utils.UniqueId;
import org.apache.hadoop.utils.db.Table;
import org.apache.hadoop.utils.db.TableIterator;
import org.apache.hadoop.utils.db.cache.CacheKey;
import org.apache.hadoop.utils.db.cache.CacheValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMFileCreateRequest
extends OMKeyRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMFileCreateRequest.class);

    public OMFileCreateRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        HddsProtos.ReplicationType type;
        OzoneManagerProtocolProtos.CreateFileRequest createFileRequest = this.getOmRequest().getCreateFileRequest();
        Preconditions.checkNotNull((Object)createFileRequest);
        OzoneManagerProtocolProtos.KeyArgs keyArgs = createFileRequest.getKeyArgs();
        if (keyArgs.getKeyName().length() == 0) {
            return this.getOmRequest().toBuilder().setUserInfo(this.getUserInfo()).build();
        }
        long scmBlockSize = ozoneManager.getScmBlockSize();
        long requestedSize = keyArgs.getDataSize() > 0L ? keyArgs.getDataSize() : scmBlockSize;
        boolean useRatis = ozoneManager.shouldUseRatis();
        HddsProtos.ReplicationFactor factor = keyArgs.getFactor();
        if (factor == null) {
            HddsProtos.ReplicationFactor replicationFactor = factor = useRatis ? HddsProtos.ReplicationFactor.THREE : HddsProtos.ReplicationFactor.ONE;
        }
        if ((type = keyArgs.getType()) == null) {
            type = useRatis ? HddsProtos.ReplicationType.RATIS : HddsProtos.ReplicationType.STAND_ALONE;
        }
        List<OmKeyLocationInfo> omKeyLocationInfoList = this.allocateBlock(ozoneManager.getScmClient(), ozoneManager.getBlockTokenSecretManager(), type, factor, new ExcludeList(), requestedSize, scmBlockSize, ozoneManager.getPreallocateBlocksMax(), ozoneManager.isGrpcBlockTokenEnabled(), ozoneManager.getOMNodeId());
        OzoneManagerProtocolProtos.KeyArgs.Builder newKeyArgs = keyArgs.toBuilder().setModificationTime(Time.now()).setType(type).setFactor(factor).setDataSize(requestedSize);
        newKeyArgs.addAllKeyLocations((Iterable)omKeyLocationInfoList.stream().map(OmKeyLocationInfo::getProtobuf).collect(Collectors.toList()));
        OzoneManagerProtocolProtos.CreateFileRequest.Builder newCreateFileRequest = createFileRequest.toBuilder().setKeyArgs(newKeyArgs).setClientID(UniqueId.next());
        return this.getOmRequest().toBuilder().setCreateFileRequest(newCreateFileRequest).setUserInfo(this.getUserInfo()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex) {
        OzoneManagerProtocolProtos.CreateFileRequest createFileRequest = this.getOmRequest().getCreateFileRequest();
        OzoneManagerProtocolProtos.KeyArgs keyArgs = createFileRequest.getKeyArgs();
        String volumeName = keyArgs.getVolumeName();
        String bucketName = keyArgs.getBucketName();
        String keyName = keyArgs.getKeyName();
        boolean isRecursive = createFileRequest.getIsRecursive();
        boolean isOverWrite = createFileRequest.getIsOverwrite();
        OMMetrics omMetrics = ozoneManager.getMetrics();
        omMetrics.incNumCreateFile();
        OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
        boolean acquiredLock = false;
        IOException exception = null;
        Optional<FileEncryptionInfo> encryptionInfo = Optional.absent();
        OmKeyInfo omKeyInfo = null;
        ArrayList<OmKeyLocationInfo> locations = new ArrayList<OmKeyLocationInfo>();
        try {
            boolean canBeCreated;
            if (ozoneManager.getAclsEnabled()) {
                this.checkAcls(ozoneManager, OzoneObj.ResourceType.BUCKET, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE, volumeName, bucketName, keyName);
            }
            acquiredLock = omMetadataManager.getLock().acquireLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            OmBucketInfo bucketInfo = (OmBucketInfo)omMetadataManager.getBucketTable().get((Object)omMetadataManager.getBucketKey(volumeName, bucketName));
            if (bucketInfo == null) {
                throw new OMException("Bucket " + bucketName + " not found", OMException.ResultCodes.BUCKET_NOT_FOUND);
            }
            if (keyName.length() == 0) {
                throw new OMException("Can not write to directory: " + keyName, OMException.ResultCodes.NOT_A_FILE);
            }
            OMFileRequest.OMDirectoryResult omDirectoryResult = OMFileRequest.verifyFilesInPath(omMetadataManager, volumeName, bucketName, keyName, Paths.get(keyName, new String[0]));
            if (omDirectoryResult == OMFileRequest.OMDirectoryResult.FILE_EXISTS) {
                if (!isOverWrite) {
                    throw new OMException("File " + keyName + " already exists", OMException.ResultCodes.FILE_ALREADY_EXISTS);
                }
            } else {
                if (omDirectoryResult == OMFileRequest.OMDirectoryResult.DIRECTORY_EXISTS) {
                    throw new OMException("Can not write to directory: " + keyName, OMException.ResultCodes.NOT_A_FILE);
                }
                if (omDirectoryResult == OMFileRequest.OMDirectoryResult.FILE_EXISTS_IN_GIVENPATH) {
                    throw new OMException("Can not create file: " + keyName + "as there is already file in the given path", OMException.ResultCodes.NOT_A_FILE);
                }
            }
            if (!(isRecursive || omDirectoryResult != OMFileRequest.OMDirectoryResult.NONE && omDirectoryResult != OMFileRequest.OMDirectoryResult.DIRECTORY_EXISTS_IN_GIVENPATH || (canBeCreated = this.checkKeysUnderPath(omMetadataManager, volumeName, bucketName, keyName)))) {
                throw new OMException("Can not create file: " + keyName + "as one of parent directory is not created", OMException.ResultCodes.NOT_A_FILE);
            }
            encryptionInfo = this.getFileEncryptionInfo(ozoneManager, bucketInfo);
            omKeyInfo = this.prepareKeyInfo(omMetadataManager, keyArgs, omMetadataManager.getOzoneKey(volumeName, bucketName, keyName), keyArgs.getDataSize(), locations, (FileEncryptionInfo)encryptionInfo.orNull());
            if (!acquiredLock) return this.prepareCreateKeyResponse(keyArgs, omKeyInfo, locations, (FileEncryptionInfo)encryptionInfo.orNull(), exception, createFileRequest.getClientID(), transactionLogIndex, volumeName, bucketName, keyName, ozoneManager, OMAction.CREATE_FILE);
        }
        catch (IOException ex) {
            try {
                exception = ex;
                if (!acquiredLock) return this.prepareCreateKeyResponse(keyArgs, omKeyInfo, locations, (FileEncryptionInfo)encryptionInfo.orNull(), exception, createFileRequest.getClientID(), transactionLogIndex, volumeName, bucketName, keyName, ozoneManager, OMAction.CREATE_FILE);
            }
            catch (Throwable throwable) {
                if (!acquiredLock) throw throwable;
                omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                throw throwable;
            }
            omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            return this.prepareCreateKeyResponse(keyArgs, omKeyInfo, locations, (FileEncryptionInfo)encryptionInfo.orNull(), exception, createFileRequest.getClientID(), transactionLogIndex, volumeName, bucketName, keyName, ozoneManager, OMAction.CREATE_FILE);
        }
        omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        return this.prepareCreateKeyResponse(keyArgs, omKeyInfo, locations, (FileEncryptionInfo)encryptionInfo.orNull(), exception, createFileRequest.getClientID(), transactionLogIndex, volumeName, bucketName, keyName, ozoneManager, OMAction.CREATE_FILE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkKeysUnderPath(OMMetadataManager omMetadataManager, @Nonnull String volumeName, @Nonnull String bucketName, @Nonnull String keyName) throws IOException {
        Path parentPath = Paths.get(keyName, new String[0]).getParent();
        if (parentPath == null) return true;
        String dbKeyPath = omMetadataManager.getOzoneDirKey(volumeName, bucketName, parentPath.toString());
        Iterator iterator = omMetadataManager.getKeyTable().cacheIterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String key = (String)((CacheKey)entry.getKey()).getCacheKey();
            OmKeyInfo omKeyInfo = (OmKeyInfo)((CacheValue)entry.getValue()).getCacheValue();
            if (!key.startsWith(dbKeyPath) || omKeyInfo == null) continue;
            return true;
        }
        try (TableIterator keyIter = omMetadataManager.getKeyTable().iterator();){
            Table.KeyValue kv = (Table.KeyValue)keyIter.seek((Object)dbKeyPath);
            if (kv == null) return false;
            CacheValue cacheValue = omMetadataManager.getKeyTable().getCacheValue(new CacheKey(kv.getKey()));
            if (cacheValue != null) {
                if (!((String)kv.getKey()).startsWith(dbKeyPath) || cacheValue.getCacheValue() == null) return false;
                boolean bl = true;
                return bl;
            } else {
                if (!((String)kv.getKey()).startsWith(dbKeyPath)) return false;
                boolean bl = true;
                return bl;
            }
        }
    }
}

