/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.file;

import java.io.IOException;
import java.nio.file.Path;
import javax.annotation.Nonnull;
import org.apache.hadoop.ozone.om.OMMetadataManager;

public final class OMFileRequest {
    private OMFileRequest() {
    }

    public static OMDirectoryResult verifyFilesInPath(@Nonnull OMMetadataManager omMetadataManager, @Nonnull String volumeName, @Nonnull String bucketName, @Nonnull String keyName, @Nonnull Path keyPath) throws IOException {
        String fileNameFromDetails = omMetadataManager.getOzoneKey(volumeName, bucketName, keyName);
        String dirNameFromDetails = omMetadataManager.getOzoneDirKey(volumeName, bucketName, keyName);
        while (keyPath != null) {
            String pathName = keyPath.toString();
            String dbKeyName = omMetadataManager.getOzoneKey(volumeName, bucketName, pathName);
            String dbDirKeyName = omMetadataManager.getOzoneDirKey(volumeName, bucketName, pathName);
            if (omMetadataManager.getKeyTable().get((Object)dbKeyName) != null) {
                if (dbKeyName.equals(fileNameFromDetails)) {
                    return OMDirectoryResult.FILE_EXISTS;
                }
                return OMDirectoryResult.FILE_EXISTS_IN_GIVENPATH;
            }
            if (omMetadataManager.getKeyTable().get((Object)dbDirKeyName) != null) {
                if (dbDirKeyName.equals(dirNameFromDetails)) {
                    return OMDirectoryResult.DIRECTORY_EXISTS;
                }
                return OMDirectoryResult.DIRECTORY_EXISTS_IN_GIVENPATH;
            }
            keyPath = keyPath.getParent();
        }
        return OMDirectoryResult.NONE;
    }

    static enum OMDirectoryResult {
        DIRECTORY_EXISTS_IN_GIVENPATH,
        FILE_EXISTS_IN_GIVENPATH,
        FILE_EXISTS,
        DIRECTORY_EXISTS,
        NONE;

    }
}

