/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.OMKeyCommitResponse;
import org.apache.hadoop.ozone.om.response.key.OMKeyCreateResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.utils.db.cache.CacheKey;
import org.apache.hadoop.utils.db.cache.CacheValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMKeyCommitRequest
extends OMKeyRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMKeyCommitRequest.class);

    public OMKeyCommitRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManagerProtocolProtos.CommitKeyRequest commitKeyRequest = this.getOmRequest().getCommitKeyRequest();
        Preconditions.checkNotNull((Object)commitKeyRequest);
        OzoneManagerProtocolProtos.KeyArgs keyArgs = commitKeyRequest.getKeyArgs();
        OzoneManagerProtocolProtos.KeyArgs.Builder newKeyArgs = keyArgs.toBuilder().setModificationTime(Time.now());
        return this.getOmRequest().toBuilder().setCommitKeyRequest(commitKeyRequest.toBuilder().setKeyArgs(newKeyArgs)).setUserInfo(this.getUserInfo()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex) {
        OzoneManagerProtocolProtos.CommitKeyRequest commitKeyRequest = this.getOmRequest().getCommitKeyRequest();
        OzoneManagerProtocolProtos.KeyArgs commitKeyArgs = commitKeyRequest.getKeyArgs();
        String volumeName = commitKeyArgs.getVolumeName();
        String bucketName = commitKeyArgs.getBucketName();
        String keyName = commitKeyArgs.getKeyName();
        OMMetrics omMetrics = ozoneManager.getMetrics();
        omMetrics.incNumKeyCommits();
        AuditLogger auditLogger = ozoneManager.getAuditLogger();
        Map<String, String> auditMap = this.buildKeyArgsAuditMap(commitKeyArgs);
        OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OzoneManagerProtocolProtos.OMResponse.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.CommitKey).setStatus(OzoneManagerProtocolProtos.Status.OK).setSuccess(true);
        try {
            if (ozoneManager.getAclsEnabled()) {
                this.checkAcls(ozoneManager, OzoneObj.ResourceType.KEY, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE, volumeName, bucketName, keyName);
            }
        }
        catch (IOException ex) {
            LOG.error("CommitKey failed for Key: {} in volume/bucket:{}/{}", new Object[]{keyName, bucketName, volumeName, ex});
            omMetrics.incNumKeyCommitFails();
            this.auditLog(auditLogger, this.buildAuditMessage((AuditAction)OMAction.COMMIT_KEY, auditMap, ex, this.getOmRequest().getUserInfo()));
            return new OMKeyCreateResponse(null, -1L, this.createErrorOMResponse(omResponse, ex));
        }
        List locationInfoList = commitKeyArgs.getKeyLocationsList().stream().map(OmKeyLocationInfo::getFromProtobuf).collect(Collectors.toList());
        OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
        String dbOzoneKey = omMetadataManager.getOzoneKey(volumeName, bucketName, keyName);
        String dbOpenKey = omMetadataManager.getOpenKey(volumeName, bucketName, keyName, commitKeyRequest.getClientID());
        omMetadataManager.getLock().acquireLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        IOException exception = null;
        OmKeyInfo omKeyInfo = null;
        try {
            this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
            omKeyInfo = (OmKeyInfo)omMetadataManager.getOpenKeyTable().get((Object)dbOpenKey);
            if (omKeyInfo == null) {
                throw new OMException("Failed to commit key, as " + dbOpenKey + "entry is not found in the openKey table", OMException.ResultCodes.KEY_NOT_FOUND);
            }
            omKeyInfo.setDataSize(commitKeyArgs.getDataSize());
            omKeyInfo.setModificationTime(commitKeyArgs.getModificationTime());
            omKeyInfo.updateLocationInfoList(locationInfoList);
            omMetadataManager.getOpenKeyTable().addCacheEntry(new CacheKey((Object)dbOpenKey), new CacheValue(Optional.absent(), transactionLogIndex));
            omMetadataManager.getKeyTable().addCacheEntry(new CacheKey((Object)dbOzoneKey), new CacheValue(Optional.of((Object)omKeyInfo), transactionLogIndex));
        }
        catch (IOException ex) {
            try {
                exception = ex;
            }
            catch (Throwable throwable) {
                omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                throw throwable;
            }
            omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        }
        omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        this.auditLog(auditLogger, this.buildAuditMessage((AuditAction)OMAction.COMMIT_KEY, auditMap, exception, this.getOmRequest().getUserInfo()));
        if (exception == null) {
            omResponse.setCommitKeyResponse(OzoneManagerProtocolProtos.CommitKeyResponse.newBuilder().build());
            if (omKeyInfo.getKeyLocationVersions().size() == 1) {
                omMetrics.incNumKeys();
            }
            return new OMKeyCommitResponse(omKeyInfo, commitKeyRequest.getClientID(), omResponse.build());
        }
        omMetrics.incNumKeyCommitFails();
        return new OMKeyCommitResponse(null, -1L, this.createErrorOMResponse(omResponse, exception));
    }
}

