/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.OMKeyRenameResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.utils.db.Table;
import org.apache.hadoop.utils.db.cache.CacheKey;
import org.apache.hadoop.utils.db.cache.CacheValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMKeyRenameRequest
extends OMKeyRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMKeyRenameRequest.class);

    public OMKeyRenameRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManagerProtocolProtos.RenameKeyRequest renameKeyRequest = this.getOmRequest().getRenameKeyRequest();
        Preconditions.checkNotNull((Object)renameKeyRequest);
        OzoneManagerProtocolProtos.KeyArgs.Builder newKeyArgs = renameKeyRequest.getKeyArgs().toBuilder().setModificationTime(Time.now());
        return this.getOmRequest().toBuilder().setRenameKeyRequest(renameKeyRequest.toBuilder().setKeyArgs(newKeyArgs)).setUserInfo(this.getUserInfo()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex) {
        OzoneManagerProtocolProtos.RenameKeyRequest renameKeyRequest = this.getOmRequest().getRenameKeyRequest();
        OzoneManagerProtocolProtos.KeyArgs renameKeyArgs = renameKeyRequest.getKeyArgs();
        String volumeName = renameKeyArgs.getVolumeName();
        String bucketName = renameKeyArgs.getBucketName();
        String fromKeyName = renameKeyArgs.getKeyName();
        String toKeyName = renameKeyRequest.getToKeyName();
        OMMetrics omMetrics = ozoneManager.getMetrics();
        omMetrics.incNumKeyRenames();
        AuditLogger auditLogger = ozoneManager.getAuditLogger();
        Map<String, String> auditMap = this.buildKeyArgsAuditMap(renameKeyArgs);
        OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OzoneManagerProtocolProtos.OMResponse.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.CommitKey).setStatus(OzoneManagerProtocolProtos.Status.OK).setSuccess(true);
        try {
            if (toKeyName.length() == 0 || fromKeyName.length() == 0) {
                throw new OMException("Key name is empty", OMException.ResultCodes.INVALID_KEY_NAME);
            }
            if (ozoneManager.getAclsEnabled()) {
                this.checkAcls(ozoneManager, OzoneObj.ResourceType.KEY, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE, volumeName, bucketName, fromKeyName);
            }
        }
        catch (IOException ex) {
            LOG.error("Rename key failed for volume:{} bucket:{} fromKey:{} toKey:{}. Key: {} not found.", new Object[]{volumeName, bucketName, fromKeyName, toKeyName, fromKeyName});
            omMetrics.incNumKeyRenameFails();
            this.auditLog(auditLogger, this.buildAuditMessage((AuditAction)OMAction.RENAME_KEY, auditMap, ex, this.getOmRequest().getUserInfo()));
            return new OMKeyRenameResponse(null, null, null, this.createErrorOMResponse(omResponse, ex));
        }
        OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
        omMetadataManager.getLock().acquireLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        IOException exception = null;
        OmKeyInfo fromKeyValue = null;
        try {
            String fromKey = omMetadataManager.getOzoneKey(volumeName, bucketName, fromKeyName);
            fromKeyValue = (OmKeyInfo)omMetadataManager.getKeyTable().get((Object)fromKey);
            if (fromKeyValue == null) {
                throw new OMException("Key not found " + fromKey, OMException.ResultCodes.KEY_NOT_FOUND);
            }
            String toKey = omMetadataManager.getOzoneKey(volumeName, bucketName, toKeyName);
            OmKeyInfo toKeyValue = (OmKeyInfo)omMetadataManager.getKeyTable().get((Object)toKey);
            if (toKeyValue != null) {
                throw new OMException("Key already exists " + toKeyName, OMException.ResultCodes.KEY_ALREADY_EXISTS);
            }
            fromKeyValue.setKeyName(toKeyName);
            fromKeyValue.setModificationTime(renameKeyArgs.getModificationTime());
            Table keyTable = omMetadataManager.getKeyTable();
            keyTable.addCacheEntry(new CacheKey((Object)fromKey), new CacheValue(Optional.absent(), transactionLogIndex));
            keyTable.addCacheEntry(new CacheKey((Object)toKey), new CacheValue(Optional.of((Object)fromKeyValue), transactionLogIndex));
        }
        catch (IOException ex) {
            try {
                exception = ex;
            }
            catch (Throwable throwable) {
                omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                throw throwable;
            }
            omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        }
        omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        this.auditLog(auditLogger, this.buildAuditMessage((AuditAction)OMAction.RENAME_KEY, auditMap, exception, this.getOmRequest().getUserInfo()));
        if (exception == null) {
            return new OMKeyRenameResponse(fromKeyValue, toKeyName, fromKeyName, omResponse.setRenameKeyResponse(OzoneManagerProtocolProtos.RenameKeyResponse.newBuilder()).build());
        }
        LOG.error("Rename key failed for volume:{} bucket:{} fromKey:{} toKey:{}. Key: {} not found.", new Object[]{volumeName, bucketName, fromKeyName, toKeyName, fromKeyName});
        return new OMKeyRenameResponse(null, null, null, this.createErrorOMResponse(omResponse, exception));
    }
}

