/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.s3.multipart;

import com.google.common.base.Optional;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartKeyInfo;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.s3.multipart.S3MultipartUploadCommitPartResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.utils.db.cache.CacheKey;
import org.apache.hadoop.utils.db.cache.CacheValue;

public class S3MultipartUploadCommitPartRequest
extends OMKeyRequest {
    public S3MultipartUploadCommitPartRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) {
        OzoneManagerProtocolProtos.MultipartCommitUploadPartRequest multipartCommitUploadPartRequest = this.getOmRequest().getCommitMultiPartUploadRequest();
        return this.getOmRequest().toBuilder().setCommitMultiPartUploadRequest(multipartCommitUploadPartRequest.toBuilder().setKeyArgs(multipartCommitUploadPartRequest.getKeyArgs().toBuilder().setModificationTime(Time.now()))).setUserInfo(this.getUserInfo()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex) {
        multipartCommitUploadPartRequest = this.getOmRequest().getCommitMultiPartUploadRequest();
        keyArgs = multipartCommitUploadPartRequest.getKeyArgs();
        volumeName = keyArgs.getVolumeName();
        bucketName = keyArgs.getBucketName();
        keyName = keyArgs.getKeyName();
        omMetadataManager = ozoneManager.getMetadataManager();
        ozoneManager.getMetrics().incNumCommitMultipartUploadParts();
        acquiredLock = false;
        multipartKeyInfo = null;
        omKeyInfo = null;
        openKey = null;
        multipartKey = null;
        oldPartKeyInfo = null;
        exception = null;
        partName = null;
        try {
            if (ozoneManager.getAclsEnabled()) {
                this.checkAcls(ozoneManager, OzoneObj.ResourceType.KEY, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE, volumeName, bucketName, keyName);
            }
            acquiredLock = omMetadataManager.getLock().acquireLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
            uploadID = keyArgs.getMultipartUploadID();
            multipartKey = omMetadataManager.getMultipartKey(volumeName, bucketName, keyName, uploadID);
            multipartKeyInfo = (OmMultipartKeyInfo)omMetadataManager.getMultipartInfoTable().get((Object)multipartKey);
            clientID = multipartCommitUploadPartRequest.getClientID();
            openKey = omMetadataManager.getOpenKey(volumeName, bucketName, keyName, clientID);
            omKeyInfo = (OmKeyInfo)omMetadataManager.getOpenKeyTable().get((Object)openKey);
            if (omKeyInfo == null) {
                throw new OMException("Failed to commit Multipart Upload key, as " + openKey + "entry is not found in the openKey table", OMException.ResultCodes.KEY_NOT_FOUND);
            }
            omKeyInfo.setDataSize(keyArgs.getDataSize());
            omKeyInfo.updateLocationInfoList(keyArgs.getKeyLocationsList().stream().map((Function<OzoneManagerProtocolProtos.KeyLocation, OmKeyLocationInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getFromProtobuf(org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$KeyLocation ), (Lorg/apache/hadoop/ozone/protocol/proto/OzoneManagerProtocolProtos$KeyLocation;)Lorg/apache/hadoop/ozone/om/helpers/OmKeyLocationInfo;)()).collect(Collectors.toList()));
            omKeyInfo.setModificationTime(keyArgs.getModificationTime());
            partName = omMetadataManager.getOzoneKey(volumeName, bucketName, keyName) + clientID;
            if (multipartKeyInfo == null) {
                throw new OMException("No such Multipart upload is with specified uploadId " + uploadID, OMException.ResultCodes.NO_SUCH_MULTIPART_UPLOAD_ERROR);
            }
            partNumber = keyArgs.getMultipartNumber();
            oldPartKeyInfo = multipartKeyInfo.getPartKeyInfo(partNumber);
            partKeyInfo = OzoneManagerProtocolProtos.PartKeyInfo.newBuilder();
            partKeyInfo.setPartName(partName);
            partKeyInfo.setPartNumber(partNumber);
            partKeyInfo.setPartKeyInfo(omKeyInfo.getProtobuf());
            multipartKeyInfo.addPartKeyInfo(partNumber, partKeyInfo.build());
            omMetadataManager.getMultipartInfoTable().addCacheEntry(new CacheKey((Object)multipartKey), new CacheValue(Optional.of((Object)multipartKeyInfo), transactionLogIndex));
            omMetadataManager.getOpenKeyTable().addCacheEntry(new CacheKey((Object)openKey), new CacheValue(Optional.absent(), transactionLogIndex));
            ** if (!acquiredLock) goto lbl-1000
        }
        catch (IOException ex) {
            try {
                exception = ex;
                ** if (!acquiredLock) goto lbl-1000
            }
            catch (Throwable var23_22) {
                if (acquiredLock) {
                    omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                }
                throw var23_22;
            }
lbl-1000:
            // 1 sources

            {
                omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            }
lbl-1000:
            // 2 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        }
lbl-1000:
        // 2 sources

        {
        }
        this.auditLog(ozoneManager.getAuditLogger(), this.buildAuditMessage((AuditAction)OMAction.COMMIT_MULTIPART_UPLOAD_PARTKEY, this.buildKeyArgsAuditMap(keyArgs), exception, this.getOmRequest().getUserInfo()));
        omResponse = OzoneManagerProtocolProtos.OMResponse.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.CommitMultiPartUpload).setStatus(OzoneManagerProtocolProtos.Status.OK).setSuccess(true);
        if (exception == null) {
            omResponse.setCommitMultiPartUploadResponse(OzoneManagerProtocolProtos.MultipartCommitUploadPartResponse.newBuilder().setPartName(partName));
            return new S3MultipartUploadCommitPartResponse(multipartKey, openKey, keyArgs.getModificationTime(), omKeyInfo, multipartKeyInfo, oldPartKeyInfo, omResponse.build());
        }
        ozoneManager.getMetrics().incNumCommitMultipartUploadPartFails();
        return new S3MultipartUploadCommitPartResponse(multipartKey, openKey, keyArgs.getModificationTime(), omKeyInfo, multipartKeyInfo, oldPartKeyInfo, this.createErrorOMResponse(omResponse, exception));
    }
}

