/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.volume;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.volume.OMVolumeRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.volume.OMVolumeCreateResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMVolumeCreateRequest
extends OMVolumeRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMVolumeCreateRequest.class);

    public OMVolumeCreateRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManagerProtocolProtos.VolumeInfo volumeInfo = this.getOmRequest().getCreateVolumeRequest().getVolumeInfo();
        OzoneManagerProtocolProtos.VolumeInfo updatedVolumeInfo = volumeInfo.toBuilder().setCreationTime(Time.now()).build();
        return this.getOmRequest().toBuilder().setCreateVolumeRequest(OzoneManagerProtocolProtos.CreateVolumeRequest.newBuilder().setVolumeInfo(updatedVolumeInfo)).setUserInfo(this.getUserInfo()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex) {
        IOException exception;
        OzoneManagerProtocolProtos.VolumeList volumeList;
        OzoneManagerProtocolProtos.UserInfo userInfo;
        AuditLogger auditLogger;
        OMMetadataManager omMetadataManager;
        OmVolumeArgs omVolumeArgs;
        OzoneManagerProtocolProtos.OMResponse.Builder omResponse;
        String owner;
        String volume;
        OMMetrics omMetrics;
        OzoneManagerProtocolProtos.VolumeInfo volumeInfo;
        block10: {
            OzoneManagerProtocolProtos.CreateVolumeRequest createVolumeRequest = this.getOmRequest().getCreateVolumeRequest();
            Preconditions.checkNotNull((Object)createVolumeRequest);
            volumeInfo = createVolumeRequest.getVolumeInfo();
            omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumVolumeCreates();
            volume = volumeInfo.getVolume();
            owner = volumeInfo.getOwnerName();
            omResponse = OzoneManagerProtocolProtos.OMResponse.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.CreateVolume).setStatus(OzoneManagerProtocolProtos.Status.OK).setSuccess(true);
            omVolumeArgs = null;
            omMetadataManager = ozoneManager.getMetadataManager();
            auditLogger = ozoneManager.getAuditLogger();
            userInfo = this.getOmRequest().getUserInfo();
            try {
                omVolumeArgs = OmVolumeArgs.getFromProtobuf((OzoneManagerProtocolProtos.VolumeInfo)volumeInfo);
                if (ozoneManager.getAclsEnabled()) {
                    this.checkAcls(ozoneManager, OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.CREATE, volume, null, null);
                }
            }
            catch (IOException ex) {
                omMetrics.incNumVolumeCreateFails();
                this.auditLog(auditLogger, this.buildAuditMessage((AuditAction)OMAction.CREATE_VOLUME, this.buildVolumeAuditMap(volume), ex, userInfo));
                LOG.error("Volume creation failed for user:{} volume:{}", new Object[]{owner, volume, ex});
                return new OMVolumeCreateResponse(omVolumeArgs, null, this.createErrorOMResponse(omResponse, ex));
            }
            volumeList = null;
            boolean acquiredUserLock = false;
            exception = null;
            omMetadataManager.getLock().acquireLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
            try {
                acquiredUserLock = omMetadataManager.getLock().acquireLock(OzoneManagerLock.Resource.USER_LOCK, new String[]{owner});
                String dbVolumeKey = omMetadataManager.getVolumeKey(volume);
                OmVolumeArgs dbVolumeArgs = (OmVolumeArgs)omMetadataManager.getVolumeTable().get((Object)dbVolumeKey);
                if (dbVolumeArgs != null) {
                    LOG.debug("volume:{} already exists", (Object)omVolumeArgs.getVolume());
                    throw new OMException("Volume already exists", OMException.ResultCodes.VOLUME_ALREADY_EXISTS);
                }
                String dbUserKey = omMetadataManager.getUserKey(owner);
                volumeList = (OzoneManagerProtocolProtos.VolumeList)omMetadataManager.getUserTable().get((Object)dbUserKey);
                volumeList = this.addVolumeToOwnerList(volumeList, volume, owner, ozoneManager.getMaxUserVolumeCount());
                this.createVolume(omMetadataManager, omVolumeArgs, volumeList, dbVolumeKey, dbUserKey, transactionLogIndex);
                LOG.debug("volume:{} successfully created", (Object)omVolumeArgs.getVolume());
                if (!acquiredUserLock) break block10;
            }
            catch (IOException ex) {
                block11: {
                    try {
                        exception = ex;
                        if (!acquiredUserLock) break block11;
                    }
                    catch (Throwable throwable) {
                        if (acquiredUserLock) {
                            omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.USER_LOCK, new String[]{owner});
                        }
                        omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
                        throw throwable;
                    }
                    omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.USER_LOCK, new String[]{owner});
                }
                omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
            }
            omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.USER_LOCK, new String[]{owner});
        }
        omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
        this.auditLog(auditLogger, this.buildAuditMessage((AuditAction)OMAction.CREATE_VOLUME, omVolumeArgs.toAuditMap(), exception, userInfo));
        if (exception == null) {
            LOG.debug("created volume:{} for user:{}", (Object)omVolumeArgs.getVolume(), (Object)owner);
            omMetrics.incNumVolumes();
            omResponse.setCreateVolumeResponse(OzoneManagerProtocolProtos.CreateVolumeResponse.newBuilder().build());
            return new OMVolumeCreateResponse(omVolumeArgs, volumeList, omResponse.build());
        }
        LOG.error("Volume creation failed for user:{} volume:{}", new Object[]{owner, volumeInfo.getVolume(), exception});
        omMetrics.incNumVolumeCreateFails();
        return new OMVolumeCreateResponse(omVolumeArgs, volumeList, this.createErrorOMResponse(omResponse, exception));
    }
}

