/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.volume;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.volume.OMVolumeRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.volume.OMVolumeCreateResponse;
import org.apache.hadoop.ozone.om.response.volume.OMVolumeDeleteResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.utils.db.cache.CacheKey;
import org.apache.hadoop.utils.db.cache.CacheValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMVolumeDeleteRequest
extends OMVolumeRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMVolumeDeleteRequest.class);

    public OMVolumeDeleteRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex) {
        OzoneManagerProtocolProtos.VolumeList newVolumeList;
        IOException exception;
        String owner;
        OMMetadataManager omMetadataManager;
        OzoneManagerProtocolProtos.UserInfo userInfo;
        AuditLogger auditLogger;
        OzoneManagerProtocolProtos.OMResponse.Builder omResponse;
        OMMetrics omMetrics;
        String volume;
        block10: {
            OzoneManagerProtocolProtos.DeleteVolumeRequest deleteVolumeRequest = this.getOmRequest().getDeleteVolumeRequest();
            Preconditions.checkNotNull((Object)deleteVolumeRequest);
            volume = deleteVolumeRequest.getVolumeName();
            omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumVolumeDeletes();
            omResponse = OzoneManagerProtocolProtos.OMResponse.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.DeleteVolume).setStatus(OzoneManagerProtocolProtos.Status.OK).setSuccess(true);
            auditLogger = ozoneManager.getAuditLogger();
            userInfo = this.getOmRequest().getUserInfo();
            try {
                if (ozoneManager.getAclsEnabled()) {
                    this.checkAcls(ozoneManager, OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.DELETE, volume, null, null);
                }
            }
            catch (IOException ex) {
                LOG.error("Volume deletion failed for volume:{}", (Object)volume, (Object)ex);
                omMetrics.incNumVolumeDeleteFails();
                this.auditLog(auditLogger, this.buildAuditMessage((AuditAction)OMAction.DELETE_VOLUME, this.buildVolumeAuditMap(volume), ex, userInfo));
                return new OMVolumeCreateResponse(null, null, this.createErrorOMResponse(omResponse, ex));
            }
            omMetadataManager = ozoneManager.getMetadataManager();
            Object omVolumeArgs = null;
            owner = null;
            boolean acquiredUserLock = false;
            exception = null;
            newVolumeList = null;
            omMetadataManager.getLock().acquireLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
            try {
                owner = this.getVolumeInfo(omMetadataManager, volume).getOwnerName();
                acquiredUserLock = omMetadataManager.getLock().acquireLock(OzoneManagerLock.Resource.USER_LOCK, new String[]{owner});
                String dbUserKey = omMetadataManager.getUserKey(owner);
                String dbVolumeKey = omMetadataManager.getVolumeKey(volume);
                if (!omMetadataManager.isVolumeEmpty(volume)) {
                    LOG.debug("volume:{} is not empty", (Object)volume);
                    throw new OMException(OMException.ResultCodes.VOLUME_NOT_EMPTY);
                }
                newVolumeList = (OzoneManagerProtocolProtos.VolumeList)omMetadataManager.getUserTable().get((Object)owner);
                newVolumeList = this.delVolumeFromOwnerList(newVolumeList, volume, owner);
                omMetadataManager.getUserTable().addCacheEntry(new CacheKey((Object)dbUserKey), new CacheValue(Optional.of((Object)newVolumeList), transactionLogIndex));
                omMetadataManager.getVolumeTable().addCacheEntry(new CacheKey((Object)dbVolumeKey), new CacheValue(Optional.absent(), transactionLogIndex));
                if (!acquiredUserLock) break block10;
            }
            catch (IOException ex) {
                block11: {
                    try {
                        exception = ex;
                        if (!acquiredUserLock) break block11;
                    }
                    catch (Throwable throwable) {
                        if (acquiredUserLock) {
                            omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.USER_LOCK, new String[]{owner});
                        }
                        omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
                        throw throwable;
                    }
                    omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.USER_LOCK, new String[]{owner});
                }
                omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
            }
            omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.USER_LOCK, new String[]{owner});
        }
        omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
        this.auditLog(auditLogger, this.buildAuditMessage((AuditAction)OMAction.DELETE_VOLUME, this.buildVolumeAuditMap(volume), exception, userInfo));
        if (exception == null) {
            LOG.debug("Volume deleted for user:{} volume:{}", (Object)owner, (Object)volume);
            omMetrics.decNumVolumes();
            omResponse.setDeleteVolumeResponse(OzoneManagerProtocolProtos.DeleteVolumeResponse.newBuilder().build());
            return new OMVolumeDeleteResponse(volume, owner, newVolumeList, omResponse.build());
        }
        LOG.error("Volume deletion failed for user:{} volume:{}", new Object[]{owner, volume, exception});
        omMetrics.incNumVolumeDeleteFails();
        return new OMVolumeDeleteResponse(null, null, null, this.createErrorOMResponse(omResponse, exception));
    }

    private OmVolumeArgs getVolumeInfo(OMMetadataManager omMetadataManager, String volume) throws IOException {
        String dbVolumeKey = omMetadataManager.getVolumeKey(volume);
        OmVolumeArgs volumeArgs = (OmVolumeArgs)omMetadataManager.getVolumeTable().get((Object)dbVolumeKey);
        if (volumeArgs == null) {
            throw new OMException("Volume " + volume + " is not found", OMException.ResultCodes.VOLUME_NOT_FOUND);
        }
        return volumeArgs;
    }
}

