/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.volume;

import com.google.common.base.Optional;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.utils.db.cache.CacheKey;
import org.apache.hadoop.utils.db.cache.CacheValue;

public abstract class OMVolumeRequest
extends OMClientRequest {
    public OMVolumeRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    protected OzoneManagerProtocolProtos.VolumeList delVolumeFromOwnerList(OzoneManagerProtocolProtos.VolumeList volumeList, String volume, String owner) throws IOException {
        ArrayList prevVolList = new ArrayList();
        if (volumeList == null) {
            throw new OMException("User not found: " + owner, OMException.ResultCodes.USER_NOT_FOUND);
        }
        prevVolList.addAll(volumeList.getVolumeNamesList());
        prevVolList.remove(volume);
        OzoneManagerProtocolProtos.VolumeList newVolList = OzoneManagerProtocolProtos.VolumeList.newBuilder().addAllVolumeNames(prevVolList).build();
        return newVolList;
    }

    protected OzoneManagerProtocolProtos.VolumeList addVolumeToOwnerList(OzoneManagerProtocolProtos.VolumeList volumeList, String volume, String owner, long maxUserVolumeCount) throws IOException {
        if (volumeList != null && (long)volumeList.getVolumeNamesList().size() >= maxUserVolumeCount) {
            throw new OMException("Too many volumes for user:" + owner, OMException.ResultCodes.USER_TOO_MANY_VOLUMES);
        }
        ArrayList<String> prevVolList = new ArrayList<String>();
        if (volumeList != null) {
            prevVolList.addAll(volumeList.getVolumeNamesList());
        }
        prevVolList.add(volume);
        OzoneManagerProtocolProtos.VolumeList newVolList = OzoneManagerProtocolProtos.VolumeList.newBuilder().addAllVolumeNames(prevVolList).build();
        return newVolList;
    }

    protected void createVolume(OMMetadataManager omMetadataManager, OmVolumeArgs omVolumeArgs, OzoneManagerProtocolProtos.VolumeList volumeList, String dbVolumeKey, String dbUserKey, long transactionLogIndex) {
        omMetadataManager.getUserTable().addCacheEntry(new CacheKey((Object)dbUserKey), new CacheValue(Optional.of((Object)volumeList), transactionLogIndex));
        omMetadataManager.getVolumeTable().addCacheEntry(new CacheKey((Object)dbVolumeKey), new CacheValue(Optional.of((Object)omVolumeArgs), transactionLogIndex));
    }
}

