/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.volume;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.volume.OMVolumeRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.volume.OMVolumeSetQuotaResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.utils.db.cache.CacheKey;
import org.apache.hadoop.utils.db.cache.CacheValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMVolumeSetQuotaRequest
extends OMVolumeRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMVolumeSetQuotaRequest.class);

    public OMVolumeSetQuotaRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex) {
        OzoneManagerProtocolProtos.SetVolumePropertyRequest setVolumePropertyRequest = this.getOmRequest().getSetVolumePropertyRequest();
        Preconditions.checkNotNull((Object)setVolumePropertyRequest);
        OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OzoneManagerProtocolProtos.OMResponse.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.SetVolumeProperty).setStatus(OzoneManagerProtocolProtos.Status.OK).setSuccess(true);
        if (!setVolumePropertyRequest.hasQuotaInBytes()) {
            omResponse.setStatus(OzoneManagerProtocolProtos.Status.INVALID_REQUEST).setSuccess(false);
            return new OMVolumeSetQuotaResponse(null, omResponse.build());
        }
        String volume = setVolumePropertyRequest.getVolumeName();
        OMMetrics omMetrics = ozoneManager.getMetrics();
        omMetrics.incNumVolumeUpdates();
        AuditLogger auditLogger = ozoneManager.getAuditLogger();
        OzoneManagerProtocolProtos.UserInfo userInfo = this.getOmRequest().getUserInfo();
        Map<String, String> auditMap = this.buildVolumeAuditMap(volume);
        auditMap.put("quota", String.valueOf(setVolumePropertyRequest.getQuotaInBytes()));
        try {
            if (ozoneManager.getAclsEnabled()) {
                this.checkAcls(ozoneManager, OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE, volume, null, null);
            }
        }
        catch (IOException ex) {
            LOG.error("Changing volume quota failed for volume:{} quota:{}", new Object[]{volume, setVolumePropertyRequest.getQuotaInBytes(), ex});
            omMetrics.incNumVolumeUpdateFails();
            this.auditLog(auditLogger, this.buildAuditMessage((AuditAction)OMAction.SET_QUOTA, auditMap, ex, userInfo));
            return new OMVolumeSetQuotaResponse(null, this.createErrorOMResponse(omResponse, ex));
        }
        OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
        IOException exception = null;
        OmVolumeArgs omVolumeArgs = null;
        omMetadataManager.getLock().acquireLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
        try {
            String dbVolumeKey = omMetadataManager.getVolumeKey(volume);
            omVolumeArgs = (OmVolumeArgs)omMetadataManager.getVolumeTable().get((Object)dbVolumeKey);
            if (omVolumeArgs == null) {
                LOG.debug("volume:{} does not exist", (Object)volume);
                throw new OMException(OMException.ResultCodes.VOLUME_NOT_FOUND);
            }
            omVolumeArgs.setQuotaInBytes(setVolumePropertyRequest.getQuotaInBytes());
            omMetadataManager.getVolumeTable().addCacheEntry(new CacheKey((Object)dbVolumeKey), new CacheValue(Optional.of((Object)omVolumeArgs), transactionLogIndex));
        }
        catch (IOException ex) {
            try {
                exception = ex;
            }
            catch (Throwable throwable) {
                omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
                throw throwable;
            }
            omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
        }
        omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
        this.auditLog(auditLogger, this.buildAuditMessage((AuditAction)OMAction.SET_QUOTA, auditMap, exception, userInfo));
        if (exception == null) {
            omResponse.setSetVolumePropertyResponse(OzoneManagerProtocolProtos.SetVolumePropertyResponse.newBuilder().build());
            return new OMVolumeSetQuotaResponse(omVolumeArgs, omResponse.build());
        }
        omMetrics.incNumVolumeUpdateFails();
        LOG.error("Changing volume quota failed for volume:{} quota:{}", new Object[]{volume, setVolumePropertyRequest.getQuotaInBytes(), exception});
        return new OMVolumeSetQuotaResponse(null, this.createErrorOMResponse(omResponse, exception));
    }
}

