/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.key;

import java.io.IOException;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.utils.db.BatchOperation;

public class OMKeyRenameResponse
extends OMClientResponse {
    private final OmKeyInfo renameKeyInfo;
    private final String toKeyName;
    private final String fromKeyName;

    public OMKeyRenameResponse(OmKeyInfo renameKeyInfo, String toKeyName, String fromKeyName, OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
        this.renameKeyInfo = renameKeyInfo;
        this.toKeyName = toKeyName;
        this.fromKeyName = fromKeyName;
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        if (this.getOMResponse().getStatus() == OzoneManagerProtocolProtos.Status.OK && !this.toKeyName.equals(this.fromKeyName)) {
            String volumeName = this.renameKeyInfo.getVolumeName();
            String bucketName = this.renameKeyInfo.getBucketName();
            omMetadataManager.getKeyTable().deleteWithBatch(batchOperation, (Object)omMetadataManager.getOzoneKey(volumeName, bucketName, this.fromKeyName));
            omMetadataManager.getKeyTable().putWithBatch(batchOperation, (Object)omMetadataManager.getOzoneKey(volumeName, bucketName, this.toKeyName), (Object)this.renameKeyInfo);
        }
    }
}

