/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.s3.bucket;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.bucket.OMBucketCreateResponse;
import org.apache.hadoop.ozone.om.response.volume.OMVolumeCreateResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.utils.db.BatchOperation;

public class S3BucketCreateResponse
extends OMClientResponse {
    private OMVolumeCreateResponse omVolumeCreateResponse;
    private OMBucketCreateResponse omBucketCreateResponse;
    private String s3Bucket;
    private String s3Mapping;

    public S3BucketCreateResponse(@Nullable OMVolumeCreateResponse omVolumeCreateResponse, @Nullable OMBucketCreateResponse omBucketCreateResponse, @Nullable String s3BucketName, @Nullable String s3Mapping, @Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
        this.omVolumeCreateResponse = omVolumeCreateResponse;
        this.omBucketCreateResponse = omBucketCreateResponse;
        this.s3Bucket = s3BucketName;
        this.s3Mapping = s3Mapping;
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        if (this.getOMResponse().getStatus() == OzoneManagerProtocolProtos.Status.OK) {
            if (this.omVolumeCreateResponse != null) {
                this.omVolumeCreateResponse.addToDBBatch(omMetadataManager, batchOperation);
            }
            Preconditions.checkState((this.omBucketCreateResponse != null ? 1 : 0) != 0);
            this.omBucketCreateResponse.addToDBBatch(omMetadataManager, batchOperation);
            omMetadataManager.getS3Table().putWithBatch(batchOperation, (Object)this.s3Bucket, (Object)this.s3Mapping);
        }
    }

    @VisibleForTesting
    public String getS3Mapping() {
        return this.s3Mapping;
    }
}

