/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.s3.bucket;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.utils.db.BatchOperation;

public class S3BucketDeleteResponse
extends OMClientResponse {
    private String s3BucketName;
    private String volumeName;

    public S3BucketDeleteResponse(@Nullable String s3BucketName, @Nullable String volumeName, @Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
        this.s3BucketName = s3BucketName;
        this.volumeName = volumeName;
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        if (this.getOMResponse().getStatus() == OzoneManagerProtocolProtos.Status.OK) {
            omMetadataManager.getBucketTable().deleteWithBatch(batchOperation, (Object)omMetadataManager.getBucketKey(this.volumeName, this.s3BucketName));
            omMetadataManager.getS3Table().deleteWithBatch(batchOperation, (Object)this.s3BucketName);
        }
    }
}

