/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.volume;

import java.io.IOException;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.utils.db.BatchOperation;

public class OMVolumeSetOwnerResponse
extends OMClientResponse {
    private String oldOwner;
    private OzoneManagerProtocolProtos.VolumeList oldOwnerVolumeList;
    private OzoneManagerProtocolProtos.VolumeList newOwnerVolumeList;
    private OmVolumeArgs newOwnerVolumeArgs;

    public OMVolumeSetOwnerResponse(String oldOwner, OzoneManagerProtocolProtos.VolumeList oldOwnerVolumeList, OzoneManagerProtocolProtos.VolumeList newOwnerVolumeList, OmVolumeArgs newOwnerVolumeArgs, OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
        this.oldOwner = oldOwner;
        this.oldOwnerVolumeList = oldOwnerVolumeList;
        this.newOwnerVolumeList = newOwnerVolumeList;
        this.newOwnerVolumeArgs = newOwnerVolumeArgs;
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        if (this.getOMResponse().getStatus() == OzoneManagerProtocolProtos.Status.OK) {
            String oldOwnerKey = omMetadataManager.getUserKey(this.oldOwner);
            String newOwnerKey = omMetadataManager.getUserKey(this.newOwnerVolumeArgs.getOwnerName());
            if (this.oldOwnerVolumeList.getVolumeNamesList().size() == 0) {
                omMetadataManager.getUserTable().deleteWithBatch(batchOperation, (Object)oldOwnerKey);
            } else {
                omMetadataManager.getUserTable().putWithBatch(batchOperation, (Object)oldOwnerKey, (Object)this.oldOwnerVolumeList);
            }
            omMetadataManager.getUserTable().putWithBatch(batchOperation, (Object)newOwnerKey, (Object)this.newOwnerVolumeList);
            String dbVolumeKey = omMetadataManager.getVolumeKey(this.newOwnerVolumeArgs.getVolume());
            omMetadataManager.getVolumeTable().putWithBatch(batchOperation, (Object)dbVolumeKey, (Object)this.newOwnerVolumeArgs);
        }
    }
}

