/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.snapshot;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.ozone.om.OMConfigKeys;
import org.apache.hadoop.ozone.om.OMNodeDetails;
import org.apache.hadoop.utils.db.DBCheckpoint;
import org.apache.hadoop.utils.db.RocksDBCheckpoint;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OzoneManagerSnapshotProvider {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneManagerSnapshotProvider.class);
    private final File omSnapshotDir;
    private Map<String, OMNodeDetails> peerNodesMap;
    private final HttpConfig.Policy httpPolicy;
    private final RequestConfig httpRequestConfig;
    private CloseableHttpClient httpClient;
    private static final String OM_SNAPSHOT_DB = "om.snapshot.db";

    public OzoneManagerSnapshotProvider(Configuration conf, File omRatisSnapshotDir, List<OMNodeDetails> peerNodes) {
        LOG.info("Initializing OM Snapshot Provider");
        this.omSnapshotDir = omRatisSnapshotDir;
        this.peerNodesMap = new HashMap<String, OMNodeDetails>();
        for (OMNodeDetails peerNode : peerNodes) {
            this.peerNodesMap.put(peerNode.getOMNodeId(), peerNode);
        }
        this.httpPolicy = DFSUtil.getHttpPolicy((Configuration)conf);
        this.httpRequestConfig = this.getHttpRequestConfig(conf);
    }

    private RequestConfig getHttpRequestConfig(Configuration conf) {
        TimeUnit socketTimeoutUnit = OMConfigKeys.OZONE_OM_SNAPSHOT_PROVIDER_SOCKET_TIMEOUT_DEFAULT.getUnit();
        int socketTimeoutMS = (int)conf.getTimeDuration("ozone.om.snapshot.provider.socket.timeout", OMConfigKeys.OZONE_OM_SNAPSHOT_PROVIDER_SOCKET_TIMEOUT_DEFAULT.getDuration(), socketTimeoutUnit);
        TimeUnit connectionTimeoutUnit = OMConfigKeys.OZONE_OM_SNAPSHOT_PROVIDER_CONNECTION_TIMEOUT_DEFAULT.getUnit();
        int connectionTimeoutMS = (int)conf.getTimeDuration("ozone.om.snapshot.provider.connection.timeout", OMConfigKeys.OZONE_OM_SNAPSHOT_PROVIDER_CONNECTION_TIMEOUT_DEFAULT.getDuration(), connectionTimeoutUnit);
        TimeUnit requestTimeoutUnit = OMConfigKeys.OZONE_OM_SNAPSHOT_PROVIDER_REQUEST_TIMEOUT_DEFAULT.getUnit();
        int requestTimeoutMS = (int)conf.getTimeDuration("ozone.om.snapshot.provider.request.timeout", OMConfigKeys.OZONE_OM_SNAPSHOT_PROVIDER_REQUEST_TIMEOUT_DEFAULT.getDuration(), requestTimeoutUnit);
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(socketTimeoutMS).setConnectTimeout(connectionTimeoutMS).setConnectionRequestTimeout(requestTimeoutMS).build();
        return requestConfig;
    }

    private HttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = HttpClientBuilder.create().setDefaultRequestConfig(this.httpRequestConfig).build();
        }
        return this.httpClient;
    }

    private void closeHttpClient() throws IOException {
        if (this.httpClient != null) {
            this.httpClient.close();
            this.httpClient = null;
        }
    }

    public DBCheckpoint getOzoneManagerDBSnapshot(String leaderOMNodeID) throws IOException {
        String snapshotFileName = "om.snapshot.db_" + System.currentTimeMillis();
        File targetFile = new File(this.omSnapshotDir, snapshotFileName + ".tar.gz");
        String omCheckpointUrl = this.peerNodesMap.get(leaderOMNodeID).getOMDBCheckpointEnpointUrl(this.httpPolicy);
        LOG.info("Downloading latest checkpoint from Leader OM {}. Checkpoint URL: {}", (Object)leaderOMNodeID, (Object)omCheckpointUrl);
        try {
            HttpGet httpGet = new HttpGet(omCheckpointUrl);
            HttpResponse response = this.getHttpClient().execute((HttpUriRequest)httpGet);
            int errorCode = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            if (errorCode == 200 || errorCode == 201) {
                Header header = response.getFirstHeader("ratisSnapshotIndex");
                if (header == null) {
                    throw new IOException("The HTTP response header ratisSnapshotIndex is missing.");
                }
                long snapshotIndex = Long.parseLong(header.getValue());
                try (InputStream inputStream = entity.getContent();){
                    FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)targetFile);
                }
                Path untarredDbDir = Paths.get(this.omSnapshotDir.getAbsolutePath(), snapshotFileName);
                FileUtil.unTar((File)targetFile, (File)untarredDbDir.toFile());
                FileUtils.deleteQuietly((File)targetFile);
                LOG.info("Sucessfully downloaded latest checkpoint with snapshot index {} from leader OM: {}", (Object)snapshotIndex, (Object)leaderOMNodeID);
                RocksDBCheckpoint omCheckpoint = new RocksDBCheckpoint(untarredDbDir);
                omCheckpoint.setRatisSnapshotIndex(snapshotIndex);
                RocksDBCheckpoint rocksDBCheckpoint = omCheckpoint;
                return rocksDBCheckpoint;
            }
            if (entity != null) {
                throw new IOException("Unexpected exception when trying to reach OM to download latest checkpoint. Checkpoint URL: " + omCheckpointUrl + ". Entity: " + EntityUtils.toString((HttpEntity)entity));
            }
            throw new IOException("Unexpected null in http payload, while processing request to OM to download latest checkpoint. Checkpoint Url: " + omCheckpointUrl);
        }
        finally {
            this.closeHttpClient();
        }
    }
}

